/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.configs.forge;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.telepathicgrunt.the_bumblezone.configs.forge.BzBeeAggressionConfig;
import com.telepathicgrunt.the_bumblezone.configs.forge.BzClientConfig;
import com.telepathicgrunt.the_bumblezone.configs.forge.BzDimensionConfig;
import com.telepathicgrunt.the_bumblezone.configs.forge.BzGeneralConfig;
import com.telepathicgrunt.the_bumblezone.configs.forge.BzModCompatibilityConfig;
import com.telepathicgrunt.the_bumblezone.configs.forge.BzWorldgenConfig;
import com.telepathicgrunt.the_bumblezone.items.potions.ConfigSafePotion;
import com.telepathicgrunt.the_bumblezone.modinit.BzPotions;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

public class BzConfigHandler {
    public static void setup() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(BzConfigHandler::onConfigLoad);
        bus.addListener(BzConfigHandler::onConfigReload);
        try {
            Files.createDirectories(FMLPaths.CONFIGDIR.get().resolve("the_bumblezone"), new FileAttribute[0]);
            BzConfigHandler.createAndLoadConfigs(ModConfig.Type.CLIENT, BzClientConfig.GENERAL_SPEC, "the_bumblezone/client.toml");
            BzConfigHandler.createAndLoadConfigs(ModConfig.Type.COMMON, BzGeneralConfig.GENERAL_SPEC, "the_bumblezone/general.toml");
            BzConfigHandler.createAndLoadConfigs(ModConfig.Type.COMMON, BzWorldgenConfig.GENERAL_SPEC, "the_bumblezone/worldgen.toml");
            BzConfigHandler.createAndLoadConfigs(ModConfig.Type.COMMON, BzDimensionConfig.GENERAL_SPEC, "the_bumblezone/dimension.toml");
            BzConfigHandler.createAndLoadConfigs(ModConfig.Type.COMMON, BzBeeAggressionConfig.GENERAL_SPEC, "the_bumblezone/bee_aggression.toml");
            BzConfigHandler.createAndLoadConfigs(ModConfig.Type.COMMON, BzModCompatibilityConfig.GENERAL_SPEC, "the_bumblezone/mod_compatibility.toml");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create Bumblezone config files: ", e);
        }
    }

    private static void onConfigLoad(ModConfigEvent.Loading event) {
        BzConfigHandler.copyToCommon(event.getConfig().getSpec());
    }

    private static void onConfigReload(ModConfigEvent.Reloading event) {
        BzPotions.POTIONS.getEntries().forEach(p -> {
            if (p instanceof ConfigSafePotion) {
                ConfigSafePotion configSafePotion = (ConfigSafePotion)((Object)((Object)p));
                configSafePotion.clearCachedEffectList();
            }
        });
        BzConfigHandler.copyToCommon(event.getConfig().getSpec());
    }

    private static void copyToCommon(IConfigSpec<?> spec) {
        if (spec == BzClientConfig.GENERAL_SPEC) {
            BzClientConfig.copyToCommon();
        }
        if (spec == BzGeneralConfig.GENERAL_SPEC) {
            BzGeneralConfig.copyToCommon();
        }
        if (spec == BzWorldgenConfig.GENERAL_SPEC) {
            BzWorldgenConfig.copyToCommon();
        }
        if (spec == BzDimensionConfig.GENERAL_SPEC) {
            BzDimensionConfig.copyToCommon();
        }
        if (spec == BzBeeAggressionConfig.GENERAL_SPEC) {
            BzBeeAggressionConfig.copyToCommon();
        }
        if (spec == BzModCompatibilityConfig.GENERAL_SPEC) {
            BzModCompatibilityConfig.copyToCommon();
        }
    }

    private static void createAndLoadConfigs(ModConfig.Type type, ForgeConfigSpec spec, String path) {
        ModLoadingContext.get().registerConfig(type, (IConfigSpec)spec, path);
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve(path)).preserveInsertionOrder().autoreload().writingMode(WritingMode.REPLACE).sync().build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }
}

