/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.mobs;

import com.telepathicgrunt.the_bumblezone.client.rendering.rootmin.RootminPose;
import com.telepathicgrunt.the_bumblezone.entities.BeeAggression;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminAngryGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminAntiGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminAvoidEntityGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminCuriosityGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminEmbarrassedCurseGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminHiddenGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminHideGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminHurtByTargetGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminNearestAttackableTargetGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminRangedAttackGoal;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.DirtPelletEntity;
import com.telepathicgrunt.the_bumblezone.items.BeeArmor;
import com.telepathicgrunt.the_bumblezone.items.FlowerHeadwearHelmet;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RootminEntity
extends PathfinderMob
implements Enemy,
OwnableEntity {
    private static final EntityDataAccessor<Optional<BlockState>> FLOWER_BLOCK_STATE = SynchedEntityData.m_135353_(RootminEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268618_);
    public static final EntityDataSerializer<RootminPose> ROOTMIN_POSE_SERIALIZER = EntityDataSerializer.m_238090_(RootminPose.class);
    private static final EntityDataAccessor<RootminPose> ROOTMIN_POSE = SynchedEntityData.m_135353_(RootminEntity.class, ROOTMIN_POSE_SERIALIZER);
    private static final EntityDataAccessor<Boolean> ROOTMIN_SHIELD = SynchedEntityData.m_135353_(RootminEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(RootminEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState angryAnimationState = new AnimationState();
    public final AnimationState curiousAnimationState = new AnimationState();
    public final AnimationState curseAnimationState = new AnimationState();
    public final AnimationState embarassedAnimationState = new AnimationState();
    public final AnimationState shockAnimationState = new AnimationState();
    public final AnimationState shootAnimationState = new AnimationState();
    public final AnimationState runAnimationState = new AnimationState();
    public final AnimationState walkAnimationState = new AnimationState();
    public final AnimationState blockToEntityAnimationState = new AnimationState();
    public final AnimationState entityToBlockAnimationState = new AnimationState();
    private boolean checkedDefaultFlowerTag = false;
    public boolean isHidden = false;
    public boolean disableAttackGoals = false;
    public RootminEntity rootminToLookAt = null;
    public LivingEntity attackerMemory = null;
    public UUID superHatedPlayer = null;
    private int delayTillIdle = -1;
    public boolean takePotShot = false;
    public int exposedTimer = 0;
    public int curiosityCooldown = 60;
    public int stayHidingTimer = 200;
    private UUID essenceController = null;
    private BlockPos essenceControllerBlockPos = null;
    private ResourceKey<Level> essenceControllerDimension = null;
    public int animationTimeBetweenHiding = 0;
    public static final Set<RootminPose> POSES_THAT_CANT_BE_MOTION_INTERRUPTED = Set.of(RootminPose.ANGRY, RootminPose.CURIOUS, RootminPose.CURSE, RootminPose.EMBARRASSED, RootminPose.SHOOT, RootminPose.SHOCK, RootminPose.BLOCK_TO_ENTITY, RootminPose.ENTITY_TO_BLOCK);
    public static final Set<RootminPose> POSES_THAT_CAN_BE_FEAR_INTERRUPTED = Set.of(RootminPose.ANGRY, RootminPose.CURIOUS, RootminPose.CURSE, RootminPose.EMBARRASSED, RootminPose.SHOCK);

    public RootminEntity(EntityType<? extends RootminEntity> type, Level level) {
        super(type, level);
        this.getFlowerBlock();
        this.setAnimationState(this.getRootminPose(), RootminPose.NONE, this.idleAnimationState);
        this.m_274367_(1.0f);
    }

    public void setFlowerBlock(@Nullable BlockState blockState) {
        this.f_19804_.m_135381_(FLOWER_BLOCK_STATE, Optional.ofNullable(blockState));
    }

    @Nullable
    public BlockState getFlowerBlock() {
        return ((Optional)this.f_19804_.m_135370_(FLOWER_BLOCK_STATE)).orElse(null);
    }

    @Nullable
    private BlockState getFlowerOrSetIfMissing(LevelAccessor level, BlockState state) {
        if (state == null && !level.m_5776_() && !this.checkedDefaultFlowerTag) {
            TagKey<Block> blockTag = level.m_7062_().m_204216_(this.m_20183_()).m_203373_(new ResourceLocation("the_bumblezone", "floral_meadow")) ? BzTags.ROOTMIN_FLORAL_MEADOW_FLOWERS : BzTags.ROOTMIN_DEFAULT_FLOWERS;
            List blockList = BuiltInRegistries.f_256975_.m_203431_(blockTag).map(holders -> holders.m_203614_().map(Holder::m_203334_).toList()).orElseGet(ArrayList::new);
            state = blockList.isEmpty() ? Blocks.f_50016_.m_49966_() : ((Block)blockList.get(this.m_217043_().m_188503_(blockList.size()))).m_49966_();
            this.setFlowerBlock(state);
            this.checkedDefaultFlowerTag = true;
        }
        return state;
    }

    public UUID getEssenceController() {
        return this.essenceController;
    }

    public void setEssenceController(UUID essenceController) {
        this.essenceController = essenceController;
    }

    public BlockPos getEssenceControllerBlockPos() {
        return this.essenceControllerBlockPos;
    }

    public void setEssenceControllerBlockPos(BlockPos essenceControllerBlockPos) {
        this.essenceControllerBlockPos = essenceControllerBlockPos;
    }

    public ResourceKey<Level> getEssenceControllerDimension() {
        return this.essenceControllerDimension;
    }

    public void setEssenceControllerDimension(ResourceKey<Level> essenceControllerDimension) {
        this.essenceControllerDimension = essenceControllerDimension;
    }

    public void setRootminPose(RootminPose rootminPose) {
        this.f_19804_.m_135381_(ROOTMIN_POSE, (Object)rootminPose);
    }

    public RootminPose getRootminPose() {
        return (RootminPose)((Object)this.f_19804_.m_135370_(ROOTMIN_POSE));
    }

    public void setRootminShield(boolean hasShield) {
        this.f_19804_.m_135381_(ROOTMIN_SHIELD, (Object)hasShield);
    }

    public boolean getRootminShield() {
        return (Boolean)this.f_19804_.m_135370_(ROOTMIN_SHIELD);
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uUID) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(uUID));
    }

    public void runAngry() {
        if (this.getRootminPose() != RootminPose.ANGRY) {
            this.m_5496_(BzSounds.ROOTMIN_ANGRY.get(), 1.0f, this.m_217043_().m_188501_() * 0.2f + 0.8f);
        }
        this.delayTillIdle = 80;
        this.setRootminPose(RootminPose.ANGRY);
    }

    public void runCurious() {
        if (this.getRootminPose() != RootminPose.CURIOUS) {
            this.m_5496_(BzSounds.ROOTMIN_CURIOUS.get(), 1.0f, this.m_217043_().m_188501_() * 0.2f + 0.8f);
        }
        this.delayTillIdle = 28;
        this.setRootminPose(RootminPose.CURIOUS);
    }

    public void runCurse() {
        if (this.getRootminPose() != RootminPose.CURSE) {
            this.m_5496_(BzSounds.ROOTMIN_CURSING.get(), 1.0f, this.m_217043_().m_188501_() * 0.2f + 0.8f);
        }
        this.delayTillIdle = 40;
        this.setRootminPose(RootminPose.CURSE);
    }

    public void runEmbarrassed() {
        if (this.getRootminPose() != RootminPose.EMBARRASSED) {
            this.m_5496_(BzSounds.ROOTMIN_EMBARRASSED.get(), 1.0f, this.m_217043_().m_188501_() * 0.2f + 0.8f);
        }
        this.delayTillIdle = 60;
        this.setRootminPose(RootminPose.EMBARRASSED);
    }

    public void runShock() {
        if (this.getRootminPose() != RootminPose.SHOCK) {
            this.m_5496_(BzSounds.ROOTMIN_SHOCK.get(), 1.0f, this.m_217043_().m_188501_() * 0.2f + 0.8f);
        }
        this.delayTillIdle = 10;
        this.setRootminPose(RootminPose.SHOCK);
    }

    public void runShoot(@Nullable LivingEntity target, float speedMultiplier, boolean isHoming) {
        if (isHoming && target != null) {
            this.shootHomingDirt(target, speedMultiplier);
        } else {
            this.shootDirt(target, speedMultiplier);
        }
        this.delayTillIdle = 8;
        this.setRootminPose(RootminPose.SHOOT);
    }

    public void runMultiShoot(@Nullable LivingEntity target, float speedMultiplier, int projectiles) {
        this.shootDirt(target, speedMultiplier, projectiles);
        this.delayTillIdle = 8;
        this.setRootminPose(RootminPose.SHOOT);
    }

    public void exposeFromBlock() {
        this.isHidden = false;
        this.delayTillIdle = 20;
        this.animationTimeBetweenHiding = 20;
        this.setRootminPose(RootminPose.BLOCK_TO_ENTITY);
    }

    public void hideAsBlock(Vec3 destination) {
        this.isHidden = true;
        this.delayTillIdle = -1;
        this.animationTimeBetweenHiding = 20;
        this.setRootminPose(RootminPose.ENTITY_TO_BLOCK);
        this.m_21573_().m_26573_();
        if (destination != null && this.m_20182_().m_82546_(destination).m_82553_() < 1.0) {
            this.m_20219_(destination);
        } else {
            this.m_20219_(Vec3.m_82512_((Vec3i)this.m_20183_()));
        }
        this.m_20256_(Vec3.f_82478_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RootminAntiGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new RootminAngryGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new RootminEmbarrassedCurseGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new RootminCuriosityGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new RootminHiddenGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new RootminAvoidEntityGoal(this, BzTags.ROOTMIN_PANIC_AVOID, 24.0f, 1.75, 2.5));
        this.f_21345_.m_25352_(7, (Goal)new RootminHideGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new RootminRangedAttackGoal(this, 1.25, 20, 15, 30.0f));
        this.f_21346_.m_25352_(9, (Goal)new RootminHurtByTargetGoal(this));
        this.f_21346_.m_25352_(10, (Goal)new RootminNearestAttackableTargetGoal((Mob)this, true));
    }

    public static AttributeSupplier.Builder getAttributeBuilder() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.18).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 30.0);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        BlockState blockState = this.getFlowerBlock();
        if (blockState != null) {
            compoundTag.m_128365_("flowerBlock", (Tag)NbtUtils.m_129202_((BlockState)blockState));
        }
        compoundTag.m_128379_("hidden", this.isHidden);
        compoundTag.m_128405_("delayTillIdle", this.delayTillIdle);
        compoundTag.m_128359_("animationState", this.getRootminPose().name());
        if (this.superHatedPlayer != null) {
            compoundTag.m_128362_("superHatedPlayer", this.superHatedPlayer);
        }
        if (this.getEssenceController() != null) {
            compoundTag.m_128362_("essenceController", this.getEssenceController());
        }
        if (this.getEssenceControllerBlockPos() != null) {
            compoundTag.m_128365_("essenceControllerBlockPos", (Tag)NbtUtils.m_129224_((BlockPos)this.getEssenceControllerBlockPos()));
        }
        if (this.getEssenceControllerDimension() != null) {
            compoundTag.m_128359_("essenceControllerDimension", this.getEssenceControllerDimension().m_135782_().toString());
        }
        if (this.m_21805_() != null) {
            compoundTag.m_128362_("Owner", this.m_21805_());
        }
    }

    public void m_7378_(CompoundTag compoundTag) {
        UUID uUID;
        super.m_7378_(compoundTag);
        BlockState blockState = null;
        if (compoundTag.m_128425_("flowerBlock", 10) && (blockState = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)compoundTag.m_128469_("flowerBlock"))).m_60795_()) {
            blockState = null;
        }
        if (blockState == null) {
            this.getFlowerBlock();
        } else {
            this.setFlowerBlock(blockState);
        }
        this.isHidden = compoundTag.m_128471_("hidden");
        this.delayTillIdle = compoundTag.m_128451_("delayTillIdle");
        if (compoundTag.m_128441_("superHatedPlayer")) {
            this.superHatedPlayer = compoundTag.m_128342_("superHatedPlayer");
        }
        if (this.isHidden) {
            this.setRootminPose(RootminPose.ENTITY_TO_BLOCK);
        } else if (compoundTag.m_128441_("animationState")) {
            this.setRootminPose(RootminPose.valueOf(compoundTag.m_128461_("animationState")));
        }
        if (compoundTag.m_128441_("essenceController")) {
            this.setEssenceController(compoundTag.m_128342_("essenceController"));
        }
        if (compoundTag.m_128441_("essenceControllerBlockPos")) {
            this.setEssenceControllerBlockPos(NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_("essenceControllerBlockPos")));
        }
        if (compoundTag.m_128441_("essenceControllerDimension")) {
            this.setEssenceControllerDimension((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(compoundTag.m_128461_("essenceControllerDimension"))));
        }
        if (compoundTag.m_128403_("Owner")) {
            uUID = compoundTag.m_128342_("Owner");
        } else {
            String string = compoundTag.m_128461_("Owner");
            uUID = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)string);
        }
        if (uUID != null) {
            this.setOwnerUUID(uUID);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        spawnGroupData = super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
        BlockState state = this.getFlowerBlock();
        this.getFlowerOrSetIfMissing((LevelAccessor)serverLevelAccessor, state);
        return spawnGroupData;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLOWER_BLOCK_STATE, Optional.empty());
        this.f_19804_.m_135372_(ROOTMIN_POSE, (Object)RootminPose.NONE);
        this.f_19804_.m_135372_(ROOTMIN_SHIELD, (Object)false);
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ROOTMIN_POSE.equals(entityDataAccessor)) {
            RootminPose pose = this.getRootminPose();
            if (pose == RootminPose.BLOCK_TO_ENTITY || pose == RootminPose.ENTITY_TO_BLOCK) {
                this.animationTimeBetweenHiding = 20;
            }
            this.setAnimationState(pose, RootminPose.NONE, this.idleAnimationState, this.f_19797_ - 27);
            this.setAnimationState(pose, RootminPose.ANGRY, this.angryAnimationState, (ParticleOptions)BzParticles.ANGRY_PARTICLE.get(), 75, 1.0);
            this.setAnimationState(pose, RootminPose.CURIOUS, this.curiousAnimationState, (ParticleOptions)BzParticles.CURIOUS_PARTICLE.get(), 23, 1.0);
            this.setAnimationState(pose, RootminPose.CURSE, this.curseAnimationState, (ParticleOptions)BzParticles.CURSING_PARTICLE.get(), 35, 1.0);
            this.setAnimationState(pose, RootminPose.EMBARRASSED, this.embarassedAnimationState, (ParticleOptions)BzParticles.EMBARRASSED_PARTICLE.get(), 55, 1.0);
            this.setAnimationState(pose, RootminPose.SHOCK, this.shockAnimationState);
            this.setAnimationState(pose, RootminPose.SHOOT, this.shootAnimationState);
            this.setAnimationState(pose, RootminPose.RUN, this.runAnimationState);
            this.setAnimationState(pose, RootminPose.WALK, this.walkAnimationState);
            this.setAnimationState(pose, RootminPose.BLOCK_TO_ENTITY, this.blockToEntityAnimationState);
            this.setAnimationState(pose, RootminPose.ENTITY_TO_BLOCK, this.entityToBlockAnimationState, this.f_19797_ <= 2 ? -100000 : this.f_19797_);
        }
        super.m_7350_(entityDataAccessor);
    }

    private void setAnimationState(RootminPose pose, RootminPose poseToCheckFor, AnimationState animationState) {
        this.setAnimationState(pose, poseToCheckFor, animationState, null, 0, 0.0);
    }

    private void setAnimationState(RootminPose pose, RootminPose poseToCheckFor, AnimationState animationState, int tickCount) {
        this.setAnimationState(pose, poseToCheckFor, animationState, tickCount, null, 0, 0.0);
    }

    private void setAnimationState(RootminPose pose, RootminPose poseToCheckFor, AnimationState animationState, ParticleOptions particleType, int particleLifeSpan, double yOffset) {
        this.setAnimationState(pose, poseToCheckFor, animationState, this.f_19797_, particleType, particleLifeSpan, yOffset);
    }

    private void setAnimationState(RootminPose pose, RootminPose poseToCheckFor, AnimationState animationState, int tickCount, ParticleOptions particleType, int particleLifeSpan, double yOffset) {
        if (pose == poseToCheckFor) {
            if (!animationState.m_216984_()) {
                Level level;
                animationState.m_216977_(tickCount);
                if (particleType != null && (level = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_(particleType, this.m_20185_(), this.m_20191_().f_82292_ + yOffset, this.m_20189_(), 0, 1.0, 1.0, 1.0, (double)particleLifeSpan);
                }
            }
        } else {
            animationState.m_216973_();
        }
    }

    public boolean m_5545_(LevelAccessor world, MobSpawnType spawnReason) {
        return true;
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        super.m_142687_(removalReason);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack itemstack = player.m_21120_(hand);
        boolean instantBuild = player.m_150110_().f_35937_;
        Item item = itemstack.m_41720_();
        if (item instanceof BlockItem) {
            BlockState blockState;
            ServerPlayer serverPlayer;
            BlockItem blockItem = (BlockItem)item;
            if ((instantBuild || player instanceof ServerPlayer && EssenceOfTheBees.hasEssence(serverPlayer = (ServerPlayer)player) || BeeArmor.getBeeThemedWearablesCount((Entity)player) > 0 || !FlowerHeadwearHelmet.getFlowerHeadwear((Entity)player).m_41619_()) && (blockState = blockItem.m_40614_().m_49966_()).m_204336_(BzTags.ROOTMIN_ALLOWED_FLOWERS) && !blockState.m_204336_(BzTags.ROOTMIN_FORCED_DISALLOWED_FLOWERS) && (this.getFlowerBlock() == null || this.getFlowerBlock() != blockState)) {
                if (!this.m_9236_().m_5776_()) {
                    if (!instantBuild && this.getFlowerBlock() != null) {
                        ItemStack itemStack = new ItemStack((ItemLike)Items.f_42390_);
                        itemStack.m_41663_(Enchantments.f_44985_, 1);
                        LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81463_, (Object)itemStack).m_287289_(LootContextParams.f_81455_, (Object)this);
                        List flowerDrops = this.getFlowerBlock().m_287290_(builder);
                        for (ItemStack flowerDrop : flowerDrops) {
                            this.m_5552_(flowerDrop, 1.0f);
                        }
                    }
                    if (blockState.m_60734_() instanceof DoublePlantBlock) {
                        blockState.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER);
                    }
                    int shrinkAmount = 1;
                    if (blockState.m_61138_((Property)BlockStateProperties.f_271526_)) {
                        shrinkAmount = Math.min(Math.max(1, itemstack.m_41613_()), 4);
                        blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_271526_, (Comparable)Integer.valueOf(shrinkAmount));
                    }
                    this.setFlowerBlock(blockState);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)itemstack.m_41720_()));
                    if (!instantBuild) {
                        itemstack.m_41774_(shrinkAmount);
                    }
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer2 = (ServerPlayer)player;
                        BzCriterias.ROOTMIN_FLOWER_SWAP_TRIGGER.trigger(serverPlayer2);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    public void shootHomingDirt(LivingEntity livingEntity, float speedMultiplier) {
        if (!this.m_9236_().m_5776_()) {
            DirtPelletEntity pelletEntity = new DirtPelletEntity(this.m_9236_(), (LivingEntity)this);
            pelletEntity.m_146884_(pelletEntity.m_20182_().m_82520_(this.m_20154_().m_7096_(), 0.0, this.m_20154_().m_7094_()));
            if (this.getEssenceController() != null) {
                pelletEntity.setEventBased(true);
            }
            pelletEntity.setHoming(true);
            pelletEntity.setHomingTargetUUID(livingEntity.m_20148_());
            double x = livingEntity.m_20185_() - this.m_20185_();
            double heightBasedOffset = 1.6 + 0.2 * ((double)livingEntity.m_20206_() / 1.8);
            double y = livingEntity.m_20186_() + heightBasedOffset * (1.333333 - (double)speedMultiplier) - pelletEntity.m_20186_();
            double z = livingEntity.m_20189_() - this.m_20189_();
            double archOffset = Math.sqrt(x * x + z * z);
            Vec3 lookAngle = this.m_20154_();
            pelletEntity.m_6686_(lookAngle.m_7096_(), y + archOffset * 0.01, lookAngle.m_7094_(), 1.5f * speedMultiplier, 1.0f);
            this.m_5496_(BzSounds.ROOTMIN_SHOOT.get(), 1.0f, this.m_217043_().m_188501_() * 0.2f + 0.8f);
            this.m_9236_().m_7967_((Entity)pelletEntity);
        }
    }

    public void shootDirt(@Nullable LivingEntity livingEntity) {
        this.shootDirt(livingEntity, 1.0f);
    }

    public void shootDirt(@Nullable LivingEntity livingEntity, float speedMultiplier) {
        this.shootDirt(livingEntity, 1.0f, 1);
    }

    public void shootDirt(@Nullable LivingEntity livingEntity, float speedMultiplier, int totalProjectiles) {
        if (!this.m_9236_().m_5776_()) {
            for (int currentProjectile = 0; currentProjectile < totalProjectiles; ++currentProjectile) {
                Vec3 shootAngle;
                Vec3 viewVector = this.m_20252_(1.0f);
                DirtPelletEntity pelletEntity = new DirtPelletEntity(this.m_9236_(), (LivingEntity)this);
                pelletEntity.m_146884_(pelletEntity.m_20182_().m_82520_(viewVector.m_7096_(), 0.0, viewVector.m_7094_()));
                if (this.getEssenceController() != null) {
                    pelletEntity.setEventBased(true);
                }
                if (livingEntity != null) {
                    double x = livingEntity.m_20185_() - this.m_20185_();
                    double y = livingEntity.m_20227_(1.1 - (double)(speedMultiplier * speedMultiplier) * 0.975) - pelletEntity.m_20186_() - (1.5 - (double)livingEntity.m_20206_());
                    double z = livingEntity.m_20189_() - this.m_20189_();
                    shootAngle = new Vec3(x, y, z);
                } else {
                    double defaultSpeed = 5.0;
                    double x = viewVector.m_7096_() * defaultSpeed;
                    double y = 0.3333333333333333;
                    double z = viewVector.m_7094_() * defaultSpeed;
                    shootAngle = new Vec3(x, y, z);
                }
                double archOffset = Math.sqrt(shootAngle.m_7096_() * shootAngle.m_7096_() + shootAngle.m_7094_() * shootAngle.m_7094_());
                Vec3 vec3 = this.m_20289_(1.0f);
                int angle = (currentProjectile - (int)((float)totalProjectiles / 2.0f)) * 3;
                Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)((float)angle * ((float)Math.PI / 180)), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                Vector3f rotatedShootAngle = shootAngle.m_252839_().rotate((Quaternionfc)quaternionf);
                pelletEntity.m_6686_(rotatedShootAngle.x(), (double)rotatedShootAngle.y() + archOffset * (double)0.2f * (double)(currentProjectile != 1 ? 1.4f : 1.0f), rotatedShootAngle.z(), 1.5f * speedMultiplier * (currentProjectile != 1 ? 0.75f : 1.0f), 1.0f);
                this.m_5496_(BzSounds.ROOTMIN_SHOOT.get(), 1.0f, this.m_217043_().m_188501_() * 0.2f + 0.8f);
                this.m_9236_().m_7967_((Entity)pelletEntity);
            }
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (this.getRootminShield()) {
            return true;
        }
        if (this.getEssenceController() != null) {
            Entity entity = damageSource.m_7640_();
            if (entity instanceof DirtPelletEntity) {
                ServerPlayer serverPlayer;
                DirtPelletEntity dirtPelletEntity = (DirtPelletEntity)entity;
                if (dirtPelletEntity.isEventBased()) {
                    return super.m_6673_(damageSource);
                }
                Entity entity2 = dirtPelletEntity.m_19749_();
                if (entity2 instanceof ServerPlayer && EssenceOfTheBees.hasEssence(serverPlayer = (ServerPlayer)entity2) && this.getRootminPose() != RootminPose.ANGRY && this.getRootminPose() != RootminPose.CURSE && this.getRootminPose() != RootminPose.SHOCK && this.f_20916_ == 0) {
                    return super.m_6673_(damageSource);
                }
            }
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public void m_8119_() {
        Level level;
        BlockState state = this.getFlowerBlock();
        this.getFlowerOrSetIfMissing((LevelAccessor)this.m_9236_(), state);
        if (this.getRootminPose() == RootminPose.ENTITY_TO_BLOCK) {
            this.m_21573_().m_26573_();
        }
        super.m_8119_();
        if (this.f_20916_ == 9 && !this.m_9236_().m_5776_()) {
            this.isHidden = false;
            if (this.getRootminPose() != RootminPose.CURSE && this.getRootminPose() != RootminPose.SHOCK) {
                this.runShock();
            }
        }
        if (!this.m_9236_().m_5776_()) {
            double horizontalSpeed = this.m_20184_().m_165924_();
            if (!POSES_THAT_CANT_BE_MOTION_INTERRUPTED.contains((Object)this.getRootminPose())) {
                if (horizontalSpeed > 0.2 || this.f_20916_ > 0) {
                    this.setRootminPose(RootminPose.RUN);
                } else if (horizontalSpeed > 0.01) {
                    this.setRootminPose(RootminPose.WALK);
                }
            }
            if (this.getRootminPose() == RootminPose.ENTITY_TO_BLOCK && this.curiosityCooldown >= 0) {
                --this.curiosityCooldown;
            }
            if (this.delayTillIdle >= 0) {
                if (this.delayTillIdle == 0) {
                    this.setRootminPose(RootminPose.NONE);
                }
                --this.delayTillIdle;
            } else if (!this.isHidden && this.getRootminPose() != RootminPose.NONE && this.m_6084_() && horizontalSpeed <= 0.01) {
                this.setRootminPose(RootminPose.NONE);
            }
        }
        if (this.animationTimeBetweenHiding > 0) {
            --this.animationTimeBetweenHiding;
            if (this.getRootminPose() == RootminPose.BLOCK_TO_ENTITY || this.getRootminPose() == RootminPose.ENTITY_TO_BLOCK) {
                this.m_6210_();
            }
        }
        if ((level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getRootminPose() == RootminPose.SHOCK && this.delayTillIdle == 8) {
                serverLevel.m_8767_((ParticleOptions)BzParticles.SHOCK_PARTICLE.get(), this.m_20185_(), this.m_20191_().f_82292_ + 1.5, this.m_20189_(), 0, 1.0, 1.0, 1.0, 8.0);
            }
        } else if (this.getRootminPose() == RootminPose.ENTITY_TO_BLOCK && this.animationTimeBetweenHiding == 0 && this.f_20886_ % 90.0f != 0.0f && this.f_20885_ % 90.0f != 0.0f && this.f_20884_ % 90.0f != 0.0f && this.f_20883_ % 90.0f != 0.0f && !this.m_20159_()) {
            float closestDir;
            Vec3 lookDirection = this.m_20154_();
            this.f_20886_ = closestDir = Direction.m_122366_((double)lookDirection.m_7096_(), (double)lookDirection.m_7098_(), (double)lookDirection.m_7094_()).m_122435_();
            this.f_20885_ = closestDir;
            this.f_20884_ = closestDir;
            this.f_20883_ = closestDir;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_() && (this.getRootminPose() == RootminPose.WALK || this.getRootminPose() == RootminPose.RUN)) {
            Vec3 frontPos = this.m_20182_().m_82549_(Vec3.m_82528_((Vec3i)this.m_6350_().m_122436_()));
            List list = this.m_9236_().m_6443_(RootminEntity.class, this.m_20191_().m_82400_(0.3), rootmin -> rootmin != this && rootmin.getRootminPose() == RootminPose.ENTITY_TO_BLOCK && rootmin.m_20182_().m_82509_((Position)frontPos, 1.3) && rootmin.m_20186_() - this.m_20182_().m_7098_() >= -0.5);
            if (!list.isEmpty() && this.m_20096_()) {
                this.m_6135_();
            }
        }
    }

    protected void m_8024_() {
        if (this.exposedTimer > 0) {
            --this.exposedTimer;
        }
    }

    public void m_7334_(Entity entity) {
        if (this.m_20096_() && this.f_201939_ && this.getRootminPose() == RootminPose.ENTITY_TO_BLOCK) {
            return;
        }
        super.m_7334_(entity);
    }

    public Vec3 m_21074_(Vec3 vec3, float f) {
        if (this.m_20096_() && this.f_201939_ && this.getRootminPose() == RootminPose.ENTITY_TO_BLOCK && this.animationTimeBetweenHiding == 0 && this.f_285638_.isPresent() && this.m_20182_().m_7098_() - (double)((BlockPos)this.f_285638_.get()).m_123342_() < 1.01) {
            return new Vec3(0.0, 0.0, 0.0);
        }
        return super.m_21074_(vec3, f);
    }

    public boolean getJumping() {
        return this.f_20899_;
    }

    protected void m_6668_(DamageSource damageSource) {
        RootminEntity sourceEntity;
        BlockState flower = this.getFlowerBlock();
        RootminEntity rootminEntity = sourceEntity = damageSource.m_7639_() == null ? this : damageSource.m_7639_();
        if (flower != null && this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            ItemStack itemStack = new ItemStack((ItemLike)Items.f_42390_);
            itemStack.m_41663_(Enchantments.f_44985_, 1);
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81463_, (Object)itemStack).m_287289_(LootContextParams.f_81455_, (Object)sourceEntity);
            List flowerDrops = flower.m_287290_(builder);
            for (ItemStack flowerDrop : flowerDrops) {
                this.m_5552_(flowerDrop, 0.5f);
            }
        }
        super.m_6668_(damageSource);
    }

    public boolean m_5829_() {
        return this.getRootminPose() == RootminPose.ENTITY_TO_BLOCK && !this.m_21224_();
    }

    protected AABB m_142242_() {
        if (this.getRootminPose() == RootminPose.BLOCK_TO_ENTITY || this.getRootminPose() == RootminPose.ENTITY_TO_BLOCK) {
            AABB currentAABB = super.m_142242_();
            float target = this.getRootminPose() == RootminPose.BLOCK_TO_ENTITY ? 1.56f : 1.0f;
            float from = this.getRootminPose() == RootminPose.BLOCK_TO_ENTITY ? 1.0f : 1.56f;
            float percentage = (20.0f - (float)this.animationTimeBetweenHiding) / 20.0f;
            currentAABB = currentAABB.m_165893_(Mth.m_14139_((double)percentage, (double)((double)from + currentAABB.f_82289_), (double)((double)target + currentAABB.f_82289_)));
            return currentAABB;
        }
        return super.m_142242_();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return (float)(this.m_20191_().m_82376_() - (double)0.575f);
    }

    public void m_6210_() {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        super.m_6210_();
        this.m_20248_(x, y, z);
    }

    public boolean m_6072_() {
        return super.m_6072_() && this.getEssenceController() == null;
    }

    public Entity m_5489_(ServerLevel serverLevel) {
        if (this.getEssenceController() != null) {
            return this;
        }
        return super.m_5489_(serverLevel);
    }

    public int m_287157_() {
        return this.getEssenceController() == null ? super.m_287157_() : Integer.MAX_VALUE;
    }

    protected boolean m_6125_() {
        return this.getEssenceController() == null || this.m_21225_() != null && this.m_21225_().m_7640_() instanceof DirtPelletEntity;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public float m_6121_() {
        return 0.4f * (float)(this.m_6162_() ? 1 : 2);
    }

    public int m_8132_() {
        return 0;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return BzSounds.ROOTMIN_SHOCK.get();
    }

    protected SoundEvent m_5592_() {
        return BzSounds.ROOTMIN_SHOCK.get();
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    public static boolean isFacingMob(RootminEntity rootminEntity, LivingEntity target) {
        Vec3 targetView = target.m_20154_().m_82541_();
        Vec3 currentDirection = rootminEntity.m_20182_().m_82546_(target.m_20182_()).m_82541_();
        double dotProduct = currentDirection.m_7096_() * targetView.m_7096_() + currentDirection.m_7098_() * targetView.m_7098_() + currentDirection.m_7094_() * targetView.m_7094_();
        return dotProduct >= 0.0;
    }

    public boolean canTarget(LivingEntity livingEntity) {
        boolean canTarget;
        block10: {
            block11: {
                if (livingEntity.m_6095_().m_204039_(BzTags.ROOTMIN_FORCED_DO_NOT_TARGET)) {
                    return false;
                }
                if (this.m_21805_() == null || livingEntity.m_6095_().m_20674_() != MobCategory.MONSTER) break block10;
                if (!(livingEntity instanceof OwnableEntity)) break block11;
                OwnableEntity ownableEntity = (OwnableEntity)livingEntity;
                if (this.m_21805_().equals(ownableEntity.m_21805_())) break block10;
            }
            return true;
        }
        boolean bl = canTarget = BeeAggression.doesBeesHateEntity((Entity)livingEntity) || livingEntity.m_6095_().m_204039_(BzTags.ROOTMIN_TARGETS);
        if (canTarget && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (this.isOwnedBy((LivingEntity)player)) {
                return false;
            }
            if (player.m_7500_() || player.m_5833_() || player.m_21224_()) {
                if (player.m_20148_().equals(this.superHatedPlayer)) {
                    this.superHatedPlayer = null;
                }
                return false;
            }
            if (player.m_20148_().equals(this.superHatedPlayer)) {
                this.stayHidingTimer = 0;
                return true;
            }
            if (BeeArmor.getBeeThemedWearablesCount((Entity)player) > 0 || !FlowerHeadwearHelmet.getFlowerHeadwear((Entity)player).m_41619_()) {
                return false;
            }
        }
        return canTarget;
    }

    public boolean isOwnedBy(LivingEntity livingEntity) {
        return livingEntity == this.m_269323_();
    }

    public Team m_5647_() {
        LivingEntity livingEntity;
        if (this.m_269323_() != null && (livingEntity = this.m_269323_()) != null) {
            return livingEntity.m_5647_();
        }
        return super.m_5647_();
    }

    public boolean m_7307_(Entity entity) {
        if (this.m_269323_() != null) {
            LivingEntity livingEntity = this.m_269323_();
            if (entity == livingEntity) {
                return true;
            }
            if (livingEntity != null) {
                return livingEntity.m_7307_(entity);
            }
        }
        return super.m_7307_(entity);
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public double m_6048_() {
        return this.m_20191_().f_82292_ - this.m_20191_().f_82289_ - 0.14;
    }

    public static void considerHiddenRootminsInPath(Path path, RootminEntity mob) {
        if (path != null && !path.m_77392_() && path.m_77398_() > 0 && path.m_77398_() > path.m_77399_()) {
            BlockPos targetPos = path.m_77396_(path.m_77399_());
            AABB aabb = new AABB((double)targetPos.m_123341_() - 0.2, (double)targetPos.m_123342_() - 0.2, (double)targetPos.m_123343_() - 0.2, (double)targetPos.m_123341_() + 1.2, (double)targetPos.m_123342_() + 1.2, (double)targetPos.m_123343_() + 1.2);
            List list = mob.m_9236_().m_6443_(RootminEntity.class, aabb, rootmin2 -> rootmin2 != mob && rootmin2.getRootminPose() == RootminPose.ENTITY_TO_BLOCK);
            if (!list.isEmpty()) {
                path.m_77374_();
            }
        }
    }

    public static void jumpFix(Path path, RootminEntity mob) {
        BlockPos targetPos;
        if (!mob.f_20899_ && path != null && !path.m_77392_() && path.m_77398_() > 0 && path.m_77398_() > path.m_77399_() && (targetPos = path.m_77396_(path.m_77399_())).m_123342_() > mob.m_20183_().m_123342_()) {
            BlockPos frontPos = mob.m_20183_().m_121945_(mob.m_6350_());
            BlockState frontState = mob.m_9236_().m_8055_(frontPos);
            if (frontState.m_60838_((BlockGetter)mob.m_9236_(), frontPos)) {
                mob.m_6135_();
            }
        }
    }
}

