/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.nonliving;

import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzDamageSources;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2d;

public class DirtPelletEntity
extends ThrowableItemProjectile {
    private boolean eventBased = false;
    private Entity homingTarget = null;
    private static final EntityDataAccessor<Optional<UUID>> DATA_HOMING_TARGET_UUID = SynchedEntityData.m_135353_(DirtPelletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> DATA_IS_HOMING = SynchedEntityData.m_135353_(DirtPelletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public DirtPelletEntity(EntityType<? extends DirtPelletEntity> entityType, Level world) {
        super(entityType, world);
    }

    public DirtPelletEntity(Level world, LivingEntity livingEntity) {
        super(BzEntities.DIRT_PELLET_ENTITY.get(), livingEntity, world);
    }

    public DirtPelletEntity(Level world, double x, double y, double z) {
        super(BzEntities.DIRT_PELLET_ENTITY.get(), x, y, z, world);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_HOMING_TARGET_UUID, Optional.empty());
        this.f_19804_.m_135372_(DATA_IS_HOMING, (Object)false);
        super.m_8097_();
    }

    public boolean isEventBased() {
        return this.eventBased;
    }

    public void setEventBased(boolean eventBased) {
        this.eventBased = eventBased;
    }

    public boolean isHoming() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_HOMING);
    }

    public void setHoming(boolean homing) {
        this.f_19804_.m_135381_(DATA_IS_HOMING, (Object)homing);
    }

    public UUID getHomingTargetUUID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_HOMING_TARGET_UUID)).orElse(null);
    }

    public void setHomingTargetUUID(UUID homingTargetUUID) {
        this.f_19804_.m_135381_(DATA_HOMING_TARGET_UUID, Optional.of(homingTargetUUID));
    }

    protected Item m_7881_() {
        return BzItems.DIRT_PELLET.get();
    }

    private ParticleOptions getParticle() {
        ItemStack itemStack = this.m_37454_();
        return itemStack.m_41619_() ? new ItemParticleOption(ParticleTypes.f_123752_, this.m_7881_().m_7968_()) : new ItemParticleOption(ParticleTypes.f_123752_, itemStack);
    }

    protected ParticleOptions getTrailParticle() {
        return this.getParticle();
    }

    protected AABB m_142242_() {
        return super.m_142242_().m_82386_(0.0, (double)-0.1f, 0.0);
    }

    public void m_8119_() {
        Player player;
        if (this.isHoming() && this.homingTarget == null && this.getHomingTargetUUID() != null && (player = this.m_9236_().m_46003_(this.getHomingTargetUUID())) != null) {
            this.homingTarget = player;
        }
        if ((this.f_19797_ + 2) % 5 == 0) {
            Vec3 futurePos = this.m_20182_().m_82549_(this.m_20184_());
            this.m_9236_().m_7106_(this.getTrailParticle(), futurePos.m_7096_(), futurePos.m_7098_() + 0.1, futurePos.m_7094_(), 0.0, 0.0, 0.0);
        }
        super.m_8119_();
        if (this.homingTarget != null && this.m_19749_() != null) {
            double magicSideGravityConstant;
            double demoninatorDotProduct;
            double numeratorDotProduct;
            Vec3 projectionPoint;
            Vec3 deltaMovement = this.m_20184_();
            Vec3 shooterProjectileDiff = this.m_19749_().m_20182_().m_82546_(this.m_20182_());
            Vec3 shooterVictimDiff = this.m_19749_().m_20182_().m_82546_(this.homingTarget.m_20182_());
            Vec3 vectorToProjectionPoint = (shooterProjectileDiff = shooterProjectileDiff.m_82492_(0.0, shooterProjectileDiff.m_7098_(), 0.0)).m_82546_(projectionPoint = (shooterVictimDiff = shooterVictimDiff.m_82492_(0.0, shooterVictimDiff.m_7098_(), 0.0)).m_82490_((numeratorDotProduct = shooterProjectileDiff.m_7096_() * shooterVictimDiff.m_7096_() + shooterProjectileDiff.m_7094_() * shooterVictimDiff.m_7094_()) / (demoninatorDotProduct = shooterVictimDiff.m_7096_() * shooterVictimDiff.m_7096_() + shooterVictimDiff.m_7094_() * shooterVictimDiff.m_7094_())));
            Vec3 sideGravityVector = vectorToProjectionPoint.m_82490_(magicSideGravityConstant = 0.022);
            if (Double.isFinite(sideGravityVector.m_7096_()) && Double.isFinite(sideGravityVector.m_7094_())) {
                this.m_20256_(deltaMovement.m_82549_(sideGravityVector));
            }
        }
    }

    public void m_7822_(byte flag) {
        if (flag == 3) {
            ParticleOptions particleOptions = this.getParticle();
            for (int i = 0; i < 8; ++i) {
                this.m_9236_().m_7106_(particleOptions, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19796_.m_188583_() * 0.1, this.f_19796_.m_188583_() * 0.1, this.f_19796_.m_188583_() * 0.1);
            }
        }
    }

    protected boolean m_5603_(Entity entity) {
        if (entity instanceof DirtPelletEntity) {
            DirtPelletEntity dirtPelletEntity2 = (DirtPelletEntity)entity;
            if (dirtPelletEntity2.m_19749_() == this.m_19749_()) {
                return false;
            }
            if (this.m_20182_().m_82509_((Position)dirtPelletEntity2.m_20182_(), 0.5)) {
                return super.m_5603_(entity);
            }
            return false;
        }
        return super.m_5603_(entity);
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        LivingEntity livingEntity;
        RootminEntity rootminEntity;
        super.m_5790_(entityHitResult);
        Entity entity = entityHitResult.m_82443_();
        EntityType type = entity.m_6095_();
        ResourceLocation resourceLocation = BuiltInRegistries.f_256780_.m_7981_((Object)type);
        int damage = 1;
        if (entity instanceof DirtPelletEntity) {
            DirtPelletEntity hitDirtPelletEntity = (DirtPelletEntity)entity;
            if (!this.m_9236_().f_46443_) {
                hitDirtPelletEntity.m_9236_().m_7605_((Entity)this, (byte)3);
                hitDirtPelletEntity.m_9236_().m_5594_(null, this.m_20183_(), BzSounds.DIRT_PELLET_HIT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                hitDirtPelletEntity.m_146870_();
            }
        }
        if (!type.m_204039_(BzTags.DIRT_PELLET_FORCE_NO_EXTRA_DAMAGE)) {
            Mob mob;
            if (type.m_204039_(BzTags.DIRT_PELLET_EXTRA_DAMAGE)) {
                damage = 6;
            } else if (!resourceLocation.m_135827_().equals("minecraft") && !resourceLocation.m_135827_().equals("the_bumblezone") && (entity instanceof FlyingMob || entity instanceof Mob && (mob = (Mob)entity).m_21566_() instanceof FlyingMoveControl)) {
                damage = 6;
            }
        }
        if (this.eventBased || entity instanceof RootminEntity && (rootminEntity = (RootminEntity)entity).getEssenceController() != null) {
            if (entity instanceof RootminEntity) {
                damage = 1;
            } else if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                float maxHeart = Math.max(serverPlayer.m_21223_(), serverPlayer.m_21233_());
                damage = !EssenceOfTheBees.hasEssence(serverPlayer) ? (int)(maxHeart / 2.0f) : (int)(maxHeart / 4.0f);
            } else {
                damage = 5;
            }
        }
        DamageSource damageSource = this.eventBased ? this.m_269291_().m_268998_(BzDamageSources.EVENT_DIRT_PELLET_TYPE, (Entity)this, this.m_19749_()) : this.m_269291_().m_268998_(BzDamageSources.DIRT_PELLET_TYPE, (Entity)this, this.m_19749_());
        entity.m_6469_(damageSource, (float)damage);
        if (entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).m_5833_()) {
            Object object;
            Player player;
            if (livingEntity instanceof Player && (player = (Player)livingEntity).m_7500_()) {
                return;
            }
            Vector2d direction = new Vector2d(this.m_20184_().m_7096_(), this.m_20184_().m_7094_()).normalize();
            double yRotHitRadian = Mth.m_14136_((double)direction.x(), (double)direction.y());
            double knockbackStrength = 1.0;
            if (livingEntity instanceof RootminEntity) {
                knockbackStrength = this.isEventBased() ? 0.0 : 0.1;
            }
            livingEntity.m_147240_(knockbackStrength, (double)(-Mth.m_14031_((float)((float)yRotHitRadian))), (double)(-Mth.m_14089_((float)((float)yRotHitRadian))));
            if (this.eventBased && (object = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)object;
                for (MobEffect mobEffect : new HashSet(livingEntity.m_21221_().keySet())) {
                    if (!mobEffect.m_19486_()) continue;
                    livingEntity.m_21195_(mobEffect);
                }
                if (this.f_19796_.m_188499_()) {
                    int slotStartIndex = this.f_19796_.m_188503_(4);
                    for (int i = 0; i < 4; ++i) {
                        int slotIndex = (slotStartIndex + i) % 4;
                        EquipmentSlot equipmentSlot = switch (slotIndex) {
                            case 1 -> EquipmentSlot.CHEST;
                            case 2 -> EquipmentSlot.LEGS;
                            case 3 -> EquipmentSlot.FEET;
                            default -> EquipmentSlot.HEAD;
                        };
                        ItemStack armorItem = livingEntity.m_6844_(equipmentSlot);
                        if (armorItem.m_41619_() || EnchantmentHelper.m_44920_((ItemStack)armorItem) || armorItem.m_204117_(BzTags.LIFE_ARENA_ARMOR_CANNOT_BE_KNOCKED_OFF)) continue;
                        livingEntity.m_8061_(equipmentSlot, ItemStack.f_41583_);
                        this.dropItemFromEntity(livingEntity, armorItem, false, true);
                        break;
                    }
                }
                serverLevel.m_8767_((ParticleOptions)BzParticles.DUST_PARTICLE.get(), livingEntity.m_20185_(), livingEntity.m_20188_(), livingEntity.m_20189_(), 15, this.f_19796_.m_188583_() * 0.2, this.f_19796_.m_188583_() * 0.25 + 0.1, this.f_19796_.m_188583_() * 0.2, 0.0);
            }
        }
    }

    private ItemEntity dropItemFromEntity(LivingEntity livingEntity, ItemStack itemStack, boolean randomMovement, boolean setOwner) {
        if (itemStack.m_41619_()) {
            return null;
        }
        double d = livingEntity.m_20188_() - (double)0.3f;
        ItemEntity itemEntity = new ItemEntity(livingEntity.m_9236_(), livingEntity.m_20185_(), d, livingEntity.m_20189_(), itemStack);
        itemEntity.m_149678_();
        itemEntity.m_32010_(40);
        if (setOwner) {
            itemEntity.m_32052_(livingEntity.m_20148_());
        }
        if (randomMovement) {
            float f = this.f_19796_.m_188501_() * 0.5f;
            float g = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
            itemEntity.m_20334_((double)(-Mth.m_14031_((float)g) * f), (double)0.2f, (double)(Mth.m_14089_((float)g) * f));
        } else {
            float g = Mth.m_14031_((float)(livingEntity.m_146909_() * ((float)Math.PI / 180)));
            float h = Mth.m_14089_((float)(livingEntity.m_146909_() * ((float)Math.PI / 180)));
            float i = Mth.m_14031_((float)(livingEntity.m_146908_() * ((float)Math.PI / 180)));
            float j = Mth.m_14089_((float)(livingEntity.m_146908_() * ((float)Math.PI / 180)));
            float k = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
            float l = 0.02f * this.f_19796_.m_188501_();
            itemEntity.m_20334_((double)(-i * h * 0.3f) + Math.cos(k) * (double)l, (double)(-g * 0.3f + 0.1f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(j * h * 0.3f) + Math.sin(k) * (double)l);
        }
        livingEntity.m_9236_().m_7967_((Entity)itemEntity);
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            serverPlayer.m_6278_(Stats.f_12985_.m_12902_((Object)itemStack.m_41720_()), itemStack.m_41613_());
            serverPlayer.m_36220_(Stats.f_12927_);
        }
        return itemEntity;
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_9236_().m_5594_(null, this.m_20183_(), BzSounds.DIRT_PELLET_HIT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.m_146870_();
        }
    }

    public boolean m_6087_() {
        return true;
    }

    public float m_6143_() {
        double speed = this.m_20184_().m_82553_();
        return (float)Math.max(speed, 8.0);
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        if (this.m_6673_(damageSource)) {
            return false;
        }
        this.m_5834_();
        Entity entity = damageSource.m_7639_();
        if (entity != null) {
            if (!this.m_9236_().f_46443_) {
                Vec3 vec3 = entity.m_20154_();
                this.m_20256_(vec3);
                if (this.isHoming() && this.m_19749_() != null) {
                    this.setHomingTargetUUID(this.m_19749_().m_20148_());
                    this.homingTarget = this.m_19749_();
                } else {
                    this.setHoming(false);
                }
                this.m_5602_(entity);
            }
            return true;
        }
        return false;
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("isEvent", this.isEventBased());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setEventBased(compoundTag.m_128471_("isEvent"));
    }
}

