/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.nonliving;

import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlockYellow;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class ElectricRingEntity
extends Entity {
    private static final EntityDataAccessor<Boolean> DATA_ID_DISAPPEARING_SET = SynchedEntityData.m_135353_(ElectricRingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final int DISAPPERING_TIMESPAN = 20;
    public static final int APPEARING_TIMESPAN = 20;
    public int disappearingTime = -1;
    private UUID essenceController = null;
    private BlockPos essenceControllerBlockPos = null;
    private ResourceKey<Level> essenceControllerDimension = null;

    public ElectricRingEntity(EntityType<? extends ElectricRingEntity> entityType, Level level) {
        super(entityType, level);
        this.m_6210_();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_DISAPPEARING_SET, (Object)(this.disappearingTime > 0 ? 1 : 0));
    }

    public UUID getEssenceController() {
        return this.essenceController;
    }

    public void setEssenceController(UUID essenceController) {
        this.essenceController = essenceController;
    }

    public BlockPos getEssenceControllerBlockPos() {
        return this.essenceControllerBlockPos;
    }

    public void setEssenceControllerBlockPos(BlockPos essenceControllerBlockPos) {
        this.essenceControllerBlockPos = essenceControllerBlockPos;
    }

    public ResourceKey<Level> getEssenceControllerDimension() {
        return this.essenceControllerDimension;
    }

    public void setEssenceControllerDimension(ResourceKey<Level> essenceControllerDimension) {
        this.essenceControllerDimension = essenceControllerDimension;
    }

    public boolean getDisappearingMarker() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_DISAPPEARING_SET);
    }

    protected void setDisappearingMarker(boolean disappearingMarker) {
        this.f_19804_.m_135381_(DATA_ID_DISAPPEARING_SET, (Object)disappearingMarker);
    }

    protected float m_6380_(Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_ * 0.5f;
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_19915_(this.m_146908_(), this.m_146909_());
        if (this.m_9236_().m_5776_()) {
            if (this.f_19797_ % 2 == 0) {
                this.makeParticle(1);
            }
            if (this.getDisappearingMarker() && this.disappearingTime == -1) {
                this.disappearingTime = 20;
            }
        } else if (this.f_19797_ == 1) {
            this.makeServerParticle(50, (ServerLevel)this.m_9236_());
        }
        if (this.disappearingTime > 0) {
            --this.disappearingTime;
        }
        if (this.disappearingTime == 0) {
            this.m_146870_();
        }
        if (!this.m_9236_().m_5776_() && this.f_19797_ % 20 == 0) {
            this.checkIfStillInEvent();
        }
    }

    private void checkIfStillInEvent() {
        UUID essenceUuid = this.getEssenceController();
        ResourceKey<Level> essenceDimension = this.getEssenceControllerDimension();
        BlockPos essenceBlockPos = this.getEssenceControllerBlockPos();
        if (essenceBlockPos == null || essenceUuid == null || essenceDimension == null) {
            return;
        }
        BlockPos blockPos = this.m_20183_();
        EssenceBlockEntity essenceBlockEntity = EssenceBlockEntity.getEssenceBlockAtLocation(this.m_9236_(), essenceDimension, essenceBlockPos, essenceUuid);
        if (essenceBlockEntity != null) {
            BlockPos arenaSize = essenceBlockEntity.getArenaSize();
            if (Math.abs(blockPos.m_123341_() - essenceBlockPos.m_123341_()) > arenaSize.m_123341_() / 2 || Math.abs(blockPos.m_123342_() - essenceBlockPos.m_123342_()) > arenaSize.m_123342_() / 2 || Math.abs(blockPos.m_123343_() - essenceBlockPos.m_123343_()) > arenaSize.m_123343_() / 2) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        } else {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void m_6075_() {
        super.m_6075_();
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    private void makeParticle(int particlesToSpawn) {
        if (particlesToSpawn > 0) {
            double size = this.m_20191_().m_82309_();
            double extraScale = 1.5;
            double x = this.m_20185_() + (double)(this.f_19796_.m_188501_() - 0.5f) * size * extraScale;
            double y = this.m_20186_() + size / 2.0 + (double)(this.f_19796_.m_188501_() - 0.5f) * size * extraScale;
            double z = this.m_20189_() + (double)(this.f_19796_.m_188501_() - 0.5f) * size * extraScale;
            for (int i = 0; i < particlesToSpawn; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, x, y, z, (double)((this.f_19796_.m_188501_() - 0.5f) * 0.5f), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.5f), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.5f));
            }
        }
    }

    private void makeServerParticle(int particlesToSpawn, ServerLevel serverLevel) {
        if (particlesToSpawn > 0) {
            double xOffset = (double)this.f_19796_.m_188501_() * 0.3 - 0.15;
            double yOffset = (double)this.f_19796_.m_188501_() * 0.3 - 0.15;
            double zOffset = (double)this.f_19796_.m_188501_() * 0.3 - 0.15;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_(), this.m_20188_(), this.m_20189_(), particlesToSpawn, this.f_19796_.m_188583_() * xOffset, this.f_19796_.m_188583_() * yOffset + (double)0.2f, this.f_19796_.m_188583_() * zOffset, 1.5);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123808_, this.m_20185_(), this.m_20188_(), this.m_20189_(), particlesToSpawn, this.f_19796_.m_188583_() * xOffset, this.f_19796_.m_188583_() * yOffset + (double)0.2f, this.f_19796_.m_188583_() * zOffset, 1.0);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123815_, this.m_20185_(), this.m_20188_(), this.m_20189_(), particlesToSpawn, this.f_19796_.m_188583_() * xOffset, this.f_19796_.m_188583_() * yOffset + (double)0.2f, this.f_19796_.m_188583_() * zOffset, (double)0.2f);
        }
    }

    public void m_6123_(Player player) {
        Vec3 centerOfRing;
        double ringRadiusSq;
        if (!(this.m_9236_().m_5776_() || this.m_213877_() || this.disappearingTime != -1 || this.intersectedPassed(player, ringRadiusSq = Math.pow(this.m_20191_().m_82309_() / 2.0 + 0.2, 2.0), centerOfRing = this.m_146892_(), player.m_146892_()) || this.intersectedPassed(player, ringRadiusSq, centerOfRing, player.m_20191_().m_82399_()))) {
            this.intersectedPassed(player, ringRadiusSq, centerOfRing, player.m_146892_().m_82492_(0.0, (double)player.m_20192_(), 0.0));
        }
        super.m_6123_(player);
    }

    private boolean intersectedPassed(Player player, double ringRadiusSq, Vec3 centerOfRing, Vec3 playerPosToCheck) {
        double playerSpeed;
        double rangeCheck;
        double divisor;
        Vec3 normalVector;
        double numerator;
        double distanceBetweenPlayerAndPlane;
        Vec3 playerPoint = playerPosToCheck.m_82546_(centerOfRing);
        if (playerPoint.m_7096_() * playerPoint.m_7096_() + playerPoint.m_7098_() * playerPoint.m_7098_() + playerPoint.m_7094_() * playerPoint.m_7094_() < ringRadiusSq && (distanceBetweenPlayerAndPlane = (numerator = Math.abs((normalVector = this.m_20154_()).m_7096_() * playerPoint.m_7096_() + normalVector.m_7098_() * playerPoint.m_7098_() + normalVector.m_7094_() * playerPoint.m_7094_())) / (divisor = Math.sqrt(normalVector.m_7096_() * normalVector.m_7096_() + normalVector.m_7098_() * normalVector.m_7098_() + normalVector.m_7094_() * normalVector.m_7094_()))) < (rangeCheck = Math.max((double)0.2f, playerSpeed = (Math.pow(player.m_6113_() + 1.0f, 3.0) - 1.0) * 2.0))) {
            Block block;
            EssenceBlockEntity essenceBlockEntity = EssenceBlockEntity.getEssenceBlockAtLocation(this.m_9236_(), this.getEssenceControllerDimension(), this.getEssenceControllerBlockPos(), this.getEssenceController());
            if (essenceBlockEntity != null && (block = essenceBlockEntity.m_58900_().m_60734_()) instanceof EssenceBlockYellow) {
                EssenceBlockYellow essenceBlockYellow = (EssenceBlockYellow)block;
                essenceBlockYellow.ringActivated(this, essenceBlockEntity, (ServerPlayer)player);
            }
            this.makeServerParticle(50, (ServerLevel)this.m_9236_());
            this.disappearingTime = 20;
            this.setDisappearingMarker(true);
            this.m_216990_(BzSounds.ELECTRIC_RING_PASSED.get());
            return true;
        }
        return false;
    }

    public boolean m_6051_() {
        return false;
    }

    protected void m_20157_() {
    }

    public boolean m_6072_() {
        return false;
    }

    public Entity m_5489_(ServerLevel serverLevel) {
        return this;
    }

    public int m_287157_() {
        return Integer.MAX_VALUE;
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    protected void m_7378_(CompoundTag compoundTag) {
        if (compoundTag.m_128441_("disappearingTime")) {
            this.disappearingTime = compoundTag.m_128451_("disappearingTime");
        }
        this.setDisappearingMarker(compoundTag.m_128471_("disappearingMarker"));
        if (compoundTag.m_128441_("essenceController")) {
            this.setEssenceController(compoundTag.m_128342_("essenceController"));
        }
        if (compoundTag.m_128441_("essenceControllerBlockPos")) {
            this.setEssenceControllerBlockPos(NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_("essenceControllerBlockPos")));
        }
        if (compoundTag.m_128441_("essenceControllerDimension")) {
            this.setEssenceControllerDimension((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(compoundTag.m_128461_("essenceControllerDimension"))));
        }
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128405_("disappearingTime", this.disappearingTime);
        compoundTag.m_128379_("disappearingMarker", this.getDisappearingMarker());
        if (this.getEssenceController() != null) {
            compoundTag.m_128362_("essenceController", this.getEssenceController());
        }
        if (this.getEssenceControllerBlockPos() != null) {
            compoundTag.m_128365_("essenceControllerBlockPos", (Tag)NbtUtils.m_129224_((BlockPos)this.getEssenceControllerBlockPos()));
        }
        if (this.getEssenceControllerDimension() != null) {
            compoundTag.m_128359_("essenceControllerDimension", this.getEssenceControllerDimension().m_135782_().toString());
        }
    }

    public void m_141965_(ClientboundAddEntityPacket clientboundAddEntityPacket) {
        double d = clientboundAddEntityPacket.m_131500_();
        double e = clientboundAddEntityPacket.m_131501_();
        double f = clientboundAddEntityPacket.m_131502_();
        float g = clientboundAddEntityPacket.m_237567_();
        float h = clientboundAddEntityPacket.m_237566_();
        this.m_217006_(d, e, f);
        this.m_20234_(clientboundAddEntityPacket.m_131496_());
        this.m_20084_(clientboundAddEntityPacket.m_131499_());
        this.m_19890_(d, e, f, g, h);
        this.m_20334_(clientboundAddEntityPacket.m_131503_(), clientboundAddEntityPacket.m_131504_(), clientboundAddEntityPacket.m_131505_());
    }
}

