/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.items.HoneyCrystalShards;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.platform.ItemExtension;
import com.telepathicgrunt.the_bumblezone.utils.OptionalBoolean;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class CrystalCannon
extends ProjectileWeaponItem
implements Vanishable,
ItemExtension {
    public static final String TAG_CRYSTALS = "CrystalStored";

    public CrystalCannon(Item.Properties properties) {
        super(properties.m_41503_(80));
    }

    public void m_5551_(ItemStack crystalCannon, Level level, LivingEntity livingEntity, int currentDuration) {
        if (!level.m_5776_() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack mutableCrystalCannon = player.m_21120_(InteractionHand.MAIN_HAND);
            int numberOfCrystals = CrystalCannon.getNumberOfCrystals(mutableCrystalCannon);
            int quickCharge = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)mutableCrystalCannon);
            int remainingDuration = this.m_8105_(mutableCrystalCannon) - currentDuration;
            if (remainingDuration >= 20 - quickCharge * 3 && numberOfCrystals > 0) {
                int crystalsToSpawn = CrystalCannon.getAndClearStoredCrystals(level, mutableCrystalCannon);
                for (int i = 0; i < crystalsToSpawn; ++i) {
                    int pierce;
                    float offset = 0.0f;
                    if (i == 1) {
                        offset = livingEntity.m_217043_().m_188501_() * 5.0f + 3.5f;
                    } else if (i == 2) {
                        offset = livingEntity.m_217043_().m_188501_() * 5.0f - 11.5f;
                    } else if (i != 0) {
                        offset = livingEntity.m_217043_().m_188501_() * 10.0f - 5.0f;
                    }
                    AbstractArrow newCrystal = BzItems.HONEY_CRYSTAL_SHARDS.get().m_6394_(level, crystalCannon, livingEntity);
                    double weaponDamage = newCrystal.m_36789_();
                    int power = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)crystalCannon);
                    if (power > 0) {
                        weaponDamage += (double)power * 0.5 + 0.5;
                    }
                    newCrystal.m_36781_(weaponDamage);
                    int punch = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)crystalCannon);
                    if (punch > 0) {
                        newCrystal.m_36735_(newCrystal.m_150123_() + punch);
                    }
                    if ((pierce = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)crystalCannon)) > 0) {
                        newCrystal.m_36767_((byte)pierce);
                    }
                    newCrystal.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    Vec3 playerEyePos = new Vec3(player.m_20185_(), player.m_20188_() - 0.25, player.m_20189_());
                    newCrystal.m_7678_(playerEyePos.m_7096_(), playerEyePos.m_7098_(), playerEyePos.m_7094_(), player.m_146908_(), player.m_146909_());
                    Vec3 upVector = player.m_20289_(1.0f);
                    Vec3 viewVector = player.m_20252_(1.0f);
                    Vector3f shootVector = viewVector.m_252839_();
                    if (i != 0) {
                        Quaternionf quaternion1 = new Quaternionf(upVector.m_7096_(), upVector.m_7098_(), upVector.m_7094_(), (double)offset);
                        shootVector.rotate((Quaternionfc)quaternion1);
                    }
                    float weaponProjectileSpeed = 1.9f;
                    newCrystal.m_6686_((double)shootVector.x(), (double)(shootVector.y() + (livingEntity.m_217043_().m_188501_() * 0.2f + 0.01f)), (double)shootVector.z(), weaponProjectileSpeed, 1.0f);
                    level.m_7967_((Entity)newCrystal);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)mutableCrystalCannon.m_41720_()));
                    level.m_5594_(null, player.m_20183_(), BzSounds.CRYSTAL_CANNON_FIRES.get(), SoundSource.PLAYERS, 1.0f, player.m_217043_().m_188501_() * 0.2f + 0.6f);
                    mutableCrystalCannon.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21166_(EquipmentSlot.MAINHAND));
                    if (numberOfCrystals < 3 || !(player instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    BzCriterias.CRYSTAL_CANNON_FULL_TRIGGER.trigger(serverPlayer);
                }
                mutableCrystalCannon.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21166_(EquipmentSlot.MAINHAND));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack crystalCannon = player.m_21120_(interactionHand);
        if (!level.m_5776_()) {
            this.loadProjectiles(player, crystalCannon);
        }
        if (CrystalCannon.getNumberOfCrystals(crystalCannon) == 0) {
            return InteractionResultHolder.m_19100_((Object)crystalCannon);
        }
        player.m_6672_(interactionHand);
        return InteractionResultHolder.m_19096_((Object)crystalCannon);
    }

    private void loadProjectiles(Player player, ItemStack crystalCannon) {
        ItemStack projectItem1 = player.m_6298_(crystalCannon);
        if (projectItem1.m_41619_()) {
            return;
        }
        if (CrystalCannon.tryAddCrystal(crystalCannon)) {
            boolean infinite;
            boolean bl = infinite = player.m_150110_().f_35937_ || projectItem1.m_41720_() instanceof HoneyCrystalShards && ((HoneyCrystalShards)projectItem1.m_41720_()).bz$isInfinite(projectItem1, crystalCannon, player).orElseGet(() -> false);
            if (!infinite) {
                projectItem1.m_41774_(1);
                if (projectItem1.m_41619_()) {
                    player.m_150109_().m_36057_(projectItem1);
                }
            }
        }
    }

    public static int getAndClearStoredCrystals(Level level, ItemStack crystalCannonItem) {
        int numberOfCrystals = CrystalCannon.getNumberOfCrystals(crystalCannonItem);
        if (numberOfCrystals > 0) {
            CompoundTag tag = crystalCannonItem.m_41784_();
            int crystals = tag.m_128451_(TAG_CRYSTALS);
            tag.m_128405_(TAG_CRYSTALS, Math.max(0, crystals - 3));
        }
        return numberOfCrystals;
    }

    public static boolean tryAddCrystal(ItemStack crystalCannonItem) {
        if (CrystalCannon.getNumberOfCrystals(crystalCannonItem) < 3) {
            CompoundTag tag = crystalCannonItem.m_41784_();
            int crystals = tag.m_128451_(TAG_CRYSTALS);
            tag.m_128405_(TAG_CRYSTALS, crystals + 1);
            return true;
        }
        return false;
    }

    public static int getNumberOfCrystals(ItemStack crystalCannonItem) {
        if (crystalCannonItem.m_41782_()) {
            CompoundTag tag = crystalCannonItem.m_41784_();
            return tag.m_128451_(TAG_CRYSTALS);
        }
        return 0;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_204117_(BzTags.CRYSTAL_CANNON_REPAIR_ITEMS);
    }

    public Predicate<ItemStack> m_6442_() {
        return itemStack -> itemStack.m_150930_((Item)BzItems.HONEY_CRYSTAL_SHARDS.get());
    }

    public Predicate<ItemStack> m_6437_() {
        return itemStack -> itemStack.m_150930_((Item)BzItems.HONEY_CRYSTAL_SHARDS.get());
    }

    public int m_6473_() {
        return 1;
    }

    public int m_6615_() {
        return 0;
    }

    public int m_8105_(ItemStack itemStack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.BOW;
    }

    @Override
    public OptionalBoolean bz$canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44960_ || enchantment == Enchantments.f_44961_ || enchantment == Enchantments.f_44988_ || enchantment == Enchantments.f_44989_) {
            return OptionalBoolean.TRUE;
        }
        return OptionalBoolean.of(enchantment.f_44672_.m_7454_(stack.m_41720_()));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return this.bz$canApplyAtEnchantingTable(stack, enchantment).orElseGet(() -> enchantment.f_44672_.m_7454_(stack.m_41720_()));
    }
}

