/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.telepathicgrunt.the_bumblezone.entities.teleportation.EntityTeleportationHookup;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.forge.TwilightForestCompatImpl;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.EnumSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Contract;

public class TwilightForestCompat
implements ModCompat {
    private static final String ENDER_BOW_ATTACHED_TAG = "twilightforest:ender";
    private static final ResourceLocation ENDER_BOW_RL = new ResourceLocation("twilightforest", "ender_bow");

    public TwilightForestCompat() {
        ModChecker.twilightForestPresent = true;
    }

    @Override
    public InteractionResult isProjectileTeleportHandled(HitResult hitResult, Entity owner, Projectile projectile) {
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            if (projectile != null && TwilightForestCompat.getPersistentData((Entity)projectile).m_128471_(ENDER_BOW_ATTACHED_TAG) && GeneralUtils.isInTag(BuiltInRegistries.f_257033_, BzTags.ITEM_SPECIAL_DEDICATED_COMPAT, (Item)BuiltInRegistries.f_257033_.m_7745_(ENDER_BOW_RL))) {
                return EntityTeleportationHookup.runEntityHitCheck((HitResult)entityHitResult, owner, projectile) ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public EnumSet<ModCompat.Type> compatTypes() {
        return EnumSet.of(ModCompat.Type.PROJECTILE_IMPACT_HANDLED);
    }

    @Contract
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static CompoundTag getPersistentData(Entity entity) {
        return TwilightForestCompatImpl.getPersistentData(entity);
    }
}

