/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.forge;

import com.google.common.collect.Sets;
import com.hollingsworth.arsnouveau.api.event.EffectResolveEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.common.entity.AnimBlockSummon;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectAnimate;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectBlink;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectBreak;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectConjureWater;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectExchange;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectGlide;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectGravity;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectIntangible;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLaunch;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLeap;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectPhantomBlock;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectPlaceBlock;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSlowfall;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectWall;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.spell.method.MethodUnderfoot;
import com.telepathicgrunt.the_bumblezone.blocks.HeavyAir;
import com.telepathicgrunt.the_bumblezone.entities.teleportation.EntityTeleportationBackend;
import com.telepathicgrunt.the_bumblezone.entities.teleportation.EntityTeleportationHookup;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.forge.ArsElementalCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;

public class ArsNouveauCompat
implements ModCompat {
    private static final ResourceLocation SPELL_PROJ_RL = new ResourceLocation("ars_nouveau", "spell_proj");
    private static final ResourceLocation SPELL_FOLLOW_PROJ_RL = new ResourceLocation("ars_nouveau", "follow_proj");
    protected static final Set<AbstractCastMethod> ALLOWED_CAST_METHODS = Sets.newHashSet((Object[])new AbstractCastMethod[]{MethodProjectile.INSTANCE, MethodTouch.INSTANCE, MethodUnderfoot.INSTANCE});
    protected static final Set<AbstractEffect> DISALLOWED_HEAVY_AIR_EFFECTS = Sets.newHashSet((Object[])new AbstractEffect[]{EffectGlide.INSTANCE, EffectSlowfall.INSTANCE, EffectLaunch.INSTANCE, EffectLeap.INSTANCE});
    protected static final Set<AbstractEffect> DISALLOWED_INFINITY_AND_ESSENCE_EFFECTS = Sets.newHashSet((Object[])new AbstractEffect[]{EffectExchange.INSTANCE, EffectAnimate.INSTANCE, EffectGravity.INSTANCE, EffectBreak.INSTANCE, EffectIntangible.INSTANCE, EffectConjureWater.INSTANCE, EffectPlaceBlock.INSTANCE, EffectPhantomBlock.INSTANCE, EffectWall.INSTANCE});

    public ArsNouveauCompat() {
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        Consumer<EffectResolveEvent.Post> projectHandler = ArsNouveauCompat::handleArsSpellProjectile;
        forgeBus.addListener(projectHandler);
        Consumer<EffectResolveEvent.Pre> heavyAirHandler = ArsNouveauCompat::handleArsSpellHeavyAir;
        forgeBus.addListener(heavyAirHandler);
        Consumer<EffectResolveEvent.Pre> essenceAndInfinityHandler = ArsNouveauCompat::handleArsSpellEssenceAndInfinity;
        forgeBus.addListener(essenceAndInfinityHandler);
        ModChecker.arsNouveauPresent = true;
    }

    @Override
    public EnumSet<ModCompat.Type> compatTypes() {
        return EnumSet.of(ModCompat.Type.PROJECTILE_IMPACT_HANDLED, ModCompat.Type.RIGHT_CLICKED_HIVE_HANDLED);
    }

    private static void handleArsSpellEssenceAndInfinity(EffectResolveEvent.Pre event) {
        BlockHitResult blockHitResult;
        BlockState hitState;
        HitResult hitResult;
        boolean isDisallowedEffect = DISALLOWED_INFINITY_AND_ESSENCE_EFFECTS.contains(event.resolveEffect);
        if (isDisallowedEffect && (hitResult = event.rayTraceResult) instanceof BlockHitResult && ((hitState = event.world.m_8055_((blockHitResult = (BlockHitResult)hitResult).m_82425_())).m_204336_(BzTags.ESSENCE_BLOCKS) || hitState.m_60713_(BzBlocks.INFINITY_BARRIER.get()))) {
            LivingEntity livingEntity = event.shooter;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                serverPlayer.m_5661_((Component)Component.m_237115_((String)"system.the_bumblezone.denied_spell").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.RED), true);
            }
            event.setCanceled(true);
        }
    }

    private static void handleArsSpellHeavyAir(EffectResolveEvent.Pre event) {
        HitResult hitResult;
        if (DISALLOWED_HEAVY_AIR_EFFECTS.contains(event.resolveEffect) && (hitResult = event.rayTraceResult) instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            LivingEntity livingEntity = event.shooter;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (HeavyAir.isInHeavyAir(entityHitResult.m_82443_().m_9236_(), entityHitResult.m_82443_().m_20191_())) {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        serverPlayer.m_5661_((Component)Component.m_237115_((String)"system.the_bumblezone.denied_spell").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.RED), true);
                    }
                    event.setCanceled(true);
                }
            }
        }
    }

    private static void handleArsSpellProjectile(EffectResolveEvent.Post event) {
        LivingEntity livingEntity = event.shooter;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.resolveEffect == EffectBlink.INSTANCE && ALLOWED_CAST_METHODS.contains(ArsNouveauCompat.getClosestCastMethod(event.resolver))) {
                AbstractCastMethod closestCastMethod = ArsNouveauCompat.getClosestCastMethod(event.resolver);
                if (closestCastMethod == MethodTouch.INSTANCE || closestCastMethod == MethodUnderfoot.INSTANCE) {
                    ItemStack stack = player.m_21205_();
                    if (event.rayTraceResult instanceof BlockHitResult && stack.m_204117_(BzTags.TELEPORT_ITEM_RIGHT_CLICKED_BEEHIVE) || stack.m_204117_(BzTags.TELEPORT_ITEM_RIGHT_CLICKED_BEEHIVE_CROUCHING) && player.m_6144_()) {
                        BlockHitResult blockHitResult = (BlockHitResult)event.rayTraceResult;
                        EntityTeleportationHookup.runItemUseOn(player, blockHitResult.m_82425_(), stack);
                    }
                    return;
                }
                if (closestCastMethod == MethodProjectile.INSTANCE && !((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(SPELL_PROJ_RL)).m_204039_(BzTags.TELEPORT_PROJECTILES)) {
                    return;
                }
                if (ModChecker.arsElementalPresent && ArsElementalCompat.isArsElementalCasting(closestCastMethod)) {
                    return;
                }
                if (event.rayTraceResult instanceof BlockHitResult) {
                    EntityTeleportationHookup.runTeleportProjectileImpact(event.rayTraceResult, (Entity)event.shooter, null);
                } else {
                    HitResult hitResult = event.rayTraceResult;
                    if (hitResult instanceof EntityHitResult) {
                        EntityHitResult entityHitResult = (EntityHitResult)hitResult;
                        if (ArsNouveauCompat.isArsWalkingBlock(entityHitResult.m_82443_()) && !ArsNouveauCompat.isArsWalkingBlockAValidBeeHive(entityHitResult.m_82443_())) {
                            return;
                        }
                        EntityTeleportationHookup.runEntityHitCheck((HitResult)entityHitResult, (Entity)event.shooter, null);
                    }
                }
            }
        }
    }

    private static AbstractCastMethod getClosestCastMethod(SpellResolver resolver) {
        if (resolver.castType == null) {
            if (resolver.previousResolver != null) {
                return ArsNouveauCompat.getClosestCastMethod(resolver.previousResolver);
            }
        } else {
            return resolver.castType;
        }
        return null;
    }

    @Override
    public InteractionResult isProjectileTeleportHandled(HitResult hitResult, Entity owner, Projectile projectile) {
        EntityHitResult entityHitResult;
        ResourceLocation projectileRL = ForgeRegistries.ENTITY_TYPES.getKey((Object)projectile.m_6095_());
        if (projectileRL != null && (projectileRL.equals((Object)SPELL_PROJ_RL) || projectileRL.equals((Object)SPELL_FOLLOW_PROJ_RL))) {
            return InteractionResult.FAIL;
        }
        if (ModChecker.arsElementalPresent && ArsElementalCompat.isArsElementalProjectile(projectileRL)) {
            return InteractionResult.FAIL;
        }
        if (hitResult instanceof EntityHitResult && ArsNouveauCompat.isArsWalkingBlock((entityHitResult = (EntityHitResult)hitResult).m_82443_()) && !ArsNouveauCompat.isArsWalkingBlockAValidBeeHive(entityHitResult.m_82443_())) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean isRightClickTeleportHandled(Entity owner, ItemStack itemStack) {
        return ArsNouveauCompat.isArsSpellBook(itemStack);
    }

    public static boolean isArsSpellBook(ItemStack stack) {
        return stack.m_41720_() instanceof SpellBook;
    }

    public static boolean isArsWalkingBlock(Entity entity) {
        return entity instanceof AnimBlockSummon;
    }

    public static boolean isArsWalkingBlockAValidBeeHive(Entity entity) {
        if (entity instanceof AnimBlockSummon) {
            AnimBlockSummon animBlockSummon = (AnimBlockSummon)entity;
            return EntityTeleportationBackend.isValidBeeHive(animBlockSummon.blockState);
        }
        return false;
    }
}

