/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.forge;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.events.entity.EntitySpawnEvent;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import pokecube.api.data.PokedexEntry;
import pokecube.api.entity.pokemob.IPokemob;
import pokecube.api.entity.pokemob.PokemobCaps;
import pokecube.core.PokecubeCore;
import pokecube.core.database.Database;
import pokecube.core.entity.pokemobs.helper.PokemobBase;

public class PokecubeCompat
implements ModCompat {
    private static final List<PokedexEntry> BABY_POKECUBE_POKEMON_LIST = new ArrayList<PokedexEntry>();
    private static final List<PokedexEntry> POKECUBE_POKEMON_LIST = new ArrayList<PokedexEntry>();

    public PokecubeCompat() {
        BABY_POKECUBE_POKEMON_LIST.add(Database.getEntry((String)"Combee"));
        BABY_POKECUBE_POKEMON_LIST.add(Database.getEntry((String)"Weedle"));
        BABY_POKECUBE_POKEMON_LIST.add(Database.getEntry((String)"Cutiefly"));
        POKECUBE_POKEMON_LIST.addAll(BABY_POKECUBE_POKEMON_LIST);
        POKECUBE_POKEMON_LIST.add(Database.getEntry((String)"Ribombee"));
        POKECUBE_POKEMON_LIST.add(Database.getEntry((String)"Vespiquen"));
        POKECUBE_POKEMON_LIST.add(Database.getEntry((String)"Kakuna"));
        POKECUBE_POKEMON_LIST.add(Database.getEntry((String)"Beedrill"));
        ModChecker.pokecubePresent = true;
    }

    @Override
    public EnumSet<ModCompat.Type> compatTypes() {
        return EnumSet.of(ModCompat.Type.SPAWNS, ModCompat.Type.DIMENSION_SPAWN);
    }

    @Override
    public boolean onBeeSpawn(EntitySpawnEvent event, boolean isBaby) {
        if ((double)event.entity().m_217043_().m_188501_() >= BzModCompatibilityConfigs.spawnrateOfPokecubeBeePokemon) {
            return false;
        }
        if (!isBaby) {
            return false;
        }
        List<PokedexEntry> pokemonListToUse = BABY_POKECUBE_POKEMON_LIST;
        if (pokemonListToUse.size() == 0) {
            Bumblezone.LOGGER.warn("Error! List of POKECUBE_POKEMON_LIST is empty! Cannot spawn their bees. Please let TelepathicGrunt (The Bumblezone dev) know about this!");
            return false;
        }
        Mob entity = event.entity();
        LevelAccessor world = event.level();
        if (world instanceof WorldGenRegion) {
            return false;
        }
        PokedexEntry pokemonDatabase = pokemonListToUse.get(world.m_213780_().m_188503_(pokemonListToUse.size()));
        PokedexEntry.SpawnData spawn = pokemonDatabase.getSpawnData();
        if (spawn == null) {
            return false;
        }
        Mob pokemon = PokecubeCore.createPokemob((PokedexEntry)pokemonDatabase, (Level)entity.m_9236_());
        if (pokemon == null) {
            return false;
        }
        pokemon.m_21153_(pokemon.m_21233_());
        pokemon.m_6863_(isBaby);
        pokemon.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), world.m_213780_().m_188501_() * 360.0f, 0.0f);
        IPokemob pokemob = PokemobCaps.getPokemobFor((ICapabilityProvider)pokemon);
        pokemob.setExp(0, false);
        pokemon.m_6518_((ServerLevelAccessor)world, world.m_6436_(pokemon.m_20183_()), event.spawnType(), null, null);
        world.m_7967_((Entity)pokemon);
        return true;
    }

    @Override
    public void onEntitySpawnInDimension(Entity entity) {
        if (BzModCompatibilityConfigs.beePokemonGetsProtectionEffect && entity instanceof PokemobBase) {
            PokemobBase pokemobBase = (PokemobBase)entity;
            if (POKECUBE_POKEMON_LIST.contains(pokemobBase.pokemobCap.getPokedexEntry())) {
                pokemobBase.m_7292_(new MobEffectInstance(BzEffects.PROTECTION_OF_THE_HIVE.get(), 0x7FFFFFFA, 0, true, false));
            }
        }
    }
}

