/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlock;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.bossbars.ServerEssenceEvent;
import com.telepathicgrunt.the_bumblezone.client.rendering.rootmin.RootminPose;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.packets.MusicPacketFromServer;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EssenceBlockGreen
extends EssenceBlock {
    private static final int ROOTMIN_HEALTH = 30;
    private static final float STAGE_2_THRESHOLD = 0.75f;
    private static final float STAGE_3_THRESHOLD = 0.575f;
    private static final float STAGE_4_THRESHOLD = 0.3f;
    private static final float STAGE_5_THRESHOLD = 0.15f;

    public EssenceBlockGreen() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283784_));
    }

    @Override
    public ResourceLocation getArenaNbt() {
        return new ResourceLocation("the_bumblezone", "essence/green_arena");
    }

    @Override
    public int getEventTimeFrame() {
        return BzGeneralConfigs.greenArenaTimeFrameInTicks;
    }

    @Override
    public void awardPlayerWinStat(ServerPlayer serverPlayer) {
        serverPlayer.m_36220_(BzStats.LIFE_EVENT_DEFEATED_RL.get());
    }

    @Override
    public ServerEssenceEvent getServerEssenceEvent() {
        return (ServerEssenceEvent)new ServerEssenceEvent("essence.the_bumblezone.green_essence_event", BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.NOTCHED_6).m_7003_(true);
    }

    @Override
    public ResourceLocation getEssenceItemReward() {
        return new ResourceLocation("the_bumblezone", "gameplay/rewards/green_arena_victory");
    }

    @Override
    public int getEssenceXpReward() {
        return 3000;
    }

    @Override
    public boolean hasMiningFatigue() {
        return true;
    }

    @Override
    public void performUniqueArenaTick(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, EssenceBlockEntity essenceBlockEntity) {
        BlockPos rootminPos = blockPos.m_7918_(9, -3, 0);
        List<EssenceBlockEntity.EventEntities> eventEntitiesInArena = essenceBlockEntity.getEventEntitiesInArena();
        if (eventEntitiesInArena.isEmpty()) {
            EssenceBlockGreen.spawnRootmin(serverLevel, essenceBlockEntity, rootminPos, eventEntitiesInArena);
            if (eventEntitiesInArena.size() == 1) {
                List frames = serverLevel.m_45976_(HangingEntity.class, new AABB((double)((float)blockPos.m_123341_() - (float)essenceBlockEntity.getArenaSize().m_123341_() * 0.5f), (double)((float)blockPos.m_123342_() - (float)essenceBlockEntity.getArenaSize().m_123342_() * 0.5f), (double)((float)blockPos.m_123343_() - (float)essenceBlockEntity.getArenaSize().m_123343_() * 0.5f), (double)((float)blockPos.m_123341_() + (float)essenceBlockEntity.getArenaSize().m_123341_() * 0.5f), (double)((float)blockPos.m_123342_() + (float)essenceBlockEntity.getArenaSize().m_123342_() * 0.5f), (double)((float)blockPos.m_123343_() + (float)essenceBlockEntity.getArenaSize().m_123343_() * 0.5f)));
                frames.forEach(frame -> eventEntitiesInArena.add(new EssenceBlockEntity.EventEntities(frame.m_20148_())));
            }
        }
        if (!eventEntitiesInArena.isEmpty()) {
            RootminEntity rootminEntity;
            EssenceBlockEntity.EventEntities eventEntity;
            Entity entity = null;
            Iterator<EssenceBlockEntity.EventEntities> iterator = eventEntitiesInArena.iterator();
            while (iterator.hasNext() && !((entity = serverLevel.m_8791_((eventEntity = iterator.next()).uuid())) instanceof RootminEntity)) {
                entity = null;
            }
            float progress = essenceBlockEntity.getEventBar().m_142717_();
            if (progress == 0.0f && entity == null) {
                EssenceBlockEntity.EndEvent(serverLevel, blockPos, blockState, essenceBlockEntity, true);
                return;
            }
            if (entity == null) {
                entity = EssenceBlockGreen.spawnRootmin(serverLevel, essenceBlockEntity, rootminPos, eventEntitiesInArena);
            }
            if (entity == null || !(entity instanceof RootminEntity) || !(rootminEntity = (RootminEntity)entity).getEssenceController().equals(essenceBlockEntity.getUUID())) {
                eventEntitiesInArena.remove(0);
                return;
            }
            int hitsLeft = Math.round(progress * 30.0f);
            RootminPose rootminPose = rootminEntity.getRootminPose();
            if (!rootminEntity.m_21224_()) {
                rootminEntity.m_21153_(hitsLeft);
            }
            float rootminHealthPercent = rootminEntity.m_21223_() / 30.0f;
            if (rootminPose == RootminPose.SHOCK || rootminPose == RootminPose.ANGRY || rootminPose == RootminPose.CURSE) {
                if (rootminEntity.m_21188_() != null && rootminPose == RootminPose.SHOCK) {
                    if (rootminHealthPercent > 0.75f && rootminHealthPercent < 0.8f) {
                        rootminEntity.runAngry();
                    } else if (rootminHealthPercent > 0.575f && rootminHealthPercent < 0.625f) {
                        rootminEntity.runAngry();
                    } else if (rootminHealthPercent > 0.3f && rootminHealthPercent < 0.35000002f) {
                        rootminEntity.runCurse();
                    } else if (rootminHealthPercent <= 0.3f) {
                        rootminEntity.setRootminPose(RootminPose.NONE);
                    }
                    --hitsLeft;
                    rootminEntity.m_6703_(null);
                }
            } else {
                boolean fire;
                Vec3 desiredRootminSpot = Vec3.m_82512_((Vec3i)rootminPos).m_82520_(0.0, -0.5, 0.0);
                if (!rootminEntity.m_20182_().equals((Object)desiredRootminSpot)) {
                    Vec3 diff = desiredRootminSpot.m_82546_(rootminEntity.m_20182_());
                    if (diff.m_82553_() <= 3.0 && diff.m_82553_() > 0.05) {
                        Vec3 moveDirection = diff.m_82490_(0.1);
                        rootminEntity.m_20334_(moveDirection.m_7096_(), moveDirection.m_7098_(), moveDirection.m_7094_());
                    } else if (diff.m_82553_() > 3.0) {
                        rootminEntity.m_20219_(desiredRootminSpot);
                    }
                }
                int interval = rootminHealthPercent > 0.3f && rootminHealthPercent <= 0.575f ? Mth.m_269140_((float)rootminHealthPercent, (int)15, (int)35) : Mth.m_269140_((float)rootminHealthPercent, (int)10, (int)45);
                boolean bl = fire = rootminEntity.f_19797_ % interval == 0;
                if (!fire && rootminHealthPercent <= 0.3f) {
                    boolean bl2 = fire = (rootminEntity.f_19797_ + 4) % interval == 0;
                    if (!fire && rootminHealthPercent <= 0.15f) {
                        boolean bl3 = fire = (rootminEntity.f_19797_ + 7) % interval == 0;
                    }
                }
                if (fire && !rootminEntity.m_21224_()) {
                    BlockPos playerArea = blockPos.m_7918_(-9, -3, 0);
                    List players = serverLevel.m_45976_(Player.class, new AABB((double)(playerArea.m_123341_() - 1), (double)(playerArea.m_123342_() - 1), (double)(playerArea.m_123343_() - 1), (double)(playerArea.m_123341_() + 2), (double)(playerArea.m_123342_() + 3), (double)(playerArea.m_123343_() + 2)));
                    if (essenceBlockEntity.getEventTimer() < this.getEventTimeFrame() - 100 && !players.isEmpty()) {
                        boolean isHoming;
                        rootminEntity.setRootminShield(false);
                        boolean bl4 = isHoming = rootminHealthPercent > 0.3f && rootminHealthPercent <= 0.575f;
                        if (isHoming) {
                            RandomSource randomSource = rootminEntity.m_217043_();
                            rootminEntity.m_7618_(EntityAnchorArgument.Anchor.FEET, ((Player)players.get(0)).m_20182_().m_82520_(randomSource.m_188500_() * 21.0 - 10.0, randomSource.m_188500_() * 21.0 - 10.0, randomSource.m_188500_() * 21.0 - 10.0));
                        } else {
                            rootminEntity.m_7618_(EntityAnchorArgument.Anchor.FEET, ((Player)players.get(0)).m_20182_());
                        }
                        if (rootminHealthPercent > 0.575f && rootminHealthPercent <= 0.75f) {
                            rootminEntity.runMultiShoot((LivingEntity)players.get(0), (float)Mth.m_14139_((double)rootminHealthPercent, (double)1.1, (double)0.8), 3);
                        } else {
                            rootminEntity.runShoot((LivingEntity)players.get(0), isHoming ? 0.8f : (float)Mth.m_14139_((double)rootminHealthPercent, (double)1.7, (double)0.9), isHoming);
                        }
                    } else {
                        rootminEntity.m_7618_(EntityAnchorArgument.Anchor.FEET, Vec3.m_82528_((Vec3i)Direction.WEST.m_122436_()).m_82549_(rootminEntity.m_20182_()));
                        rootminEntity.setRootminShield(true);
                    }
                }
            }
            float newProgress = (float)hitsLeft / 30.0f;
            essenceBlockEntity.getEventBar().m_142711_(newProgress);
            essenceBlockEntity.m_6596_();
        }
    }

    private static Entity spawnRootmin(ServerLevel serverLevel, EssenceBlockEntity essenceBlockEntity, BlockPos rootminPos, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena) {
        Entity entity = BzEntities.ROOTMIN.get().m_262496_(serverLevel, rootminPos, MobSpawnType.TRIGGERED);
        if (entity instanceof RootminEntity) {
            AttributeInstance knockbackResistanceAttribute;
            RootminEntity rootminEntity = (RootminEntity)entity;
            rootminEntity.m_20049_("the_bumblezone.green_essence_arena");
            rootminEntity.setRootminShield(true);
            rootminEntity.setEssenceController(essenceBlockEntity.getUUID());
            rootminEntity.setEssenceControllerBlockPos(essenceBlockEntity.m_58899_());
            rootminEntity.setEssenceControllerDimension((ResourceKey<Level>)serverLevel.m_46472_());
            AttributeInstance livingEntityAttributeHealth = rootminEntity.m_21051_(Attributes.f_22276_);
            if (livingEntityAttributeHealth != null) {
                float extraHealth = 30.0f - rootminEntity.m_21233_();
                livingEntityAttributeHealth.m_22125_(new AttributeModifier(UUID.fromString("03c85bd0-09eb-11ee-be56-0242ac120002"), "Essence Arena Health Boost", (double)extraHealth, AttributeModifier.Operation.ADDITION));
                rootminEntity.m_5634_(extraHealth + rootminEntity.m_21233_());
            }
            if ((knockbackResistanceAttribute = rootminEntity.m_21051_(Attributes.f_22278_)) != null) {
                knockbackResistanceAttribute.m_22125_(new AttributeModifier(UUID.fromString("0ebdc338-5575-11ee-8c99-0242ac120002"), "Essence Arena Knockback Resistance Boost", 0.25, AttributeModifier.Operation.ADDITION));
            }
            entity.m_7618_(EntityAnchorArgument.Anchor.EYES, Vec3.m_82528_((Vec3i)Direction.SOUTH.m_122436_()));
            eventEntitiesInArena.add(new EssenceBlockEntity.EventEntities(entity.m_20148_()));
        }
        return entity;
    }

    @Override
    public void onPlayerEnter(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((Player)serverPlayer, BzSounds.LIFE_EVENT.get().m_11660_(), true);
        super.onPlayerEnter(serverLevel, serverPlayer, essenceBlockEntity);
    }

    @Override
    public void onPlayerLeave(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((Player)serverPlayer, BzSounds.LIFE_EVENT.get().m_11660_(), false);
        super.onPlayerLeave(serverLevel, serverPlayer, essenceBlockEntity);
    }
}

