/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.items;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HoneyCompassItemProperty {
    public static ClampedItemPropertyFunction getClampedItemPropertyFunction() {
        return new ClampedItemPropertyFunction(){
            private final CompassWobble wobble = new CompassWobble();
            private final CompassWobble wobbleRandom = new CompassWobble();

            public float m_142187_(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int i) {
                LivingEntity entity;
                Object object = entity = livingEntity != null ? livingEntity : itemStack.m_41609_();
                if (entity == null) {
                    return 0.0f;
                }
                if (clientLevel == null && entity.m_9236_() instanceof ClientLevel) {
                    clientLevel = (ClientLevel)entity.m_9236_();
                }
                if (clientLevel == null) {
                    return 0.0f;
                }
                BlockPos blockPos = this.getStructurePosition((Level)clientLevel, itemStack.m_41784_());
                long gameTime = clientLevel.m_46467_();
                if (blockPos != null && !(entity.m_20182_().m_82531_((double)blockPos.m_123341_() + 0.5, entity.m_20182_().m_7098_(), (double)blockPos.m_123343_() + 0.5) < (double)1.0E-5f)) {
                    double angleToRender;
                    boolean isLocalPlayer = livingEntity instanceof Player && ((Player)livingEntity).m_7578_();
                    double currentFacingAngle = 0.0;
                    if (isLocalPlayer) {
                        currentFacingAngle = livingEntity.m_146908_();
                    } else if (entity instanceof ItemFrame) {
                        currentFacingAngle = this.getFrameRotation((ItemFrame)entity);
                    } else if (entity instanceof ItemEntity) {
                        currentFacingAngle = 180.0f - ((ItemEntity)entity).m_32008_(0.5f) / ((float)Math.PI * 2) * 360.0f;
                    } else if (livingEntity != null) {
                        currentFacingAngle = livingEntity.f_20883_;
                    }
                    currentFacingAngle = Mth.m_14109_((double)(currentFacingAngle / 360.0), (double)1.0);
                    double angleToTarget = this.getAngleTo(Vec3.m_82512_((Vec3i)blockPos), (Entity)entity) / 6.2831854820251465;
                    if (isLocalPlayer) {
                        if (this.wobble.shouldUpdate(gameTime)) {
                            this.wobble.update(gameTime, 0.5 - (currentFacingAngle - 0.25));
                        }
                        angleToRender = angleToTarget + this.wobble.rotation;
                    } else {
                        angleToRender = 0.5 - (currentFacingAngle - 0.25 - angleToTarget);
                    }
                    return Mth.m_14091_((float)((float)angleToRender), (float)1.0f);
                }
                if (this.wobbleRandom.shouldUpdate(gameTime)) {
                    this.wobbleRandom.update(gameTime, Math.random());
                }
                double d = this.wobbleRandom.rotation + (double)((float)this.hash(i) / 2.1474836E9f);
                return Mth.m_14091_((float)((float)d), (float)1.0f);
            }

            private int hash(int i) {
                return i * 1327217883;
            }

            @Nullable
            private BlockPos getStructurePosition(Level level, CompoundTag compoundTag) {
                Optional optional;
                boolean structurePos = compoundTag.m_128441_("TargetPos");
                boolean dimension = compoundTag.m_128441_("TargetDimension");
                if (structurePos && dimension && (optional = Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag.m_128423_("TargetDimension")).result()).isPresent() && level.m_46472_() == optional.get()) {
                    return NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_("TargetPos"));
                }
                return null;
            }

            private double getFrameRotation(ItemFrame itemFrame) {
                Direction direction = itemFrame.m_6350_();
                int itemFrameFacingAngle = direction.m_122434_().m_122478_() ? 90 * direction.m_122421_().m_122540_() : 0;
                return Mth.m_14098_((int)(180 + direction.m_122416_() * 90 + itemFrame.m_31823_() * 45 + itemFrameFacingAngle));
            }

            private double getAngleTo(Vec3 vec3, Entity entity) {
                return Math.atan2(vec3.m_7094_() - entity.m_20189_(), vec3.m_7096_() - entity.m_20185_());
            }
        };
    }

    static class CompassWobble {
        double rotation;
        private double deltaRotation;
        private long lastUpdateTick;

        CompassWobble() {
        }

        boolean shouldUpdate(long currentTick) {
            return this.lastUpdateTick != currentTick;
        }

        void update(long lastTick, double currentRotation) {
            this.lastUpdateTick = lastTick;
            double rotDiff = currentRotation - this.rotation;
            rotDiff = Mth.m_14109_((double)(rotDiff + 0.5), (double)1.0) - 0.5;
            this.deltaRotation += rotDiff * 0.1;
            this.deltaRotation *= 0.8;
            this.rotation = Mth.m_14109_((double)(this.rotation + this.deltaRotation), (double)1.0);
        }
    }
}

