/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.enchantments;

import com.telepathicgrunt.the_bumblezone.events.entity.EntityAttackedEvent;
import com.telepathicgrunt.the_bumblezone.modinit.BzEnchantments;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.platform.BzEnchantment;
import com.telepathicgrunt.the_bumblezone.utils.OptionalBoolean;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class HiveLifelineEnchantment
extends BzEnchantment {
    private static final TargetingConditions SEE_THROUGH_WALLS = TargetingConditions.m_148352_().m_148355_().m_26893_();

    public HiveLifelineEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.ARMOR, new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET});
    }

    public boolean m_6591_() {
        return true;
    }

    public boolean m_6594_() {
        return false;
    }

    public boolean m_6592_() {
        return false;
    }

    public int m_6183_(int level) {
        return 50 + level * 5;
    }

    public int m_6175_(int level) {
        return 50 + level * 10;
    }

    public int m_6586_() {
        return 1;
    }

    public boolean m_6081_(ItemStack stack) {
        return stack.m_204117_(BzTags.ENCHANTABLE_HIVE_LIFELINE) || stack.m_150930_(Items.f_42517_);
    }

    @Override
    public OptionalBoolean bz$canApplyAtEnchantingTable(ItemStack stack) {
        return OptionalBoolean.of(this.m_6081_(stack));
    }

    public static boolean entityHurtEvent(EntityAttackedEvent event) {
        ServerPlayer player;
        LivingEntity livingEntity = event.entity();
        if (!(livingEntity instanceof ServerPlayer) || !((livingEntity = (player = (ServerPlayer)livingEntity).m_9236_()) instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)livingEntity;
        Entity attacker = event.source().m_7639_();
        if (attacker == null || attacker.m_6095_().m_204039_(BzTags.HIVE_LIFELINE_CANNOT_TRIGGER_LIFELINE)) {
            return false;
        }
        ItemStack currentHiveLifelineArmor = null;
        int hiveLifelineLevel = 0;
        for (ItemStack armorItem : player.m_6168_()) {
            Integer enchantmentResult;
            if (player.m_36335_().m_41519_(armorItem.m_41720_()) || (enchantmentResult = (Integer)EnchantmentHelper.m_44831_((ItemStack)armorItem).get((Object)BzEnchantments.HIVE_LIFELINE.get())) == null || enchantmentResult <= 0) continue;
            currentHiveLifelineArmor = armorItem;
            hiveLifelineLevel = enchantmentResult;
            break;
        }
        if (currentHiveLifelineArmor == null) {
            return false;
        }
        int baseRange = 16;
        int additionalRange = 6 * (hiveLifelineLevel - 1);
        List entitiesNearby = serverLevel.m_45971_(LivingEntity.class, SEE_THROUGH_WALLS, (LivingEntity)player, player.m_20191_().m_82400_((double)(baseRange + additionalRange)));
        entitiesNearby.sort(Comparator.comparingDouble(entity -> entity.m_20182_().m_82554_(player.m_20182_())));
        for (LivingEntity nearbyEntity : entitiesNearby) {
            Mob mob;
            if (!nearbyEntity.m_6095_().m_204039_(BzTags.HIVE_LIFELINE_TAKES_PLAYER_DAMAGE) || nearbyEntity.m_20147_() || nearbyEntity.m_21224_() || nearbyEntity instanceof Mob && (mob = (Mob)nearbyEntity).m_21525_()) continue;
            nearbyEntity.m_6469_(event.source(), event.amount());
            int armorCooldownTicks = 80;
            player.m_36335_().m_41524_(currentHiveLifelineArmor.m_41720_(), armorCooldownTicks);
            serverLevel.m_8767_((ParticleOptions)BzParticles.SPARKLE_PARTICLE.get(), player.m_20182_().m_7096_(), player.m_20182_().m_7098_() + 1.0, player.m_20182_().m_7094_(), 50, player.m_217043_().m_188583_() * 0.1, player.m_217043_().m_188583_() * 0.1 + 0.1, player.m_217043_().m_188583_() * 0.1, (double)player.m_217043_().m_188501_() * 0.1 + (double)0.1f);
            serverLevel.m_8767_((ParticleOptions)BzParticles.SPARKLE_PARTICLE.get(), nearbyEntity.m_20182_().m_7096_(), nearbyEntity.m_20182_().m_7098_() + 1.0, nearbyEntity.m_20182_().m_7094_(), 50, nearbyEntity.m_217043_().m_188583_() * 0.1, nearbyEntity.m_217043_().m_188583_() * 0.1 + 0.1, nearbyEntity.m_217043_().m_188583_() * 0.1, (double)nearbyEntity.m_217043_().m_188501_() * 0.1 + (double)0.1f);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123792_, nearbyEntity.m_20182_().m_7096_(), nearbyEntity.m_20182_().m_7098_() + 1.0, nearbyEntity.m_20182_().m_7094_(), 3, nearbyEntity.m_217043_().m_188583_() * 0.4, nearbyEntity.m_217043_().m_188583_() * 0.4 + 0.1, nearbyEntity.m_217043_().m_188583_() * 0.4, (double)nearbyEntity.m_217043_().m_188501_() * 0.1 + (double)0.1f);
            currentHiveLifelineArmor.m_41622_(1, (LivingEntity)player, item -> {});
            return true;
        }
        return false;
    }
}

