/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.essence;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.teleportation.BzWorldSavedData;
import com.telepathicgrunt.the_bumblezone.events.entity.EntityDeathEvent;
import com.telepathicgrunt.the_bumblezone.items.essence.AbilityEssenceItem;
import com.telepathicgrunt.the_bumblezone.mixin.entities.ServerPlayerAccessor;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.damagesource.DeathMessageType;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ContinuityEssence
extends AbilityEssenceItem {
    private static final Supplier<Integer> cooldownLengthInTicks = () -> BzGeneralConfigs.continuityEssenceCooldown;
    private static final Supplier<Integer> abilityUseAmount = () -> 1;
    private static final ConcurrentLinkedQueue<TickCapsule> NEXT_TICK_BEHAVIORS = new ConcurrentLinkedQueue();
    private static final Style INTENTIONAL_GAME_DESIGN_STYLE = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://bugs.mojang.com/browse/MCPE-28723")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"MCPE-28723")));

    public ContinuityEssence(Item.Properties properties) {
        super(properties, cooldownLengthInTicks, abilityUseAmount);
    }

    @Override
    public int getColor() {
        return 0xFFFFFF;
    }

    @Override
    void addDescriptionComponents(List<Component> components) {
        components.add((Component)Component.m_237115_((String)"item.the_bumblezone.essence_continuity_description_1").m_130940_(ChatFormatting.WHITE).m_130940_(ChatFormatting.ITALIC));
        components.add((Component)Component.m_237115_((String)"item.the_bumblezone.essence_continuity_description_2").m_130940_(ChatFormatting.WHITE).m_130940_(ChatFormatting.ITALIC));
    }

    @Override
    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean bl) {
        TickCapsule tickCapsule = NEXT_TICK_BEHAVIORS.poll();
        if (tickCapsule != null) {
            if (level.m_46467_() > tickCapsule.tickTarget) {
                tickCapsule.runnable().run();
            } else {
                NEXT_TICK_BEHAVIORS.add(tickCapsule);
            }
        }
        super.m_6883_(stack, level, entity, i, bl);
    }

    @Override
    void applyAbilityEffects(ItemStack stack, Level level, ServerPlayer serverPlayer) {
    }

    public static boolean CancelledDeath(EntityDeathEvent event) {
        LivingEntity livingEntity = event.entity();
        if (livingEntity instanceof ServerPlayer) {
            Item item;
            ServerPlayer player = (ServerPlayer)livingEntity;
            DamageSource source = event.source();
            Registry damageTypeRegistry = player.m_9236_().m_9598_().m_175515_(Registries.f_268580_);
            if (damageTypeRegistry.m_6246_(DamageTypes.f_286979_) == event.source().m_269415_() && source.m_7639_() == null && source.m_7640_() == null && source.m_7270_() == null) {
                return false;
            }
            ItemStack stack = player.m_21206_();
            if (player.m_21224_() && (item = stack.m_41720_()) instanceof ContinuityEssence) {
                ContinuityEssence continuityEssence = (ContinuityEssence)item;
                if (ContinuityEssence.getIsActive(stack) && !player.m_36335_().m_41519_(stack.m_41720_())) {
                    ContinuityEssence.playerReset(player);
                    ArrayList mobEffectInstances = new ArrayList(player.m_21220_());
                    for (MobEffectInstance mobEffectInstance : mobEffectInstances) {
                        if (mobEffectInstance.m_19544_().m_19486_()) continue;
                        player.m_21195_(mobEffectInstance.m_19544_());
                    }
                    MinecraftServer server = player.m_9236_().m_7654_();
                    if (server != null) {
                        ContinuityEssence.spawnParticles(player.m_284548_(), player.m_20182_(), player.m_217043_());
                        ContinuityEssence.respawn(stack, continuityEssence, player, server, event.source());
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static void respawn(ItemStack stack, ContinuityEssence continuityEssence, ServerPlayer serverPlayer, MinecraftServer server, DamageSource damageSource) {
        boolean isRespawnAnchor;
        BlockPos playerRespawnBlockPos;
        Vec3 playerRespawnPosition;
        ServerLevel finalDestination;
        ResourceKey oldDimension = serverPlayer.m_9236_().m_46472_();
        BlockPos oldPosition = serverPlayer.m_20183_();
        ResourceKey respawnDimension = serverPlayer.m_8963_();
        BlockPos respawningLinkedPosition = serverPlayer.m_8961_();
        float respawnAngle = serverPlayer.m_8962_();
        boolean forcedRespawn = serverPlayer.m_8964_();
        ServerLevel desiredDestination = server.m_129880_(respawnDimension);
        Optional optionalRespawnPoint = desiredDestination != null && respawningLinkedPosition != null ? Player.m_36130_((ServerLevel)desiredDestination, (BlockPos)respawningLinkedPosition, (float)respawnAngle, (boolean)forcedRespawn, (boolean)true) : Optional.empty();
        ServerLevel serverLevel = finalDestination = desiredDestination != null && optionalRespawnPoint.isPresent() ? desiredDestination : server.m_129783_();
        if (optionalRespawnPoint.isEmpty() && respawningLinkedPosition != null) {
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132153_, 0.0f));
        }
        if (optionalRespawnPoint.isPresent()) {
            playerRespawnPosition = (Vec3)optionalRespawnPoint.get();
            playerRespawnBlockPos = BlockPos.m_274446_((Position)playerRespawnPosition);
            BlockState blockState = finalDestination.m_8055_(respawningLinkedPosition);
            isRespawnAnchor = blockState.m_60713_(Blocks.f_50724_);
        } else {
            playerRespawnPosition = finalDestination.m_220360_().m_252807_();
            playerRespawnBlockPos = finalDestination.m_220360_();
            isRespawnAnchor = false;
        }
        BzWorldSavedData.queueEntityToGenericTeleport((Entity)serverPlayer, (ResourceKey<Level>)finalDestination.m_46472_(), playerRespawnBlockPos, () -> {
            if (isRespawnAnchor) {
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket((Holder)SoundEvents.f_12377_, SoundSource.BLOCKS, (double)respawningLinkedPosition.m_123341_(), (double)respawningLinkedPosition.m_123342_(), (double)respawningLinkedPosition.m_123343_(), 1.0f, 1.0f, finalDestination.m_213780_().m_188505_()));
            }
            ContinuityEssence.playerReset(serverPlayer);
            ItemStack respawnedPlayerStack = serverPlayer.m_21206_();
            Item patt0$temp = respawnedPlayerStack.m_41720_();
            if (patt0$temp instanceof ContinuityEssence) {
                ContinuityEssence continuityEssenceRespawnedPlayer = (ContinuityEssence)patt0$temp;
                continuityEssenceRespawnedPlayer.decrementAbilityUseRemaining(respawnedPlayerStack, serverPlayer, 1, true);
            }
            NEXT_TICK_BEHAVIORS.add(new TickCapsule(() -> {
                ContinuityEssence.spawnParticles(finalDestination, playerRespawnPosition, finalDestination.m_213780_());
                serverPlayer.m_36335_().m_41524_((Item)continuityEssence, continuityEssence.getCooldownTickLength());
            }, serverPlayer.m_284548_().m_46467_() + 5L));
        });
        ContinuityEssence.spawnBook(serverPlayer, damageSource, (ResourceKey<Level>)oldDimension, oldPosition, finalDestination, playerRespawnPosition);
    }

    private static void spawnBook(ServerPlayer serverPlayer, DamageSource damageSource, ResourceKey<Level> oldDimension, BlockPos oldPosition, ServerLevel finalDestination, Vec3 playerRespawnPosition) {
        ItemStack newBook = Items.f_42615_.m_7968_();
        CompoundTag compoundTag = newBook.m_41784_();
        compoundTag.m_128359_("title", "Essence of Continuity Record");
        compoundTag.m_128359_("author", serverPlayer.m_7755_().getString());
        ListTag listTag = new ListTag();
        Entity causer = damageSource.m_7639_();
        if (causer == null) {
            listTag.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237110_((String)"item.the_bumblezone.essence_continuity_written_book_body_no_causer", (Object[])new Object[]{LocalDate.now().toString(), oldPosition.m_123341_(), oldPosition.m_123342_(), oldPosition.m_123343_(), oldDimension.m_135782_().toString(), ContinuityEssence.getDeathMessage(finalDestination, damageSource, serverPlayer)}))));
        } else {
            listTag.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237110_((String)"item.the_bumblezone.essence_continuity_written_book_body", (Object[])new Object[]{LocalDate.now().toString(), oldPosition.m_123341_(), oldPosition.m_123342_(), oldPosition.m_123343_(), oldDimension.m_135782_().toString(), causer.m_7755_(), ContinuityEssence.getDeathMessage(finalDestination, damageSource, serverPlayer)}))));
        }
        compoundTag.m_128365_("pages", (Tag)listTag);
        ItemEntity itementity = new ItemEntity((Level)finalDestination, playerRespawnPosition.m_7096_(), playerRespawnPosition.m_7098_(), playerRespawnPosition.m_7094_(), newBook);
        itementity.m_32060_();
        finalDestination.m_7967_((Entity)itementity);
    }

    public static Component getDeathMessage(ServerLevel serverLevel, DamageSource damageSource, ServerPlayer serverPlayer) {
        if (damageSource.m_269415_() == serverLevel.m_269111_().m_269264_().m_269415_()) {
            return Component.m_237110_((String)"death.attack.generic", (Object[])new Object[]{serverPlayer.m_5446_()});
        }
        DeathMessageType deathMessageType = damageSource.m_269415_().f_268472_();
        if (deathMessageType == DeathMessageType.FALL_VARIANTS && damageSource.m_7639_() != null) {
            return ContinuityEssence.getFallMessage(damageSource.m_7639_(), serverPlayer);
        }
        if (deathMessageType == DeathMessageType.INTENTIONAL_GAME_DESIGN) {
            String string = "death.attack." + damageSource.m_19385_();
            MutableComponent component = ComponentUtils.m_130748_((Component)Component.m_237115_((String)(string + ".link"))).m_130948_(INTENTIONAL_GAME_DESIGN_STYLE);
            return Component.m_237110_((String)(string + ".message"), (Object[])new Object[]{serverPlayer.m_5446_(), component});
        }
        return damageSource.m_6157_((LivingEntity)serverPlayer);
    }

    private static Component getFallMessage(Entity entity, ServerPlayer serverPlayer) {
        Component component = entity.m_5446_();
        if (component != null) {
            return ContinuityEssence.getMessageForAssistedFall(serverPlayer, entity, component, "death.fell.finish.item", "death.fell.finish");
        }
        return Component.m_237110_((String)"death.fell.killer", (Object[])new Object[]{entity.m_5446_()});
    }

    private static Component getMessageForAssistedFall(ServerPlayer serverPlayer, Entity entity, Component component, String string, String string2) {
        ItemStack itemStack;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            itemStack = livingEntity.m_21205_();
        } else {
            itemStack = ItemStack.f_41583_;
        }
        if (!itemStack.m_41619_() && itemStack.m_41788_()) {
            return Component.m_237110_((String)string, (Object[])new Object[]{serverPlayer.m_5446_(), component, itemStack.m_41611_()});
        }
        return Component.m_237110_((String)string2, (Object[])new Object[]{serverPlayer.m_5446_(), component});
    }

    public static void spawnParticles(ServerLevel world, Vec3 location, RandomSource random) {
        world.m_8767_((ParticleOptions)ParticleTypes.f_123815_, location.m_7096_(), location.m_7098_() + 1.0, location.m_7094_(), 100, random.m_188583_() * 0.1, random.m_188583_() * 0.1 + 0.1, random.m_188583_() * 0.1, (double)random.m_188501_() * 0.4 + (double)0.2f);
        world.m_8767_((ParticleOptions)ParticleTypes.f_123809_, location.m_7096_(), location.m_7098_() + 1.0, location.m_7094_(), 400, 1.0, 1.0, 1.0, (double)random.m_188501_() * 0.5 + (double)1.2f);
    }

    private static void playerReset(ServerPlayer player) {
        player.m_21153_(player.m_21233_());
        player.m_36324_().m_150378_(0.0f);
        player.m_36324_().m_38707_(20, 20.0f);
        player.m_20095_();
        player.m_20301_(player.m_6062_());
        ((ServerPlayerAccessor)player).bumblezone$setStartingToFallPosition(null);
        player.f_19802_ = 40;
        player.f_20919_ = 0;
        player.f_19789_ = 0.0f;
        player.m_5796_();
        player.m_6038_();
        player.m_20153_();
        player.m_20091_();
        player.m_20256_(new Vec3(0.0, 0.0, 0.0));
        player.m_146867_();
        for (MobEffectInstance effect : new ArrayList(player.m_21220_())) {
            if (effect.m_19544_().m_19483_() != MobEffectCategory.HARMFUL) continue;
            player.m_21195_(effect.m_19544_());
        }
    }

    private record TickCapsule(Runnable runnable, long tickTarget) {
    }
}

