/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.essence;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.items.essence.AbilityEssenceItem;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public class RadianceEssence
extends AbilityEssenceItem {
    private static final Supplier<Integer> cooldownLengthInTicks = () -> BzGeneralConfigs.radianceEssenceCooldown;
    private static final Supplier<Integer> abilityUseAmount = () -> BzGeneralConfigs.radianceEssenceAbilityUse;

    public RadianceEssence(Item.Properties properties) {
        super(properties, cooldownLengthInTicks, abilityUseAmount);
    }

    @Override
    public int getColor() {
        return 15384615;
    }

    @Override
    void addDescriptionComponents(List<Component> components) {
        components.add((Component)Component.m_237115_((String)"item.the_bumblezone.essence_radiance_description_1").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
        components.add((Component)Component.m_237115_((String)"item.the_bumblezone.essence_radiance_description_2").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
    }

    @Override
    public void applyAbilityEffects(ItemStack stack, Level level, ServerPlayer serverPlayer) {
        if (RadianceEssence.getIsActive(stack) && level.m_45517_(LightLayer.SKY, serverPlayer.m_20183_()) >= 13 && level.m_46461_()) {
            if (((long)serverPlayer.f_19797_ + serverPlayer.m_20148_().getLeastSignificantBits()) % (serverPlayer.m_20142_() ? 2L : 12L) == 0L) {
                RadianceEssence.spawnParticles(serverPlayer.m_284548_(), serverPlayer.m_20182_(), serverPlayer.m_217043_());
            }
            if (((long)serverPlayer.f_19797_ + serverPlayer.m_20148_().getLeastSignificantBits()) % 25L == 0L) {
                List<Holder> radianceEffects = BuiltInRegistries.f_256974_.m_203431_(BzTags.RADIANCE_SUN_EFFECTS).stream().flatMap(HolderSet.ListBacked::m_203614_).filter(Holder::m_203633_).toList();
                for (Holder effectHolder : radianceEffects) {
                    if (effectHolder.m_203334_() == MobEffects.f_19596_) {
                        serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 120, 0, false, false));
                        this.decrementAbilityUseRemaining(stack, serverPlayer, serverPlayer.m_20142_() ? 3 : 1);
                        if (!RadianceEssence.getForcedCooldown(stack)) continue;
                        return;
                    }
                    if (effectHolder.m_203334_() == MobEffects.f_19606_) {
                        serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 120, 1, false, false));
                        this.decrementAbilityUseRemaining(stack, serverPlayer, 1);
                        if (!RadianceEssence.getForcedCooldown(stack)) continue;
                        return;
                    }
                    if (effectHolder.m_203334_() == MobEffects.f_19605_) {
                        serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 120, 0, false, false));
                        this.decrementAbilityUseRemaining(stack, serverPlayer, serverPlayer.m_21223_() < serverPlayer.m_21233_() ? 5 : 1);
                        if (!RadianceEssence.getForcedCooldown(stack)) continue;
                        return;
                    }
                    if (effectHolder.m_203334_() == MobEffects.f_19598_) {
                        serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 120, 1, false, false));
                        this.decrementAbilityUseRemaining(stack, serverPlayer, 1);
                        if (!RadianceEssence.getForcedCooldown(stack)) continue;
                        return;
                    }
                    if (effectHolder.m_203334_() == MobEffects.f_19618_) {
                        serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19618_, 120, 0, false, false));
                        this.decrementAbilityUseRemaining(stack, serverPlayer, serverPlayer.m_36324_().m_38721_() ? 3 : 1);
                        if (!RadianceEssence.getForcedCooldown(stack)) continue;
                        return;
                    }
                    serverPlayer.m_7292_(new MobEffectInstance((MobEffect)effectHolder.m_203334_(), 120, 0, false, false));
                    this.decrementAbilityUseRemaining(stack, serverPlayer, 1);
                    if (!RadianceEssence.getForcedCooldown(stack)) continue;
                    return;
                }
                for (ItemStack armorItem : serverPlayer.m_6168_()) {
                    if (!armorItem.m_41763_() || !armorItem.m_41768_() || armorItem.m_204117_(BzTags.RADIANCE_CANNOT_REPAIR)) continue;
                    armorItem.m_41721_(armorItem.m_41773_() - 1);
                    this.decrementAbilityUseRemaining(stack, serverPlayer, 10);
                    if (!RadianceEssence.getForcedCooldown(stack)) continue;
                    return;
                }
            }
        }
    }

    public static void spawnParticles(ServerLevel world, Vec3 location, RandomSource random) {
        world.m_8767_((ParticleOptions)ParticleTypes.f_276452_, location.m_7096_(), location.m_7098_() + 1.0, location.m_7094_(), 1, random.m_188583_() * 0.15, random.m_188583_() * 0.2 + 0.1, random.m_188583_() * 0.15, 0.0);
    }

    public static boolean IsRadianceEssenceActive(Player player) {
        if (player != null) {
            ItemStack offHandItem = player.m_21206_();
            return offHandItem.m_150930_(BzItems.ESSENCE_RADIANCE.get()) && RadianceEssence.getIsActive(offHandItem);
        }
        return false;
    }
}

