/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.essence;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.events.entity.EntityDeathEvent;
import com.telepathicgrunt.the_bumblezone.items.essence.AbilityEssenceItem;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RagingEssence
extends AbilityEssenceItem {
    private static final Supplier<Integer> cooldownLengthInTicks = () -> BzGeneralConfigs.ragingEssenceCooldown;
    private static final Supplier<Integer> abilityUseAmount = () -> BzGeneralConfigs.ragingEssenceAbilityUse;
    private static final int radius = 24;
    private static final int trackingRange = 2304;
    private static final int maxEmpoweredTimeFramePer5Ticks = 75;
    private static final int maxCurrentTargets = 4;
    private static final String RAGE_STATE_TAG = "rageStateLevel";
    private static final String CURRENT_TARGET_TAG = "currentTargets";
    private static final String EMPOWERED_TIME_REMAINING_TAG = "empoweredTimeRemaining";

    public RagingEssence(Item.Properties properties) {
        super(properties, cooldownLengthInTicks, abilityUseAmount);
    }

    @Override
    public int getColor() {
        return 0xFF2B2B;
    }

    @Override
    void addDescriptionComponents(List<Component> components) {
        components.add((Component)Component.m_237115_((String)"item.the_bumblezone.essence_raging_description_1").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC));
        components.add((Component)Component.m_237115_((String)"item.the_bumblezone.essence_raging_description_2").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC));
    }

    public static void setRageState(ItemStack stack, short rageState) {
        stack.m_41784_().m_128376_(RAGE_STATE_TAG, rageState);
    }

    public static short getRageState(ItemStack stack) {
        return stack.m_41784_().m_128448_(RAGE_STATE_TAG);
    }

    public static void setEmpoweredTimeRemaining(ItemStack stack, int empoweredTimeRemaining) {
        stack.m_41784_().m_128405_(EMPOWERED_TIME_REMAINING_TAG, empoweredTimeRemaining);
    }

    public static int getEmpoweredTimeRemaining(ItemStack stack) {
        return stack.m_41784_().m_128451_(EMPOWERED_TIME_REMAINING_TAG);
    }

    public static void setCurrentTargets(ItemStack stack, List<UUID> targetsToKill) {
        CompoundTag compoundTag = stack.m_41784_();
        ListTag targetList = new ListTag();
        for (UUID target : targetsToKill) {
            targetList.add((Object)NbtUtils.m_129226_((UUID)target));
        }
        compoundTag.m_128365_(CURRENT_TARGET_TAG, (Tag)targetList);
    }

    public static List<UUID> getCurrentTargets(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41784_();
        ListTag targetListTags = compoundTag.m_128437_(CURRENT_TARGET_TAG, 11);
        ArrayList<UUID> targetsToKill = new ArrayList<UUID>();
        for (Tag tag : targetListTags) {
            targetsToKill.add(NbtUtils.m_129233_((Tag)tag));
        }
        return targetsToKill;
    }

    @Override
    public void applyAbilityEffects(ItemStack stack, Level level, ServerPlayer serverPlayer) {
        if (RagingEssence.getIsActive(stack)) {
            short rageState = RagingEssence.getRageState(stack);
            if (rageState > 0 && ((long)serverPlayer.f_19797_ + serverPlayer.m_20148_().getLeastSignificantBits()) % 5L == 0L) {
                RagingEssence.spawnParticles(serverPlayer.m_284548_(), serverPlayer.m_20182_(), serverPlayer.m_217043_(), rageState);
                int empoweredTimeRemaining = RagingEssence.getEmpoweredTimeRemaining(stack) - 1;
                RagingEssence.setEmpoweredTimeRemaining(stack, empoweredTimeRemaining);
                if (empoweredTimeRemaining == 0) {
                    RagingEssence.resetRage(stack, serverPlayer);
                    this.decrementAbilityUseRemaining(stack, serverPlayer, 1);
                    if (RagingEssence.getForcedCooldown(stack)) {
                        return;
                    }
                }
            }
            if (((long)serverPlayer.f_19797_ + serverPlayer.m_20148_().getLeastSignificantBits()) % 20L == 0L) {
                Object entities;
                List<UUID> currentTargetsToKill = RagingEssence.getCurrentTargets(stack);
                if (currentTargetsToKill.size() < 4 && rageState + currentTargetsToKill.size() <= BzGeneralConfigs.ragingEssenceStrengthLevels.length && !(entities = level.m_6249_((Entity)serverPlayer, new AABB(serverPlayer.m_20185_() - 24.0, serverPlayer.m_20186_() - 6.0, serverPlayer.m_20189_() - 24.0, serverPlayer.m_20185_() + 24.0, serverPlayer.m_20186_() + 6.0, serverPlayer.m_20189_() + 24.0), e -> !currentTargetsToKill.contains(e.m_20148_()) && RagingEssence.isTargetable(e, serverPlayer.m_20148_()))).isEmpty() && currentTargetsToKill.size() < 4) {
                    int entitiesToAdd;
                    entities.sort((e1, e2) -> (int)(((LivingEntity)e1).m_21223_() - ((LivingEntity)e2).m_21223_()));
                    int rageLeft = BzGeneralConfigs.ragingEssenceStrengthLevels.length - rageState;
                    for (int i = entitiesToAdd = Math.min(rageLeft + 1, 4) - currentTargetsToKill.size(); i >= 1 && !entities.isEmpty(); --i) {
                        if (i == 1) {
                            currentTargetsToKill.add(((Entity)entities.remove(entities.size() - 1)).m_20148_());
                            continue;
                        }
                        currentTargetsToKill.add(((Entity)entities.remove(0)).m_20148_());
                    }
                    RagingEssence.setCurrentTargets(stack, currentTargetsToKill);
                    return;
                }
                if (!currentTargetsToKill.isEmpty()) {
                    for (UUID uuid : currentTargetsToKill) {
                        Entity entity = serverPlayer.m_284548_().m_8791_(uuid);
                        if (entity != null && !(entity.m_20238_(serverPlayer.m_20182_()) > 5308416.0)) continue;
                        RagingEssence.resetRage(stack, serverPlayer);
                        return;
                    }
                }
                if (rageState > 0) {
                    List<Holder> radianceEffects = BuiltInRegistries.f_256974_.m_203431_(BzTags.RAGING_RAGE_EFFECTS).stream().flatMap(HolderSet.ListBacked::m_203614_).filter(Holder::m_203633_).toList();
                    for (Holder effectHolder : radianceEffects) {
                        if (effectHolder.m_203334_() == MobEffects.f_19600_) {
                            serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19600_, RagingEssence.getEmpoweredTimeRemaining(stack) * 4, BzGeneralConfigs.ragingEssenceStrengthLevels[rageState - 1] - 1, false, false));
                            continue;
                        }
                        serverPlayer.m_7292_(new MobEffectInstance((MobEffect)effectHolder.m_203334_(), RagingEssence.getEmpoweredTimeRemaining(stack) * 4, (int)rageState, false, false));
                    }
                }
            }
        }
    }

    public static void OnEntityDeath(EntityDeathEvent event) {
        DamageSource damageSource = event.source();
        LivingEntity livingEntity = event.entity();
        Entity entity = damageSource.m_7639_();
        if (entity instanceof ServerPlayer) {
            Item item;
            ServerPlayer player = (ServerPlayer)entity;
            ItemStack stack = player.m_21206_();
            if (livingEntity.m_21224_() && (item = stack.m_41720_()) instanceof RagingEssence) {
                RagingEssence ragingEssence = (RagingEssence)item;
                if (RagingEssence.getIsActive(stack) && !player.m_36335_().m_41519_(stack.m_41720_())) {
                    List<UUID> currentTargetsToKill = RagingEssence.getCurrentTargets(stack);
                    int rageState = RagingEssence.getRageState(stack) + 1;
                    if (rageState == BzGeneralConfigs.ragingEssenceStrengthLevels.length || currentTargetsToKill.contains(livingEntity.m_20148_())) {
                        if (rageState > BzGeneralConfigs.ragingEssenceStrengthLevels.length) {
                            RagingEssence.resetRage(stack, player);
                        } else {
                            RagingEssence.setRageState(stack, (short)rageState);
                            RagingEssence.setEmpoweredTimeRemaining(stack, 75);
                            currentTargetsToKill.remove(livingEntity.m_20148_());
                            RagingEssence.setCurrentTargets(stack, currentTargetsToKill);
                            ragingEssence.decrementAbilityUseRemaining(stack, player, 1);
                        }
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isTargetable(Entity entity, UUID playerUUID) {
        if (!(entity instanceof LivingEntity)) return false;
        LivingEntity livingEntity = (LivingEntity)entity;
        if (entity.m_20147_()) return false;
        if (!livingEntity.m_5789_()) return false;
        if (livingEntity.m_21224_()) return false;
        if (entity instanceof Enemy) return true;
        if (!(entity instanceof NeutralMob)) return false;
        NeutralMob neutralMob = (NeutralMob)entity;
        if (neutralMob.m_6120_() != playerUUID) return false;
        return true;
    }

    private static void resetRage(ItemStack stack, ServerPlayer serverPlayer) {
        RagingEssence.setCurrentTargets(stack, new ArrayList<UUID>());
        RagingEssence.setRageState(stack, (short)0);
        List<Holder> radianceEffects = BuiltInRegistries.f_256974_.m_203431_(BzTags.RAGING_RAGE_EFFECTS).stream().flatMap(HolderSet.ListBacked::m_203614_).filter(Holder::m_203633_).toList();
        for (Holder effectHolder : radianceEffects) {
            serverPlayer.m_21195_((MobEffect)effectHolder.m_203334_());
        }
        serverPlayer.m_284548_().m_8767_((ParticleOptions)ParticleTypes.f_123759_, serverPlayer.m_20182_().m_7096_(), serverPlayer.m_20182_().m_7098_() + 1.0, serverPlayer.m_20182_().m_7094_(), 50, serverPlayer.m_217043_().m_188583_() * 0.3, serverPlayer.m_217043_().m_188583_() * 0.25 + 0.1, serverPlayer.m_217043_().m_188583_() * 0.3, (double)0.06f);
    }

    public static void spawnParticles(ServerLevel world, Vec3 location, RandomSource random, int rageState) {
        if (rageState == BzGeneralConfigs.ragingEssenceStrengthLevels.length) {
            rageState *= 2;
        }
        world.m_8767_((ParticleOptions)ParticleTypes.f_123744_, location.m_7096_(), location.m_7098_() + 1.0, location.m_7094_(), rageState, random.m_188583_() * 0.2, random.m_188583_() * 0.25 + 0.1, random.m_188583_() * 0.2, (double)0.02f);
        world.m_8767_((ParticleOptions)ParticleTypes.f_123797_, location.m_7096_(), location.m_7098_() + 1.0, location.m_7094_(), rageState, random.m_188583_() * 0.2, random.m_188583_() * 0.25 + 0.1, random.m_188583_() * 0.2, (double)0.1f);
    }

    public static boolean IsRagingEssenceActive(Player player) {
        if (player != null) {
            ItemStack offHandItem = player.m_21206_();
            return offHandItem.m_150930_(BzItems.ESSENCE_RAGING.get()) && RagingEssence.getIsActive(offHandItem) && !player.m_36335_().m_41519_(offHandItem.m_41720_());
        }
        return false;
    }

    public static boolean IsValidEntityToGlow(Entity entity, Player player) {
        return RagingEssence.GetTeamColor(entity, player) != -1;
    }

    public static int GetTeamColor(Entity entity, Player player) {
        ItemStack stack = player.m_21206_();
        short rageState = RagingEssence.getRageState(stack);
        List<UUID> currentTargetsToKill = RagingEssence.getCurrentTargets(stack);
        if (rageState == BzGeneralConfigs.ragingEssenceStrengthLevels.length && RagingEssence.isTargetable(entity, player.m_20148_()) || currentTargetsToKill.contains(entity.m_20148_())) {
            if (rageState == BzGeneralConfigs.ragingEssenceStrengthLevels.length) {
                float percentage = Math.abs((float)(player.f_19797_ % 40 - 20) / 20.0f);
                int red = 255;
                int green = Mth.m_269140_((float)percentage, (int)0, (int)128);
                return (red & 0xFF) << 16 | (green & 0xFF) << 8;
            }
            float percentage = (float)rageState / (float)BzGeneralConfigs.ragingEssenceStrengthLevels.length;
            return Mth.m_269140_((float)percentage, (int)85, (int)255) << 16;
        }
        return -1;
    }
}

