/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.QueensTradeManager;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.WeightedTradeResult;
import com.telepathicgrunt.the_bumblezone.items.recipes.PotionCandleRecipe;
import com.telepathicgrunt.the_bumblezone.modcompat.FakePotionCandleRecipeCreator;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.MainTradeRowInput;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.RandomizeTradeRowInput;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.JEIQueenRandomizerTradesInfo;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.JEIQueenTradesInfo;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.QueenRandomizeTradesJEICategory;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.QueenTradesJEICategory;
import com.telepathicgrunt.the_bumblezone.modinit.BzCreativeTabs;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIIntegration
implements IModPlugin {
    public static final RecipeType<JEIQueenTradesInfo> QUEEN_TRADES = RecipeType.create((String)"the_bumblezone", (String)"queen_trades", JEIQueenTradesInfo.class);
    public static final RecipeType<JEIQueenRandomizerTradesInfo> QUEEN_RANDOMIZE_TRADES = RecipeType.create((String)"the_bumblezone", (String)"queen_color_randomizer_trades", JEIQueenRandomizerTradesInfo.class);

    private static void addInfo(IRecipeRegistration registration, Item item) {
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)item), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)("the_bumblezone." + BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135815_() + ".description"))});
    }

    private static void addInfo(IRecipeRegistration registration, Fluid fluid) {
        JEIIntegration.addFluidInfo(registration, fluid, registration.getJeiHelpers().getPlatformFluidHelper());
    }

    private static <T> void addFluidInfo(IRecipeRegistration registration, Fluid fluid, IPlatformFluidHelper<T> platformFluidHelper) {
        registration.addIngredientInfo(platformFluidHelper.create(fluid, 1L), (IIngredientType)platformFluidHelper.getFluidIngredientType(), new Component[]{Component.m_237115_((String)("the_bumblezone." + BuiltInRegistries.f_257020_.m_7981_((Object)fluid).m_135815_() + ".description"))});
    }

    private static void registerExtraRecipes(Recipe<?> baseRecipe, IRecipeRegistration registration, boolean oneRecipeOnly) {
        if (baseRecipe instanceof PotionCandleRecipe) {
            PotionCandleRecipe potionCandleRecipe = (PotionCandleRecipe)baseRecipe;
            List<CraftingRecipe> extraRecipes = FakePotionCandleRecipeCreator.constructFakeRecipes(potionCandleRecipe, oneRecipeOnly);
            registration.addRecipes(RecipeTypes.CRAFTING, extraRecipes);
        }
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("the_bumblezone", "jei_plugin");
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        ClientLevel level;
        BzCreativeTabs.CUSTOM_CREATIVE_TAB_ITEMS.forEach(item -> JEIIntegration.addInfo(registration, (Item)item.get()));
        JEIIntegration.addInfo(registration, (Fluid)BzFluids.SUGAR_WATER_FLUID.get());
        JEIIntegration.addInfo(registration, (Fluid)BzFluids.ROYAL_JELLY_FLUID.get());
        if (BzModCompatibilityConfigs.alternativeFluidToReplaceHoneyFluid.isEmpty()) {
            JEIIntegration.addInfo(registration, (Fluid)BzFluids.HONEY_FLUID.get());
        }
        if ((level = Minecraft.m_91087_().f_91073_) == null) {
            return;
        }
        level.m_7465_().m_44043_(new ResourceLocation("the_bumblezone", "potion_candle/from_super_candles")).ifPresent(recipe -> JEIIntegration.registerExtraRecipes(recipe, registration, true));
        level.m_7465_().m_44043_(new ResourceLocation("the_bumblezone", "potion_candle/from_string_and_carvable_wax")).ifPresent(recipe -> JEIIntegration.registerExtraRecipes(recipe, registration, false));
        LinkedList<JEIQueenTradesInfo> trades = new LinkedList<JEIQueenTradesInfo>();
        if (!QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades.isEmpty()) {
            for (Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>> trade : QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades) {
                for (WeightedTradeResult weightedTradeResult : ((WeightedRandomList)trade.getSecond()).m_146338_()) {
                    trades.add(new JEIQueenTradesInfo((MainTradeRowInput)trade.getFirst(), weightedTradeResult));
                }
            }
        }
        registration.addRecipes(QUEEN_TRADES, trades);
        LinkedList<JEIQueenRandomizerTradesInfo> randomizerTrades = new LinkedList<JEIQueenRandomizerTradesInfo>();
        if (!QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerRandomizerTrades.isEmpty()) {
            Object2ObjectOpenHashMap cacheJeiData = new Object2ObjectOpenHashMap();
            for (RandomizeTradeRowInput tradeEntry : QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerRandomizerTrades) {
                TagKey<Item> itemTagKey = tradeEntry.tagKey().get();
                TagData tagData = cacheJeiData.getOrDefault(itemTagKey, null);
                if (tagData == null) {
                    List<ItemStack> randomizeStack = tradeEntry.getWantItems().m_203614_().map(e -> ((Item)e.m_203334_()).m_7968_()).toList();
                    tagData = new TagData(randomizeStack.size(), randomizeStack, Ingredient.m_204132_(itemTagKey));
                    cacheJeiData.put(itemTagKey, tagData);
                }
                randomizerTrades.add(new JEIQueenRandomizerTradesInfo(itemTagKey, tagData.jeiIngredient(), tagData.listSize(), tagData.jeiItems()));
            }
        }
        registration.addRecipes(QUEEN_RANDOMIZE_TRADES, randomizerTrades);
        List<ItemStack> hangingGardensFlowers = GeneralUtils.convertBlockTagsToItemStacks(BzTags.HANGING_GARDEN_ALLOWED_FLOWERS_BLOCKS, BzTags.HANGING_GARDEN_FORCED_DISALLOWED_FLOWERS_BLOCKS);
        hangingGardensFlowers.addAll(GeneralUtils.convertBlockTagsToItemStacks(BzTags.HANGING_GARDEN_ALLOWED_TALL_FLOWERS_BLOCKS, BzTags.HANGING_GARDEN_FORCED_DISALLOWED_TALL_FLOWERS_BLOCKS));
        JEIIntegration.addComplexBlockTagInfo(registration, Pair.of((Object)".hanging_gardens_flowers.description", hangingGardensFlowers), Pair.of((Object)".crystalline_flower_can_be_placed_on.description", GeneralUtils.convertBlockTagsToItemStacks(BzTags.CRYSTALLINE_FLOWER_CAN_SURVIVE_ON, null)));
    }

    @SafeVarargs
    private static void addComplexBlockTagInfo(@NotNull IRecipeRegistration registration, Pair<String, List<ItemStack>> ... structureInfo) {
        for (Pair<String, List<ItemStack>> predicatePair : structureInfo) {
            registration.addIngredientInfo((List)predicatePair.getSecond(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)("the_bumblezone" + (String)predicatePair.getFirst()))});
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new QueenTradesJEICategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new QueenRandomizeTradesJEICategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(BzItems.BEE_QUEEN_SPAWN_EGG.get().m_7968_(), new RecipeType[]{QUEEN_TRADES});
        registration.addRecipeCatalyst(BzItems.BEE_QUEEN_SPAWN_EGG.get().m_7968_(), new RecipeType[]{QUEEN_RANDOMIZE_TRADES});
    }

    record TagData(int listSize, List<ItemStack> jeiItems, Ingredient jeiIngredient) {
    }
}

