/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.forge;

import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.events.entity.EntitySpawnEvent;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.LevelAccessor;

public class TropicraftCompat
implements ModCompat {
    protected static Optional<EntityType<?>> TROPIBEE;

    public TropicraftCompat() {
        TROPIBEE = BuiltInRegistries.f_256780_.m_6612_(new ResourceLocation("tropicraft", "tropibee"));
        ModChecker.tropicraftPresent = true;
    }

    @Override
    public EnumSet<ModCompat.Type> compatTypes() {
        return EnumSet.of(ModCompat.Type.SPAWNS);
    }

    @Override
    public boolean onBeeSpawn(EntitySpawnEvent event, boolean isChild) {
        if (!BzModCompatibilityConfigs.spawnTropicraftBeesMob || TROPIBEE.isEmpty()) {
            return false;
        }
        if ((double)event.entity().m_217043_().m_188501_() >= BzModCompatibilityConfigs.spawnrateOfTropicraftBeesMobs) {
            return false;
        }
        if (event.spawnType() == MobSpawnType.DISPENSER && !BzModCompatibilityConfigs.allowTropicraftSpawnFromDispenserFedBroodBlock) {
            return false;
        }
        Mob entity = event.entity();
        LevelAccessor world = event.level();
        Entity newEntity = TROPIBEE.get().m_20615_(entity.m_9236_());
        if (!(newEntity instanceof Mob)) {
            return false;
        }
        Mob tropibee = (Mob)newEntity;
        tropibee.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), tropibee.m_217043_().m_188501_() * 360.0f, 0.0f);
        tropibee.m_6863_(isChild);
        world.m_7967_((Entity)tropibee);
        return true;
    }
}

