/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.packets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.QueensTradeManager;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.WeightedTradeResult;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.DatapackSyncEvent;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.MainTradeRowInput;
import com.telepathicgrunt.the_bumblezone.packets.MessageHandler;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.Packet;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.PacketContext;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.PacketHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.player.Player;

public record QueenMainTradesSyncPacket(List<Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>>> recipeViewerMainTrades) implements Packet<QueenMainTradesSyncPacket>
{
    public static Gson gson = new GsonBuilder().create();
    public static final ResourceLocation ID = new ResourceLocation("the_bumblezone", "queen_main_trades_sync_packet");
    public static final Handler HANDLER = new Handler();

    public static void sendToClient(DatapackSyncEvent event) {
        MessageHandler.DEFAULT_CHANNEL.sendToPlayer(new QueenMainTradesSyncPacket(QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades), (Player)event.player());
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    @Override
    public PacketHandler<QueenMainTradesSyncPacket> getHandler() {
        return HANDLER;
    }

    public static class Handler
    implements PacketHandler<QueenMainTradesSyncPacket> {
        @Override
        public PacketContext handle(QueenMainTradesSyncPacket pkt) {
            return (player, level) -> {
                QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades = pkt.recipeViewerMainTrades();
            };
        }

        @Override
        public QueenMainTradesSyncPacket decode(FriendlyByteBuf buf) {
            ArrayList<Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>>> parsedData = new ArrayList<Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>>>();
            CompoundTag data = buf.m_130261_();
            if (data == null) {
                Bumblezone.LOGGER.error("Queen Main Trade packet is empty??? Wtf???");
                return new QueenMainTradesSyncPacket(parsedData);
            }
            ListTag tagList = data.m_128437_("main_trades", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag tradeCompound = tagList.m_128728_(i);
                CompoundTag firstHalf = tradeCompound.m_128469_("input");
                ListTag secondHalf = tradeCompound.m_128437_("output", 10);
                DataResult dataResult1 = MainTradeRowInput.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)firstHalf);
                dataResult1.error().ifPresent(e -> Bumblezone.LOGGER.error("Failed to parse Queen Main Trade packet entry (first half): {}", e));
                DataResult dataResult2 = WeightedRandomList.m_146333_(WeightedTradeResult.CODEC).parse((DynamicOps)NbtOps.f_128958_, (Object)secondHalf);
                dataResult2.error().ifPresent(e -> Bumblezone.LOGGER.error("Failed to parse Queen Main Trade packet entry (second half): {}", e));
                dataResult1.result().ifPresent(input -> dataResult2.result().ifPresent(output -> parsedData.add(Pair.of((Object)input, (Object)output))));
            }
            return new QueenMainTradesSyncPacket(parsedData);
        }

        @Override
        public void encode(QueenMainTradesSyncPacket pkt, FriendlyByteBuf buf) {
            CompoundTag data = new CompoundTag();
            ListTag listTag = new ListTag();
            for (Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>> tradeRow : pkt.recipeViewerMainTrades()) {
                CompoundTag pairData = new CompoundTag();
                DataResult dataResult1 = MainTradeRowInput.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)((MainTradeRowInput)tradeRow.getFirst()));
                dataResult1.error().ifPresent(e -> Bumblezone.LOGGER.error("Failed to encode Queen Main Trade packet entry (first half): {}", e));
                dataResult1.result().ifPresent(r -> pairData.m_128365_("input", r));
                DataResult dataResult = WeightedRandomList.m_146333_(WeightedTradeResult.CODEC).encodeStart((DynamicOps)NbtOps.f_128958_, (Object)((WeightedRandomList)tradeRow.getSecond()));
                dataResult.error().ifPresent(e -> Bumblezone.LOGGER.error("Failed to encode Queen Main Trade packet entry (second half): {}", e));
                dataResult.result().ifPresent(r -> pairData.m_128365_("output", r));
                listTag.add((Object)pairData);
            }
            data.m_128365_("main_trades", (Tag)listTag);
            buf.m_130079_(data);
        }
    }
}

