/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.utils;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.forge.EnchantmentUtilsImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import org.jetbrains.annotations.Contract;

public class EnchantmentUtils {
    public static long getPlayerXP(Player player) {
        return (long)((float)EnchantmentUtils.getExperienceForLevel(player.f_36078_) + player.f_36080_ * (float)player.m_36323_());
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    private static long sum(int n, int a0, int d) {
        return (long)n * (2L * (long)a0 + ((long)n - 1L) * (long)d) / 2L;
    }

    public static long getExperienceForLevel(int level) {
        if (level == 0) {
            return 0L;
        }
        if (level <= 15) {
            return EnchantmentUtils.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315L + EnchantmentUtils.sum(level - 15, 37, 5);
        }
        return 1395L + EnchantmentUtils.sum(level - 30, 112, 9);
    }

    public static Map<ResourceLocation, EnchantmentInstance> allAllowedEnchantsWithoutMaxLimit(int level, ItemStack stack, int xpTier) {
        HashMap<ResourceLocation, EnchantmentInstance> map = new HashMap<ResourceLocation, EnchantmentInstance>();
        boolean bookFlag = stack.m_150930_(Items.f_42517_) || stack.m_150930_(Items.f_42690_);
        boolean allowTreasure = xpTier == 7;
        Map<Enchantment, Integer> existingEnchantments = EnchantmentUtils.getEnchantmentsOnBook(stack);
        block0: for (Enchantment enchantment : BuiltInRegistries.f_256876_) {
            boolean forceAllowed = GeneralUtils.isInTag(BuiltInRegistries.f_256876_, BzTags.FORCED_ALLOWED_CRYSTALLINE_FLOWER_ENCHANTMENTS, enchantment);
            boolean disallowed = GeneralUtils.isInTag(BuiltInRegistries.f_256876_, BzTags.DISALLOWED_CRYSTALLINE_FLOWER_ENCHANTMENTS, enchantment);
            if (!forceAllowed && disallowed) continue;
            int minLevelAllowed = enchantment.m_44702_();
            if (existingEnchantments.containsKey(enchantment)) {
                minLevelAllowed = Math.max(minLevelAllowed, existingEnchantments.get(enchantment) + 1);
            }
            if (!forceAllowed && (enchantment.m_6591_() && !allowTreasure || !enchantment.m_6592_() || !EnchantmentUtils.canApplyAtEnchantingTable(enchantment, stack) && (!bookFlag || !EnchantmentUtils.isAllowedOnBooks(enchantment)))) continue;
            int maxLevelForEnchant = enchantment.m_6586_();
            for (ModCompat compat : ModChecker.ENCHANTMENT_MAX_LEVEL_COMPATS) {
                maxLevelForEnchant = compat.maxLevelForEnchantment(enchantment);
            }
            for (int i = maxLevelForEnchant; i > minLevelAllowed - 1; --i) {
                EnchantmentInstance enchantmentInstance;
                if (!forceAllowed && level < enchantment.m_6183_(i) || xpTier <= EnchantmentUtils.getEnchantmentTierCost(enchantmentInstance = new EnchantmentInstance(enchantment, xpTier <= 2 ? 1 : i))) continue;
                map.put(BuiltInRegistries.f_256876_.m_7981_((Object)enchantmentInstance.f_44947_), enchantmentInstance);
                continue block0;
            }
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @Contract(pure=true)
    @ExpectPlatform.Transformed
    public static boolean canApplyAtEnchantingTable(Enchantment enchantment, ItemStack stack) {
        void var1_1;
        return EnchantmentUtilsImpl.canApplyAtEnchantingTable(enchantment, (ItemStack)var1_1);
    }

    @ExpectPlatform
    @Contract(pure=true)
    @ExpectPlatform.Transformed
    public static boolean isAllowedOnBooks(Enchantment enchantment) {
        return EnchantmentUtilsImpl.isAllowedOnBooks(enchantment);
    }

    public static Map<Enchantment, Integer> getEnchantmentsOnBook(ItemStack itemStack) {
        ListTag listtag = EnchantedBookItem.m_41163_((ItemStack)itemStack);
        Object2IntOpenHashMap existingEnchants = new Object2IntOpenHashMap();
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            ResourceLocation resourcelocation1 = EnchantmentHelper.m_182446_((CompoundTag)compoundtag);
            if (resourcelocation1 == null) continue;
            existingEnchants.put(Objects.requireNonNull((Enchantment)BuiltInRegistries.f_256876_.m_7745_(resourcelocation1)), EnchantmentHelper.m_182438_((CompoundTag)compoundtag));
        }
        return existingEnchants;
    }

    public static int getEnchantmentTierCost(EnchantmentInstance enchantmentInstance) {
        return EnchantmentUtils.getEnchantmentTierCost(enchantmentInstance.f_44948_, enchantmentInstance.f_44947_.m_6183_(BuiltInRegistries.f_256876_.m_7981_((Object)enchantmentInstance.f_44947_).m_135827_().equals("minecraft") ? Math.max(enchantmentInstance.f_44948_, 2) : enchantmentInstance.f_44948_), enchantmentInstance.f_44947_.m_6591_(), enchantmentInstance.f_44947_.m_6589_());
    }

    public static int getEnchantmentTierCost(int level, int minCost, boolean isTreasureOnly, boolean isCurse) {
        int cost = 0;
        cost += minCost / 10;
        cost = (int)((float)cost + (float)level / 1.5f);
        if (isTreasureOnly) {
            cost += 2;
        }
        if (isCurse) {
            cost -= 3;
        }
        return Math.max(1, Math.min(6, cost += BzGeneralConfigs.crystallineFlowerExtraTierCost));
    }
}

