/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.utils;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class UnsafeBulkSectionAccess {
    private final LevelAccessor level;
    private final Long2ObjectMap<LevelChunkSection> acquiredSections = new Long2ObjectOpenHashMap();
    @Nullable
    private LevelChunkSection lastSection;
    private long lastSectionKey;

    public UnsafeBulkSectionAccess(LevelAccessor levelAccessor) {
        this.level = levelAccessor;
    }

    @Nullable
    public LevelChunkSection getSection(BlockPos blockPos) {
        int i = this.level.m_151564_(blockPos.m_123342_());
        if (i < 0 || i >= this.level.m_151559_()) {
            return null;
        }
        long posAsLong = SectionPos.m_175568_((BlockPos)blockPos);
        if (this.lastSection == null || this.lastSectionKey != posAsLong) {
            this.lastSection = (LevelChunkSection)this.acquiredSections.get(posAsLong);
            if (this.lastSection == null) {
                ChunkAccess chunkAccess = this.level.m_6325_(SectionPos.m_123171_((int)blockPos.m_123341_()), SectionPos.m_123171_((int)blockPos.m_123343_()));
                this.lastSection = chunkAccess.m_183278_(i);
                this.acquiredSections.put(posAsLong, (Object)this.lastSection);
            }
            this.lastSectionKey = posAsLong;
        }
        return this.lastSection;
    }

    public BlockState getBlockState(BlockPos blockPos) {
        LevelChunkSection levelChunkSection = this.getSection(blockPos);
        if (levelChunkSection == null) {
            return Blocks.f_50016_.m_49966_();
        }
        int i = SectionPos.m_123207_((int)blockPos.m_123341_());
        int j = SectionPos.m_123207_((int)blockPos.m_123342_());
        int k = SectionPos.m_123207_((int)blockPos.m_123343_());
        return levelChunkSection.m_62982_(i, j, k);
    }

    public FluidState getFluidState(BlockPos blockPos) {
        LevelChunkSection levelChunkSection = this.getSection(blockPos);
        if (levelChunkSection == null) {
            return Fluids.f_76191_.m_76145_();
        }
        int i = SectionPos.m_123207_((int)blockPos.m_123341_());
        int j = SectionPos.m_123207_((int)blockPos.m_123342_());
        int k = SectionPos.m_123207_((int)blockPos.m_123343_());
        return levelChunkSection.m_63007_(i, j, k);
    }

    public boolean setBlockState(BlockPos blockPos, BlockState state, boolean lockSection) {
        LevelChunkSection chunkSection = this.getSection(blockPos);
        if (chunkSection == null) {
            return false;
        }
        chunkSection.m_62991_(SectionPos.m_123207_((int)blockPos.m_123341_()), SectionPos.m_123207_((int)blockPos.m_123342_()), SectionPos.m_123207_((int)blockPos.m_123343_()), state, lockSection);
        return true;
    }

    public BlockState setBlockStateAndGetOldState(BlockPos blockPos, BlockState state, boolean lockSection) {
        LevelChunkSection chunkSection = this.getSection(blockPos);
        if (chunkSection == null) {
            return null;
        }
        int x = SectionPos.m_123207_((int)blockPos.m_123341_());
        int y = SectionPos.m_123207_((int)blockPos.m_123342_());
        int z = SectionPos.m_123207_((int)blockPos.m_123343_());
        BlockState oldState = chunkSection.m_62982_(x, y, z);
        chunkSection.m_62991_(x, y, z, state, lockSection);
        return oldState;
    }
}

