/*
 * Decompiled with CFR 0.152.
 */
package me.ajh123.be_quiet_negotiator.mixins;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import me.ajh123.be_quiet_negotiator.BeQuietNegotiator;
import me.ajh123.be_quiet_negotiator.ClientConfig;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.ClientCommonPacketListener;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.configuration.ClientConfigurationPacketListener;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.neoforge.network.configuration.CheckFeatureFlags;
import net.neoforged.neoforge.network.connection.ConnectionType;
import net.neoforged.neoforge.network.filters.NetworkFilters;
import net.neoforged.neoforge.network.payload.MinecraftRegisterPayload;
import net.neoforged.neoforge.network.payload.ModdedNetworkQueryComponent;
import net.neoforged.neoforge.network.registration.ChannelAttributes;
import net.neoforged.neoforge.network.registration.NetworkPayloadSetup;
import net.neoforged.neoforge.network.registration.NetworkRegistry;
import net.neoforged.neoforge.network.registration.PayloadRegistration;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NetworkRegistry.class})
public class NetworkRegistryMixin {
    @Inject(method={"initializeNeoForgeConnection(Lnet/minecraft/network/protocol/configuration/ServerConfigurationPacketListener;Ljava/util/Map;)V"}, at={@At(value="TAIL")}, remap=false)
    private static void initializeNeoForgeConnection(ServerConfigurationPacketListener listener, Map<ConnectionProtocol, Set<ModdedNetworkQueryComponent>> clientChannels, CallbackInfo ci) {
        BeQuietNegotiator.isConnectedToVanillaServer = false;
    }

    @Inject(method={"initializeOtherConnection(Lnet/minecraft/network/protocol/configuration/ClientConfigurationPacketListener;)V"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void initializeOtherConnection(ClientConfigurationPacketListener listener, CallbackInfo ci) {
        ChannelAttributes.setPayloadSetup((Connection)listener.getConnection(), (NetworkPayloadSetup)NetworkPayloadSetup.empty());
        ChannelAttributes.setConnectionType((Connection)listener.getConnection(), (ConnectionType)listener.getConnectionType());
        Map<ConnectionProtocol, Map<ResourceLocation, PayloadRegistration<?>>> PAYLOAD_REGISTRATIONS = NetworkRegistryMixin.getConnectionProtocolMap();
        if (ClientConfig.acceptVanillaServer()) {
            if (!CheckFeatureFlags.handleVanillaServerConnection((ClientConfigurationPacketListener)listener)) {
                return;
            }
            ConfigTracker.INSTANCE.loadDefaultServerConfigs();
            NetworkFilters.injectIfNecessary((Connection)listener.getConnection());
            ImmutableSet.Builder nowListeningOn = ImmutableSet.builder();
            nowListeningOn.addAll((Iterable)NetworkRegistry.getInitialListeningChannels((PacketFlow)listener.flow()));
            PAYLOAD_REGISTRATIONS.get(ConnectionProtocol.CONFIGURATION).entrySet().stream().filter(registration -> ((PayloadRegistration)registration.getValue()).matchesFlow(listener.flow())).filter(registration -> ((PayloadRegistration)registration.getValue()).optional()).forEach(registration -> nowListeningOn.add((Object)((ResourceLocation)registration.getKey())));
            listener.send((CustomPacketPayload)new MinecraftRegisterPayload((Set)nowListeningOn.build()));
            BeQuietNegotiator.isConnectedToVanillaServer = true;
            ci.cancel();
        }
    }

    private static Map<ConnectionProtocol, Map<ResourceLocation, PayloadRegistration<?>>> getConnectionProtocolMap() {
        Field payloadRegistrationsField = null;
        try {
            payloadRegistrationsField = NetworkRegistry.class.getDeclaredField("PAYLOAD_REGISTRATIONS");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        payloadRegistrationsField.setAccessible(true);
        Map PAYLOAD_REGISTRATIONS = null;
        try {
            PAYLOAD_REGISTRATIONS = (Map)payloadRegistrationsField.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return PAYLOAD_REGISTRATIONS;
    }

    @Inject(method={"checkPacket(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/protocol/common/ClientCommonPacketListener;)V"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void checkPacket(Packet<?> packet, ClientCommonPacketListener listener, CallbackInfo ci) {
        if (BeQuietNegotiator.isConnectedToVanillaServer) {
            ci.cancel();
        }
    }
}

