/*
 * Decompiled with CFR 0.152.
 */
package me.ajh123.be_quiet_negotiator.mixins;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import java.io.IOException;
import java.util.List;
import me.ajh123.be_quiet_negotiator.BeQuietNegotiator;
import me.ajh123.be_quiet_negotiator.ClientConfig;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ProtocolSwapHandler;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PacketDecoder.class})
public class PacketDecoderMixin {
    @Shadow
    @Final
    private static Logger LOGGER;
    @Shadow
    @Final
    private ProtocolInfo<? extends PacketListener> protocolInfo;

    @Inject(method={"decode(Lio/netty/channel/ChannelHandlerContext;Lio/netty/buffer/ByteBuf;Ljava/util/List;)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list, CallbackInfo ci) throws IOException {
        if (BeQuietNegotiator.isConnectedToVanillaServer && ClientConfig.ignorePacketDecodingErrors()) {
            try {
                int i = byteBuf.readableBytes();
                if (i != 0) {
                    Packet packet = (Packet)this.protocolInfo.codec().decode((Object)byteBuf);
                    PacketType packetType = packet.type();
                    JvmProfiler.INSTANCE.onPacketReceived(this.protocolInfo.id(), packetType, channelHandlerContext.channel().remoteAddress(), i);
                    if (byteBuf.readableBytes() > 0) {
                        throw new IOException("Packet " + this.protocolInfo.id().id() + "/" + String.valueOf(packetType) + " (" + packet.getClass().getSimpleName() + ") was larger than I expected, found " + byteBuf.readableBytes() + " bytes extra whilst reading packet " + String.valueOf(packetType));
                    }
                    list.add(packet);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(Connection.PACKET_RECEIVED_MARKER, " IN: [{}:{}] {} -> {} bytes", new Object[]{this.protocolInfo.id().id(), packetType, packet.getClass().getName(), i});
                    }
                    ProtocolSwapHandler.handleInboundTerminalPacket((ChannelHandlerContext)channelHandlerContext, (Packet)packet);
                }
            }
            catch (DecoderException e) {
                BeQuietNegotiator.LOGGER.error("Error decoding packet:", (Throwable)e);
                ci.cancel();
            }
        }
    }
}

