/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.blockentity;

import com.belgie.tricky_trials.common.blockentity.vaultbits.ModVaultClientData;
import com.belgie.tricky_trials.common.blockentity.vaultbits.ModVaultConfig;
import com.belgie.tricky_trials.common.blockentity.vaultbits.ModVaultServerData;
import com.belgie.tricky_trials.common.blockentity.vaultbits.ModVaultSharedData;
import com.belgie.tricky_trials.common.blockentity.vaultbits.ModVaultState;
import com.belgie.tricky_trials.common.blocks.ModVaultBlock;
import com.belgie.tricky_trials.core.TTBlockEntityRegistry;
import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class ModVaultBlockentity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ModVaultServerData serverData = new ModVaultServerData();
    private final ModVaultSharedData sharedData = new ModVaultSharedData();
    private final ModVaultClientData clientData = new ModVaultClientData();
    private ModVaultConfig config = ModVaultConfig.DEFAULT;

    public ModVaultBlockentity(BlockPos p_329814_, BlockState p_335937_) {
        super(TTBlockEntityRegistry.MOD_VAULT.get(), p_329814_, p_335937_);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider p_335952_) {
        return (CompoundTag)Util.make((Object)new CompoundTag(), p_331371_ -> p_331371_.put("shared_data", ModVaultBlockentity.encode(ModVaultSharedData.CODEC, this.sharedData, p_335952_)));
    }

    protected void saveAdditional(CompoundTag p_335237_, HolderLookup.Provider p_332605_) {
        super.saveAdditional(p_335237_, p_332605_);
        p_335237_.put("config", ModVaultBlockentity.encode(ModVaultConfig.CODEC, this.config, p_332605_));
        p_335237_.put("shared_data", ModVaultBlockentity.encode(ModVaultSharedData.CODEC, this.sharedData, p_332605_));
        p_335237_.put("server_data", ModVaultBlockentity.encode(ModVaultServerData.CODEC, this.serverData, p_332605_));
    }

    private static <T> Tag encode(Codec<T> p_328379_, T p_331958_, HolderLookup.Provider p_334758_) {
        return (Tag)p_328379_.encodeStart((DynamicOps)p_334758_.createSerializationContext((DynamicOps)NbtOps.INSTANCE), p_331958_).getOrThrow();
    }

    protected void loadAdditional(CompoundTag p_329069_, HolderLookup.Provider p_335999_) {
        super.loadAdditional(p_329069_, p_335999_);
        RegistryOps dynamicops = p_335999_.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        if (p_329069_.contains("server_data")) {
            ModVaultServerData.CODEC.parse((DynamicOps)dynamicops, (Object)p_329069_.get("server_data")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this.serverData::set);
        }
        if (p_329069_.contains("config")) {
            ModVaultConfig.CODEC.parse((DynamicOps)dynamicops, (Object)p_329069_.get("config")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_335308_ -> {
                this.config = p_335308_;
            });
        }
        if (p_329069_.contains("shared_data")) {
            ModVaultSharedData.CODEC.parse((DynamicOps)dynamicops, (Object)p_329069_.get("shared_data")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this.sharedData::set);
        }
    }

    @Nullable
    public ModVaultServerData getServerData() {
        return this.level != null && !this.level.isClientSide ? this.serverData : null;
    }

    public ModVaultSharedData getSharedData() {
        return this.sharedData;
    }

    public ModVaultClientData getClientData() {
        return this.clientData;
    }

    public ModVaultConfig getConfig() {
        return this.config;
    }

    @VisibleForTesting
    public void setConfig(ModVaultConfig p_332483_) {
        this.config = p_332483_;
    }

    public static final class Server {
        private static final int UNLOCKING_DELAY_TICKS = 14;
        private static final int DISPLAY_CYCLE_TICK_RATE = 20;
        private static final int INSERT_FAIL_SOUND_BUFFER_TICKS = 15;

        public static void tick(ServerLevel p_327862_, BlockPos p_334036_, BlockState p_336094_, ModVaultConfig p_332912_, ModVaultServerData p_332613_, ModVaultSharedData p_336360_) {
            ModVaultState $$6 = (ModVaultState)((Object)p_336094_.getValue(ModVaultBlock.STATE));
            if (Server.shouldCycleDisplayItem(p_327862_.getGameTime(), $$6)) {
                Server.cycleDisplayItemFromLootTable(p_327862_, $$6, p_332912_, p_336360_, p_334036_);
            }
            BlockState $$7 = p_336094_;
            if (p_327862_.getGameTime() >= p_332613_.stateUpdatingResumesAt() && !p_336094_.equals($$7 = (BlockState)$$7.setValue(ModVaultBlock.STATE, (Comparable)((Object)$$6.tickAndGetNext(p_327862_, p_334036_, p_332912_, p_332613_, p_336360_))))) {
                Server.setVaultState(p_327862_, p_334036_, p_336094_, $$7, p_332912_, p_336360_);
            }
            if (p_332613_.isDirty || p_336360_.isDirty) {
                ModVaultBlockentity.setChanged((Level)((Level)p_327862_), (BlockPos)p_334036_, (BlockState)p_336094_);
                if (p_336360_.isDirty) {
                    p_327862_.sendBlockUpdated(p_334036_, p_336094_, $$7, 2);
                }
                p_332613_.isDirty = false;
                p_336360_.isDirty = false;
            }
        }

        public static void tryInsertKey(ServerLevel p_330813_, BlockPos p_333223_, BlockState p_331301_, ModVaultConfig p_333877_, ModVaultServerData p_334388_, ModVaultSharedData p_330336_, Player p_332764_, ItemStack p_329896_) {
            ModVaultState $$8 = (ModVaultState)((Object)p_331301_.getValue(ModVaultBlock.STATE));
            if (Server.canEjectReward(p_333877_, $$8)) {
                if (!Server.isValidToInsert(p_333877_, p_329896_)) {
                    Server.playInsertFailSound(p_330813_, p_334388_, p_333223_);
                } else if (p_334388_.hasRewardedPlayer(p_332764_)) {
                    Server.playInsertFailSound(p_330813_, p_334388_, p_333223_);
                } else {
                    List<ItemStack> $$9 = Server.resolveItemsToEject(p_330813_, p_333877_, p_333223_, p_332764_);
                    if (!$$9.isEmpty()) {
                        p_332764_.awardStat(Stats.ITEM_USED.get((Object)p_329896_.getItem()));
                        if (!p_332764_.isCreative()) {
                            p_329896_.shrink(p_333877_.keyItem().getCount());
                        }
                        Server.unlock(p_330813_, p_331301_, p_333223_, p_333877_, p_334388_, p_330336_, $$9);
                        p_334388_.addToRewardedPlayers(p_332764_);
                        p_330336_.updateConnectedPlayersWithinRange(p_330813_, p_333223_, p_334388_, p_333877_, p_333877_.deactivationRange());
                    }
                }
            }
        }

        static void setVaultState(ServerLevel p_327709_, BlockPos p_330897_, BlockState p_333801_, BlockState p_336357_, ModVaultConfig p_332945_, ModVaultSharedData p_328872_) {
            ModVaultState $$6 = (ModVaultState)((Object)p_333801_.getValue(ModVaultBlock.STATE));
            ModVaultState $$7 = (ModVaultState)((Object)p_336357_.getValue(ModVaultBlock.STATE));
            p_327709_.setBlock(p_330897_, p_336357_, 3);
            $$6.onTransition(p_327709_, p_330897_, $$7, p_332945_, p_328872_, true);
        }

        public static void cycleDisplayItemFromLootTable(ServerLevel p_328186_, ModVaultState p_335064_, ModVaultConfig p_329242_, ModVaultSharedData p_336318_, BlockPos p_327920_) {
            if (!Server.canEjectReward(p_329242_, p_335064_)) {
                p_336318_.setDisplayItem(ItemStack.EMPTY);
            } else {
                ItemStack $$5 = Server.getRandomDisplayItemFromLootTable(p_328186_, p_327920_, p_329242_.overrideLootTableToDisplay().orElse(p_329242_.lootTable()));
                p_336318_.setDisplayItem($$5);
            }
        }

        private static ItemStack getRandomDisplayItemFromLootTable(ServerLevel p_329309_, BlockPos p_331772_, ResourceKey<LootTable> p_327947_) {
            LootParams $$4;
            LootTable $$3 = p_329309_.getServer().reloadableRegistries().getLootTable(p_327947_);
            ObjectArrayList $$5 = $$3.getRandomItems($$4 = new LootParams.Builder(p_329309_).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)p_331772_)).create(LootContextParamSets.VAULT));
            return $$5.isEmpty() ? ItemStack.EMPTY : (ItemStack)Util.getRandom((List)$$5, (RandomSource)p_329309_.getRandom());
        }

        private static void unlock(ServerLevel p_329025_, BlockState p_334542_, BlockPos p_331457_, ModVaultConfig p_328759_, ModVaultServerData p_329258_, ModVaultSharedData p_328090_, List<ItemStack> p_328105_) {
            p_329258_.setItemsToEject(p_328105_);
            p_328090_.setDisplayItem(p_329258_.getNextItemToEject());
            p_329258_.pauseStateUpdatingUntil(p_329025_.getGameTime() + 14L);
            Server.setVaultState(p_329025_, p_331457_, p_334542_, (BlockState)p_334542_.setValue(ModVaultBlock.STATE, (Comparable)((Object)ModVaultState.UNLOCKING)), p_328759_, p_328090_);
        }

        private static List<ItemStack> resolveItemsToEject(ServerLevel p_332295_, ModVaultConfig p_329503_, BlockPos p_333443_, Player p_334837_) {
            LootTable $$4 = p_332295_.getServer().reloadableRegistries().getLootTable(p_329503_.lootTable());
            LootParams $$5 = new LootParams.Builder(p_332295_).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)p_333443_)).withLuck(p_334837_.getLuck()).withParameter(LootContextParams.THIS_ENTITY, (Object)p_334837_).create(LootContextParamSets.VAULT);
            return $$4.getRandomItems($$5);
        }

        private static boolean canEjectReward(ModVaultConfig p_333220_, ModVaultState p_335172_) {
            return p_333220_.lootTable() != null && !p_333220_.keyItem().isEmpty() && p_335172_ != ModVaultState.INACTIVE;
        }

        private static boolean isValidToInsert(ModVaultConfig p_334332_, ItemStack p_335056_) {
            return ItemStack.isSameItemSameComponents((ItemStack)p_335056_, (ItemStack)p_334332_.keyItem()) && p_335056_.getCount() >= p_334332_.keyItem().getCount();
        }

        private static boolean shouldCycleDisplayItem(long p_334702_, ModVaultState p_332761_) {
            return p_334702_ % 20L == 0L && p_332761_ == ModVaultState.ACTIVE;
        }

        private static void playInsertFailSound(ServerLevel p_334677_, ModVaultServerData p_330421_, BlockPos p_330460_) {
            if (p_334677_.getGameTime() >= p_330421_.getLastInsertFailTimestamp() + 15L) {
                p_334677_.playSound((Player)null, p_330460_, SoundEvents.VAULT_INSERT_ITEM_FAIL, SoundSource.BLOCKS);
                p_330421_.setLastInsertFailTimestamp(p_334677_.getGameTime());
            }
        }
    }

    public static final class Client {
        private static final int PARTICLE_TICK_RATE = 20;
        private static final float IDLE_PARTICLE_CHANCE = 0.5f;
        private static final float AMBIENT_SOUND_CHANCE = 0.02f;
        private static final int ACTIVATION_PARTICLE_COUNT = 20;
        private static final int DEACTIVATION_PARTICLE_COUNT = 20;

        public static void tick(Level p_331255_, BlockPos p_335715_, BlockState p_330773_, ModVaultClientData p_335986_, ModVaultSharedData p_333339_) {
            p_335986_.updateDisplayItemSpin();
            if (p_331255_.getGameTime() % 20L == 0L) {
                Client.emitConnectionParticlesForNearbyPlayers(p_331255_, p_335715_, p_330773_, p_333339_);
            }
            Client.emitIdleParticles(p_331255_, p_335715_, p_333339_, (ParticleOptions)ParticleTypes.SMALL_FLAME);
            Client.playIdleSounds(p_331255_, p_335715_, p_333339_);
        }

        public static void emitActivationParticles(Level p_329048_, BlockPos p_334504_, BlockState p_328465_, ModVaultSharedData p_331322_, ParticleOptions p_332937_) {
            Client.emitConnectionParticlesForNearbyPlayers(p_329048_, p_334504_, p_328465_, p_331322_);
            RandomSource $$5 = p_329048_.random;
            for (int $$6 = 0; $$6 < 20; ++$$6) {
                Vec3 $$7 = Client.randomPosInsideCage(p_334504_, $$5);
                p_329048_.addParticle((ParticleOptions)ParticleTypes.SMOKE, $$7.x(), $$7.y(), $$7.z(), 0.0, 0.0, 0.0);
                p_329048_.addParticle(p_332937_, $$7.x(), $$7.y(), $$7.z(), 0.0, 0.0, 0.0);
            }
        }

        public static void emitDeactivationParticles(Level p_330549_, BlockPos p_334754_, ParticleOptions p_335199_) {
            RandomSource $$3 = p_330549_.random;
            for (int $$4 = 0; $$4 < 20; ++$$4) {
                Vec3 $$5 = Client.randomPosCenterOfCage(p_334754_, $$3);
                Vec3 $$6 = new Vec3($$3.nextGaussian() * 0.02, $$3.nextGaussian() * 0.02, $$3.nextGaussian() * 0.02);
                p_330549_.addParticle(p_335199_, $$5.x(), $$5.y(), $$5.z(), $$6.x(), $$6.y(), $$6.z());
            }
        }

        private static void emitIdleParticles(Level p_329901_, BlockPos p_330744_, ModVaultSharedData p_332348_, ParticleOptions p_333563_) {
            RandomSource $$4 = p_329901_.getRandom();
            if ($$4.nextFloat() <= 0.5f) {
                Vec3 $$5 = Client.randomPosInsideCage(p_330744_, $$4);
                p_329901_.addParticle((ParticleOptions)ParticleTypes.SMOKE, $$5.x(), $$5.y(), $$5.z(), 0.0, 0.0, 0.0);
                if (Client.shouldDisplayActiveEffects(p_332348_)) {
                    p_329901_.addParticle(p_333563_, $$5.x(), $$5.y(), $$5.z(), 0.0, 0.0, 0.0);
                }
            }
        }

        private static void emitConnectionParticlesForPlayer(Level p_327765_, Vec3 p_335116_, Player p_333131_) {
            RandomSource $$3 = p_327765_.random;
            Vec3 $$4 = p_335116_.vectorTo(p_333131_.position().add(0.0, (double)(p_333131_.getBbHeight() / 2.0f), 0.0));
            int $$5 = Mth.nextInt((RandomSource)$$3, (int)2, (int)5);
            for (int $$6 = 0; $$6 < $$5; ++$$6) {
                Vec3 $$7 = $$4.offsetRandom($$3, 1.0f);
                p_327765_.addParticle((ParticleOptions)ParticleTypes.VAULT_CONNECTION, p_335116_.x(), p_335116_.y(), p_335116_.z(), $$7.x(), $$7.y(), $$7.z());
            }
        }

        private static void emitConnectionParticlesForNearbyPlayers(Level p_329933_, BlockPos p_335364_, BlockState p_330110_, ModVaultSharedData p_332177_) {
            Set<UUID> $$4 = p_332177_.getConnectedPlayers();
            if (!$$4.isEmpty()) {
                Vec3 $$5 = Client.keyholePos(p_335364_, (Direction)p_330110_.getValue(ModVaultBlock.FACING));
                for (UUID $$6 : $$4) {
                    Player $$7 = p_329933_.getPlayerByUUID($$6);
                    if ($$7 == null || !Client.isWithinConnectionRange(p_335364_, p_332177_, $$7)) continue;
                    Client.emitConnectionParticlesForPlayer(p_329933_, $$5, $$7);
                }
            }
        }

        private static boolean isWithinConnectionRange(BlockPos p_334746_, ModVaultSharedData p_334927_, Player p_333038_) {
            return p_333038_.blockPosition().distSqr((Vec3i)p_334746_) <= Mth.square((double)p_334927_.connectedParticlesRange());
        }

        private static void playIdleSounds(Level p_329850_, BlockPos p_333501_, ModVaultSharedData p_332082_) {
            RandomSource $$3;
            if (Client.shouldDisplayActiveEffects(p_332082_) && ($$3 = p_329850_.getRandom()).nextFloat() <= 0.02f) {
                p_329850_.playLocalSound(p_333501_, SoundEvents.VAULT_AMBIENT, SoundSource.BLOCKS, $$3.nextFloat() * 0.25f + 0.75f, $$3.nextFloat() + 0.5f, false);
            }
        }

        public static boolean shouldDisplayActiveEffects(ModVaultSharedData p_329617_) {
            return p_329617_.hasDisplayItem();
        }

        private static Vec3 randomPosCenterOfCage(BlockPos p_329856_, RandomSource p_333945_) {
            return Vec3.atLowerCornerOf((Vec3i)p_329856_).add(Mth.nextDouble((RandomSource)p_333945_, (double)0.4, (double)0.6), Mth.nextDouble((RandomSource)p_333945_, (double)0.4, (double)0.6), Mth.nextDouble((RandomSource)p_333945_, (double)0.4, (double)0.6));
        }

        private static Vec3 randomPosInsideCage(BlockPos p_327884_, RandomSource p_332986_) {
            return Vec3.atLowerCornerOf((Vec3i)p_327884_).add(Mth.nextDouble((RandomSource)p_332986_, (double)0.1, (double)0.9), Mth.nextDouble((RandomSource)p_332986_, (double)0.25, (double)0.75), Mth.nextDouble((RandomSource)p_332986_, (double)0.1, (double)0.9));
        }

        private static Vec3 keyholePos(BlockPos p_331540_, Direction p_333034_) {
            return Vec3.atBottomCenterOf((Vec3i)p_331540_).add((double)p_333034_.getStepX() * 0.5, 1.75, (double)p_333034_.getStepZ() * 0.5);
        }
    }
}

