/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.blockentity;

import com.belgie.tricky_trials.common.blocks.RedstoneChestBlock;
import com.belgie.tricky_trials.core.TTBlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RedstoneChestBlockentity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level p_155062_, BlockPos p_155063_, BlockState p_155064_) {
            RedstoneChestBlockentity.this.playSound(p_155064_, SoundEvents.VAULT_REJECT_REWARDED_PLAYER, -0.9f);
            RedstoneChestBlockentity.this.updateBlockState(p_155064_, true);
        }

        protected void onClose(Level p_155072_, BlockPos p_155073_, BlockState p_155074_) {
            RedstoneChestBlockentity.this.playSound(p_155074_, SoundEvents.VAULT_REJECT_REWARDED_PLAYER, 0.9f);
            RedstoneChestBlockentity.this.updateBlockState(p_155074_, false);
        }

        protected void openerCountChanged(Level p_155066_, BlockPos p_155067_, BlockState p_155068_, int p_155069_, int p_155070_) {
        }

        protected boolean isOwnContainer(Player p_155060_) {
            if (p_155060_.containerMenu instanceof ChestMenu) {
                Container $$1 = ((ChestMenu)p_155060_.containerMenu).getContainer();
                return $$1 == RedstoneChestBlockentity.this;
            }
            return false;
        }
    };

    public RedstoneChestBlockentity(BlockPos p_155052_, BlockState p_155053_) {
        super(TTBlockEntityRegistry.SAFE.get(), p_155052_, p_155053_);
    }

    protected void saveAdditional(CompoundTag p_187459_, HolderLookup.Provider p_330809_) {
        super.saveAdditional(p_187459_, p_330809_);
        if (!this.trySaveLootTable(p_187459_)) {
            ContainerHelper.saveAllItems((CompoundTag)p_187459_, this.items, (HolderLookup.Provider)p_330809_);
        }
    }

    protected void loadAdditional(CompoundTag p_332191_, HolderLookup.Provider p_334663_) {
        super.loadAdditional(p_332191_, p_334663_);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(p_332191_)) {
            ContainerHelper.loadAllItems((CompoundTag)p_332191_, this.items, (HolderLookup.Provider)p_334663_);
        }
    }

    public boolean canTakeItem(Container p_273520_, int p_272681_, ItemStack p_273702_) {
        return (Boolean)this.level.getBlockState(this.getBlockPos()).getValue((Property)RedstoneChestBlock.ENABLED);
    }

    public ItemStack removeItem(int p_59613_, int p_59614_) {
        return super.removeItem(p_59613_, p_59614_);
    }

    public boolean canPlaceItem(int p_18952_, ItemStack p_18953_) {
        return (Boolean)this.level.getBlockState(this.getBlockPos()).getValue((Property)RedstoneChestBlock.ENABLED);
    }

    public int getContainerSize() {
        return 27;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> p_58610_) {
        this.items = p_58610_;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.safe");
    }

    protected AbstractContainerMenu createMenu(int p_58598_, Inventory p_58599_) {
        return ChestMenu.threeRows((int)p_58598_, (Inventory)p_58599_, (Container)this);
    }

    public void startOpen(Player p_58616_) {
        if (!this.remove && !p_58616_.isSpectator()) {
            this.openersCounter.incrementOpeners(p_58616_, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player p_58614_) {
        if (!this.remove && !p_58614_.isSpectator()) {
            this.openersCounter.decrementOpeners(p_58614_, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    void updateBlockState(BlockState p_58607_, boolean p_58608_) {
        this.level.setBlock(this.getBlockPos(), (BlockState)p_58607_.setValue((Property)RedstoneChestBlock.OPEN, (Comparable)Boolean.valueOf(p_58608_)), 3);
    }

    void playSound(BlockState p_58601_, SoundEvent p_58602_, float pitch) {
        Vec3i $$2 = ((Direction)p_58601_.getValue(RedstoneChestBlock.FACING)).getUnitVec3i();
        double $$3 = (double)this.worldPosition.getX() + 0.5 + (double)$$2.getX() / 2.0;
        double $$4 = (double)this.worldPosition.getY() + 0.5 + (double)$$2.getY() / 2.0;
        double $$5 = (double)this.worldPosition.getZ() + 0.5 + (double)$$2.getZ() / 2.0;
        this.level.playSound((Player)null, $$3, $$4, $$5, p_58602_, SoundSource.BLOCKS, 0.5f, pitch);
    }
}

