/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.blockentity.vaultbits;

import com.belgie.tricky_trials.core.TTItemRegistry;
import com.belgie.tricky_trials.core.TTLoottables;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.storage.loot.LootTable;

public record ModVaultConfig(ResourceKey<LootTable> lootTable, double activationRange, double deactivationRange, ItemStack keyItem, Optional<ResourceKey<LootTable>> overrideLootTableToDisplay, PlayerDetector playerDetector, PlayerDetector.EntitySelector entitySelector) {
    static final String TAG_NAME = "config";
    public static ModVaultConfig DEFAULT = new ModVaultConfig();
    public static ModVaultConfig END_DEFAULT = ModVaultConfig.ModEndVaultConfig();
    public static ModVaultConfig DEEP_DARK_DEFAULT = ModVaultConfig.ModDeepDarkVaultConfig();
    public static ModVaultConfig BASTION_DEFAULT = ModVaultConfig.ModBastionVaultConfig();
    public static ModVaultConfig TRICKY_DEFAULT = ModVaultConfig.ModTrickyVaultConfig();
    public static ModVaultConfig OMINOUS_TRICKY_DEFAULT = ModVaultConfig.ModOminousTrickyVaultConfig();
    public static ModVaultConfig ELDER_DEFAULT = ModVaultConfig.ModElderVaultConfig();
    public static Codec<ModVaultConfig> CODEC = RecordCodecBuilder.create(p_329931_ -> p_329931_.group((App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).lenientOptionalFieldOf("loot_table", DEFAULT.lootTable()).forGetter(ModVaultConfig::lootTable), (App)Codec.DOUBLE.lenientOptionalFieldOf("activation_range", (Object)DEFAULT.activationRange()).forGetter(ModVaultConfig::activationRange), (App)Codec.DOUBLE.lenientOptionalFieldOf("deactivation_range", (Object)DEFAULT.deactivationRange()).forGetter(ModVaultConfig::deactivationRange), (App)ItemStack.lenientOptionalFieldOf((String)"key_item").forGetter(ModVaultConfig::keyItem), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).lenientOptionalFieldOf("override_loot_table_to_display").forGetter(ModVaultConfig::overrideLootTableToDisplay)).apply((Applicative)p_329931_, ModVaultConfig::new)).validate(ModVaultConfig::validate);

    private ModVaultConfig() {
        this(TTLoottables.WOODLAND_VAULT, 4.0, 4.5, new ItemStack((ItemLike)TTItemRegistry.WOODLAND_KEY.get()), Optional.empty(), PlayerDetector.INCLUDING_CREATIVE_PLAYERS, PlayerDetector.EntitySelector.SELECT_FROM_LEVEL);
    }

    public ModVaultConfig(ResourceKey<LootTable> p_335368_, double p_335328_, double p_335598_, ItemStack p_328193_, Optional<ResourceKey<LootTable>> p_333693_) {
        this(p_335368_, p_335328_, p_335598_, p_328193_, p_333693_, DEFAULT.playerDetector(), DEFAULT.entitySelector());
    }

    private static ModVaultConfig ModElderVaultConfig() {
        return new ModVaultConfig(TTLoottables.ELDER_VAULT, 4.0, 4.5, new ItemStack((ItemLike)TTItemRegistry.ELDER_KEY.get()), Optional.empty(), PlayerDetector.INCLUDING_CREATIVE_PLAYERS, PlayerDetector.EntitySelector.SELECT_FROM_LEVEL);
    }

    private static ModVaultConfig ModEndVaultConfig() {
        return new ModVaultConfig(TTLoottables.END_VAULT, 4.0, 4.5, new ItemStack((ItemLike)TTItemRegistry.CITY_KEY.get()), Optional.empty(), PlayerDetector.INCLUDING_CREATIVE_PLAYERS, PlayerDetector.EntitySelector.SELECT_FROM_LEVEL);
    }

    private static ModVaultConfig ModDeepDarkVaultConfig() {
        return new ModVaultConfig(TTLoottables.DEEP_DARK_VAULT, 4.0, 4.5, new ItemStack((ItemLike)TTItemRegistry.ECHO_KEY.get()), Optional.empty(), PlayerDetector.INCLUDING_CREATIVE_PLAYERS, PlayerDetector.EntitySelector.SELECT_FROM_LEVEL);
    }

    private static ModVaultConfig ModBastionVaultConfig() {
        return new ModVaultConfig(TTLoottables.BASTION_VAULT, 4.0, 4.5, new ItemStack((ItemLike)TTItemRegistry.BASTION_KEY.get()), Optional.empty(), PlayerDetector.INCLUDING_CREATIVE_PLAYERS, PlayerDetector.EntitySelector.SELECT_FROM_LEVEL);
    }

    private static ModVaultConfig ModTrickyVaultConfig() {
        return new ModVaultConfig(TTLoottables.TRICKY_VAULT, 4.0, 4.5, new ItemStack((ItemLike)TTItemRegistry.TRICKY_KEY.get()), Optional.empty(), PlayerDetector.INCLUDING_CREATIVE_PLAYERS, PlayerDetector.EntitySelector.SELECT_FROM_LEVEL);
    }

    private static ModVaultConfig ModOminousTrickyVaultConfig() {
        return new ModVaultConfig(TTLoottables.OMINOUS_TRICKY_VAULT, 4.0, 4.5, new ItemStack((ItemLike)TTItemRegistry.OMINOUS_TRICKY_KEY.get()), Optional.empty(), PlayerDetector.INCLUDING_CREATIVE_PLAYERS, PlayerDetector.EntitySelector.SELECT_FROM_LEVEL);
    }

    private DataResult<ModVaultConfig> validate() {
        return this.activationRange > this.deactivationRange ? DataResult.error(() -> "Activation range must (" + this.activationRange + ") be less or equal to deactivation range (" + this.deactivationRange + ")") : DataResult.success((Object)this);
    }
}

