/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.blockentity.vaultbits;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ModVaultServerData {
    static final String TAG_NAME = "server_data";
    public static Codec<ModVaultServerData> CODEC = RecordCodecBuilder.create(p_331703_ -> p_331703_.group((App)UUIDUtil.CODEC_LINKED_SET.lenientOptionalFieldOf("rewarded_players", Set.of()).forGetter(p_331366_ -> p_331366_.rewardedPlayers), (App)Codec.LONG.lenientOptionalFieldOf("state_updating_resumes_at", (Object)0L).forGetter(p_329044_ -> p_329044_.stateUpdatingResumesAt), (App)ItemStack.CODEC.listOf().lenientOptionalFieldOf("items_to_eject", List.of()).forGetter(p_328322_ -> p_328322_.itemsToEject), (App)Codec.INT.lenientOptionalFieldOf("total_ejections_needed", (Object)0).forGetter(p_329419_ -> p_329419_.totalEjectionsNeeded)).apply((Applicative)p_331703_, ModVaultServerData::new));
    private static final int MAX_REWARD_PLAYERS = 128;
    public final Set<UUID> rewardedPlayers = new ObjectLinkedOpenHashSet();
    private long stateUpdatingResumesAt;
    private final List<ItemStack> itemsToEject = new ObjectArrayList();
    private long lastInsertFailTimestamp;
    private int totalEjectionsNeeded;
    public boolean isDirty;

    ModVaultServerData(Set<UUID> p_334629_, long p_331265_, List<ItemStack> p_330511_, int p_333688_) {
        this.rewardedPlayers.addAll(p_334629_);
        this.stateUpdatingResumesAt = p_331265_;
        this.itemsToEject.addAll(p_330511_);
        this.totalEjectionsNeeded = p_333688_;
    }

    public ModVaultServerData() {
    }

    public void setLastInsertFailTimestamp(long p_336284_) {
        this.lastInsertFailTimestamp = p_336284_;
    }

    public long getLastInsertFailTimestamp() {
        return this.lastInsertFailTimestamp;
    }

    Set<UUID> getRewardedPlayers() {
        return this.rewardedPlayers;
    }

    public boolean hasRewardedPlayer(Player p_336078_) {
        return this.rewardedPlayers.contains(p_336078_.getUUID());
    }

    @VisibleForTesting
    public void addToRewardedPlayers(Player p_332874_) {
        Iterator<UUID> iterator;
        this.rewardedPlayers.add(p_332874_.getUUID());
        if (this.rewardedPlayers.size() > 128 && (iterator = this.rewardedPlayers.iterator()).hasNext()) {
            iterator.next();
            iterator.remove();
        }
        this.markChanged();
    }

    public long stateUpdatingResumesAt() {
        return this.stateUpdatingResumesAt;
    }

    public void pauseStateUpdatingUntil(long p_330777_) {
        this.stateUpdatingResumesAt = p_330777_;
        this.markChanged();
    }

    List<ItemStack> getItemsToEject() {
        return this.itemsToEject;
    }

    void markEjectionFinished() {
        this.totalEjectionsNeeded = 0;
        this.markChanged();
    }

    public void setItemsToEject(List<ItemStack> p_332570_) {
        this.itemsToEject.clear();
        this.itemsToEject.addAll(p_332570_);
        this.totalEjectionsNeeded = this.itemsToEject.size();
        this.markChanged();
    }

    public ItemStack getNextItemToEject() {
        return this.itemsToEject.isEmpty() ? ItemStack.EMPTY : Objects.requireNonNullElse(this.itemsToEject.get(this.itemsToEject.size() - 1), ItemStack.EMPTY);
    }

    ItemStack popNextItemToEject() {
        if (this.itemsToEject.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.markChanged();
        return Objects.requireNonNullElse(this.itemsToEject.remove(this.itemsToEject.size() - 1), ItemStack.EMPTY);
    }

    public void set(ModVaultServerData p_329637_) {
        this.stateUpdatingResumesAt = 0L;
        this.itemsToEject.clear();
        this.itemsToEject.addAll(p_329637_.itemsToEject);
        this.rewardedPlayers.clear();
        this.rewardedPlayers.addAll(p_329637_.rewardedPlayers);
    }

    private void markChanged() {
        this.isDirty = true;
    }

    public float ejectionProgress() {
        return this.totalEjectionsNeeded == 1 ? 1.0f : 1.0f - Mth.inverseLerp((float)this.getItemsToEject().size(), (float)1.0f, (float)this.totalEjectionsNeeded);
    }
}

