/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.blockentity.vaultbits;

import com.belgie.tricky_trials.common.blockentity.ModVaultBlockentity;
import com.belgie.tricky_trials.common.blockentity.vaultbits.ModVaultConfig;
import com.belgie.tricky_trials.common.blockentity.vaultbits.ModVaultServerData;
import com.belgie.tricky_trials.common.blockentity.vaultbits.ModVaultSharedData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public enum ModVaultState implements StringRepresentable
{
    INACTIVE("inactive", LightLevel.HALF_LIT){

        @Override
        protected void onEnter(ServerLevel p_330824_, BlockPos p_329235_, ModVaultConfig p_334137_, ModVaultSharedData p_334678_, boolean p_331058_) {
            p_334678_.setDisplayItem(ItemStack.EMPTY);
            p_330824_.levelEvent(3016, p_329235_, p_331058_ ? 1 : 0);
        }
    }
    ,
    ACTIVE("active", LightLevel.LIT){

        @Override
        protected void onEnter(ServerLevel p_329909_, BlockPos p_333646_, ModVaultConfig p_333985_, ModVaultSharedData p_334965_, boolean p_328901_) {
            if (!p_334965_.hasDisplayItem()) {
                ModVaultBlockentity.Server.cycleDisplayItemFromLootTable(p_329909_, this, p_333985_, p_334965_, p_333646_);
            }
            p_329909_.playSound(null, p_333646_, SoundEvents.VAULT_ACTIVATE, SoundSource.BLOCKS);
            p_329909_.levelEvent(3015, p_333646_, p_328901_ ? 1 : 0);
        }
    }
    ,
    UNLOCKING("unlocking", LightLevel.LIT){

        @Override
        protected void onEnter(ServerLevel p_334760_, BlockPos p_334274_, ModVaultConfig p_331308_, ModVaultSharedData p_327978_, boolean p_332846_) {
            p_334760_.playSound(null, p_334274_, SoundEvents.VAULT_INSERT_ITEM, SoundSource.BLOCKS);
        }
    }
    ,
    EJECTING("ejecting", LightLevel.LIT){

        @Override
        protected void onEnter(ServerLevel p_331552_, BlockPos p_331920_, ModVaultConfig p_332952_, ModVaultSharedData p_328350_, boolean p_333805_) {
            p_331552_.playSound(null, p_331920_, SoundEvents.VAULT_OPEN_SHUTTER, SoundSource.BLOCKS);
        }

        @Override
        protected void onExit(ServerLevel p_329515_, BlockPos p_333072_, ModVaultConfig p_328058_, ModVaultSharedData p_332218_) {
            p_329515_.playSound(null, p_333072_, SoundEvents.VAULT_CLOSE_SHUTTER, SoundSource.BLOCKS);
        }
    };

    private static final int UPDATE_CONNECTED_PLAYERS_TICK_RATE = 20;
    private static final int DELAY_BETWEEN_EJECTIONS_TICKS = 20;
    private static final int DELAY_AFTER_LAST_EJECTION_TICKS = 20;
    private static final int DELAY_BEFORE_FIRST_EJECTION_TICKS = 20;
    private final String stateName;
    private final LightLevel lightLevel;

    private ModVaultState(String p_333421_, LightLevel p_333767_) {
        this.stateName = p_333421_;
        this.lightLevel = p_333767_;
    }

    public String getSerializedName() {
        return this.stateName;
    }

    public int lightLevel() {
        return this.lightLevel.value;
    }

    public ModVaultState tickAndGetNext(ServerLevel p_334990_, BlockPos p_330620_, ModVaultConfig p_334025_, ModVaultServerData p_332760_, ModVaultSharedData p_333510_) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ModVaultState.updateStateForConnectedPlayers(p_334990_, p_330620_, p_334025_, p_332760_, p_333510_, p_334025_.activationRange());
            case 1 -> ModVaultState.updateStateForConnectedPlayers(p_334990_, p_330620_, p_334025_, p_332760_, p_333510_, p_334025_.deactivationRange());
            case 2 -> {
                p_332760_.pauseStateUpdatingUntil(p_334990_.getGameTime() + 20L);
                yield EJECTING;
            }
            case 3 -> {
                if (p_332760_.getItemsToEject().isEmpty()) {
                    p_332760_.markEjectionFinished();
                    yield ModVaultState.updateStateForConnectedPlayers(p_334990_, p_330620_, p_334025_, p_332760_, p_333510_, p_334025_.deactivationRange());
                }
                float f = p_332760_.ejectionProgress();
                this.ejectResultItem(p_334990_, p_330620_, p_332760_.popNextItemToEject(), f);
                p_333510_.setDisplayItem(p_332760_.getNextItemToEject());
                boolean flag = p_332760_.getItemsToEject().isEmpty();
                int i = flag ? 20 : 20;
                p_332760_.pauseStateUpdatingUntil(p_334990_.getGameTime() + (long)i);
                yield EJECTING;
            }
        };
    }

    private static ModVaultState updateStateForConnectedPlayers(ServerLevel p_330419_, BlockPos p_334068_, ModVaultConfig p_335667_, ModVaultServerData p_330976_, ModVaultSharedData p_330718_, double p_334799_) {
        p_330718_.updateConnectedPlayersWithinRange(p_330419_, p_334068_, p_330976_, p_335667_, p_334799_);
        p_330976_.pauseStateUpdatingUntil(p_330419_.getGameTime() + 20L);
        return p_330718_.hasConnectedPlayers() ? ACTIVE : INACTIVE;
    }

    public void onTransition(ServerLevel p_332806_, BlockPos p_329339_, ModVaultState p_335389_, ModVaultConfig p_330996_, ModVaultSharedData p_333239_, boolean p_330399_) {
        this.onExit(p_332806_, p_329339_, p_330996_, p_333239_);
        p_335389_.onEnter(p_332806_, p_329339_, p_330996_, p_333239_, p_330399_);
    }

    protected void onEnter(ServerLevel p_335827_, BlockPos p_330931_, ModVaultConfig p_331678_, ModVaultSharedData p_333706_, boolean p_330849_) {
    }

    protected void onExit(ServerLevel p_331983_, BlockPos p_331510_, ModVaultConfig p_327841_, ModVaultSharedData p_334150_) {
    }

    private void ejectResultItem(ServerLevel p_329632_, BlockPos p_331411_, ItemStack p_329283_, float p_332145_) {
        DefaultDispenseItemBehavior.spawnItem((Level)p_329632_, (ItemStack)p_329283_, (int)2, (Direction)Direction.UP, (Position)Vec3.atBottomCenterOf((Vec3i)p_331411_).relative(Direction.UP, 1.2));
        p_329632_.levelEvent(3017, p_331411_, 0);
        p_329632_.playSound(null, p_331411_, SoundEvents.VAULT_EJECT_ITEM, SoundSource.BLOCKS, 1.0f, 0.8f + 0.4f * p_332145_);
    }

    static enum LightLevel {
        HALF_LIT(6),
        LIT(12);

        final int value;

        private LightLevel(int p_327951_) {
            this.value = p_327951_;
        }
    }
}

