/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.blockentity.vaultbits;

import com.belgie.tricky_trials.common.blocks.OminousShooter;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.extensions.IOwnedSpawner;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class OminousSpawner
implements IOwnedSpawner {
    public static final String SPAWN_DATA_TAG = "SpawnData";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int EVENT_SPAWN = 1;
    private int spawnDelay = 200;
    private SimpleWeightedRandomList<SpawnData> spawnPotentials = SimpleWeightedRandomList.empty();
    @javax.annotation.Nullable
    private SpawnData nextSpawnData;
    private double spin;
    private double oSpin;
    @javax.annotation.Nullable
    private Entity displayEntity;
    public int SpawnedEntities = 0;
    public int maxSpawnedEntities = 12;
    public int tickCount;

    public void setEntityId(EntityType<?> p_253682_, @javax.annotation.Nullable Level p_254041_, RandomSource p_254221_, BlockPos p_254050_) {
        this.getOrCreateNextSpawnData(p_254041_, p_254221_, p_254050_).getEntityToSpawn().putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(p_253682_).toString());
    }

    public void clientTick(Level p_151320_, BlockPos p_151321_) {
        ++this.tickCount;
    }

    public void serverTick(ServerLevel serverLevel, BlockPos pos) {
        SpawnData spawndata;
        CompoundTag compoundtag;
        Optional optional;
        ++this.tickCount;
        if (this.SpawnedEntities == 12) {
            serverLevel.setBlock(pos, (BlockState)serverLevel.getBlockState(pos).setValue((Property)OminousShooter.POWERED, (Comparable)Boolean.valueOf(false)), 3);
        }
        if (this.spawnDelay != 0) {
            --this.spawnDelay;
        }
        if ((optional = EntityType.by((CompoundTag)(compoundtag = (spawndata = this.getOrCreateNextSpawnData((Level)serverLevel, serverLevel.getRandom(), pos)).getEntityToSpawn()))).isPresent() && this.SpawnedEntities < this.maxSpawnedEntities) {
            RandomSource randomSource = serverLevel.getRandom();
            if (this.spawnDelay == 0 && serverLevel.getDifficulty() != Difficulty.PEACEFUL && SpawnPlacements.checkSpawnRules((EntityType)((EntityType)optional.get()), (ServerLevelAccessor)serverLevel, (EntitySpawnReason)EntitySpawnReason.SPAWNER, (BlockPos)pos, (RandomSource)randomSource)) {
                double x = (double)pos.getX() + (randomSource.nextDouble() - 0.5) * 4.0 * 2.0;
                double y = pos.getY();
                double z = (double)pos.getZ() + (randomSource.nextDouble() - 0.5) * 4.0 * 2.0;
                Entity entity = EntityType.loadEntityRecursive((CompoundTag)compoundtag, (Level)serverLevel, (EntitySpawnReason)EntitySpawnReason.SPAWNER, p_151310_ -> {
                    p_151310_.moveTo(x, y, z, p_151310_.getYRot(), p_151310_.getXRot());
                    return p_151310_;
                });
                assert (entity != null);
                ((Mob)entity).finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(pos), EntitySpawnReason.SPAWNER, (SpawnGroupData)null);
                serverLevel.addFreshEntity(entity);
                serverLevel.playSound((Player)null, pos, SoundEvents.TRIAL_SPAWNER_SPAWN_MOB, SoundSource.BLOCKS, 0.75f, 1.0f);
                this.AddSpawnedEntites(this.SpawnedEntities + 1);
                this.spawnDelay = 200;
            }
        }
    }

    public int SpawnedEntities() {
        return this.SpawnedEntities;
    }

    public void AddSpawnedEntites(int va) {
        this.SpawnedEntities = va;
    }

    public void loadAdditional(@javax.annotation.Nullable Level p_151329_, BlockPos p_151330_, CompoundTag p_151331_) {
        boolean flag1;
        this.spawnDelay = p_151331_.getShort("SpawnedEntities");
        boolean flag = p_151331_.contains(SPAWN_DATA_TAG, 10);
        if (flag) {
            SpawnData spawndata = SpawnData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)p_151331_.getCompound(SPAWN_DATA_TAG)).resultOrPartial(p_186391_ -> LOGGER.warn("Invalid SpawnData: {}", p_186391_)).orElseGet(SpawnData::new);
            this.setNextSpawnData(p_151329_, p_151330_, spawndata);
        }
        if (flag1 = p_151331_.contains("SpawnPotentials", 9)) {
            ListTag listtag = p_151331_.getList("SpawnPotentials", 10);
            this.spawnPotentials = SpawnData.LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)listtag).resultOrPartial(p_186388_ -> LOGGER.warn("Invalid SpawnPotentials list: {}", p_186388_)).orElseGet(SimpleWeightedRandomList::empty);
        } else {
            this.spawnPotentials = SimpleWeightedRandomList.single((Object)(this.nextSpawnData != null ? this.nextSpawnData : new SpawnData()));
        }
        this.displayEntity = null;
    }

    public void saveAdditional(CompoundTag p_186382_) {
        p_186382_.putShort("Delay", (short)this.spawnDelay);
        p_186382_.putShort("SpawnedEntities", (short)this.SpawnedEntities);
        if (this.nextSpawnData != null) {
            p_186382_.put(SPAWN_DATA_TAG, (Tag)SpawnData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.nextSpawnData).getOrThrow(p_327225_ -> new IllegalStateException("Invalid SpawnData: " + p_327225_)));
        }
        p_186382_.put("SpawnPotentials", (Tag)SpawnData.LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.spawnPotentials).getOrThrow());
    }

    public boolean onEventTriggered(Level p_151317_, int p_151318_) {
        if (p_151318_ == 1) {
            if (p_151317_.isClientSide) {
                this.spawnDelay = 200;
            }
            return true;
        }
        return false;
    }

    protected void setNextSpawnData(@javax.annotation.Nullable Level p_151325_, BlockPos p_151326_, SpawnData p_151327_) {
        this.nextSpawnData = p_151327_;
    }

    private SpawnData getOrCreateNextSpawnData(@javax.annotation.Nullable Level p_254503_, RandomSource p_253892_, BlockPos p_254487_) {
        if (this.nextSpawnData != null) {
            return this.nextSpawnData;
        }
        this.setNextSpawnData(p_254503_, p_254487_, this.spawnPotentials.getRandom(p_253892_).map(WeightedEntry.Wrapper::data).orElseGet(SpawnData::new));
        return this.nextSpawnData;
    }

    public abstract void broadcastEvent(Level var1, BlockPos var2, int var3);

    @Nullable
    public Either<BlockEntity, Entity> getOwner() {
        return null;
    }
}

