/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.blocks;

import com.belgie.tricky_trials.common.blockentity.LauncherBlockentity;
import com.belgie.tricky_trials.core.TTBlockEntityRegistry;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.windcharge.AbstractWindCharge;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class LauncherBlock
extends BaseEntityBlock {
    public static final MapCodec<LauncherBlock> CODEC = LauncherBlock.simpleCodec(LauncherBlock::new);
    public int COOLDOWN;

    public LauncherBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public void stepOn(Level p_152431_, BlockPos p_152432_, BlockState p_152433_, Entity p_152434_) {
        BlockEntity entity = p_152431_.getBlockEntity(p_152432_);
        if (entity instanceof LauncherBlockentity) {
            LauncherBlockentity be = (LauncherBlockentity)entity;
            if (be.COOLDOWN == 0) {
                int source = RandomSource.create().nextIntBetweenInclusive(1, 2);
                Vec3 vec = new Vec3(0.0, (double)source, 0.0);
                p_152434_.addDeltaMovement(vec);
                be.COOLDOWN = 250;
                this.explode(p_152434_, p_152431_, p_152432_.getCenter());
            }
        }
        super.stepOn(p_152431_, p_152432_, p_152433_, p_152434_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_154683_, BlockState p_154684_, BlockEntityType<T> p_154685_) {
        return LauncherBlock.createTickerHelper(p_154685_, TTBlockEntityRegistry.LAUNCHER.get(), LauncherBlockentity::clientTick);
    }

    public BlockEntity newBlockEntity(BlockPos p_154687_, BlockState p_154688_) {
        return new LauncherBlockentity(p_154687_, p_154688_);
    }

    protected RenderShape getRenderShape(BlockState p_54296_) {
        return RenderShape.MODEL;
    }

    protected void explode(Entity e, Level level, Vec3 p_342202_) {
        level.explode(e, (DamageSource)null, AbstractWindCharge.EXPLOSION_DAMAGE_CALCULATOR, p_342202_.x(), p_342202_.y() + 0.7, p_342202_.z(), 0.5f, false, Level.ExplosionInteraction.TRIGGER, (ParticleOptions)ParticleTypes.GUST_EMITTER_SMALL, (ParticleOptions)ParticleTypes.GUST_EMITTER_LARGE, (Holder)SoundEvents.BREEZE_WIND_CHARGE_BURST);
    }
}

