/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.blocks;

import com.belgie.tricky_trials.common.blockentity.ModVaultBlockentity;
import com.belgie.tricky_trials.common.blockentity.vaultbits.ModVaultConfig;
import com.belgie.tricky_trials.common.blockentity.vaultbits.ModVaultState;
import com.belgie.tricky_trials.common.blockentity.vaultbits.VaultTypes;
import com.belgie.tricky_trials.core.TTBlockEntityRegistry;
import com.belgie.tricky_trials.core.TTBlockRegistry;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class ModVaultBlock
extends BaseEntityBlock {
    public static final MapCodec<VaultBlock> CODEC = ModVaultBlock.simpleCodec(VaultBlock::new);
    public static final Property<ModVaultState> STATE = TTBlockRegistry.MOD_VAULT_STATE;
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final Property<VaultTypes> VAULT_TYPE = TTBlockRegistry.VAULT_TYPE;

    public ModVaultBlock(BlockBehaviour.Properties p_332394_) {
        super(p_332394_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue(STATE, (Comparable)((Object)ModVaultState.INACTIVE))).setValue(VAULT_TYPE, (Comparable)((Object)VaultTypes.WOODLAND)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public InteractionResult useItemOn(ItemStack p_324161_, BlockState p_323816_, Level p_324403_, BlockPos p_324623_, Player p_324219_, InteractionHand p_324416_, BlockHitResult p_324261_) {
        if (!p_324161_.isEmpty() && p_323816_.getValue(STATE) == ModVaultState.ACTIVE) {
            if (p_324403_ instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)p_324403_;
                BlockEntity var10 = serverlevel.getBlockEntity(p_324623_);
                if (!(var10 instanceof ModVaultBlockentity)) {
                    return InteractionResult.TRY_WITH_EMPTY_HAND;
                }
                ModVaultBlockentity vaultblockentity = (ModVaultBlockentity)var10;
                ModVaultBlockentity.Server.tryInsertKey(serverlevel, p_324623_, p_323816_, vaultblockentity.getConfig(), vaultblockentity.getServerData(), vaultblockentity.getSharedData(), p_324219_, p_324161_);
            }
            return InteractionResult.SUCCESS_SERVER;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_330778_, BlockState p_329139_) {
        return new ModVaultBlockentity(p_330778_, p_329139_);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_334106_) {
        p_334106_.add(new Property[]{FACING, STATE, VAULT_TYPE});
    }

    protected ItemStack getCloneItemStack(LevelReader p_376835_, BlockPos p_375399_, BlockState p_375675_, boolean p_376021_) {
        return ModVaultBlock.setLightOnStack(super.getCloneItemStack(p_376835_, p_375399_, p_375675_, p_376021_), (VaultTypes)((Object)p_375675_.getValue(VAULT_TYPE)));
    }

    public static ItemStack setLightOnStack(ItemStack p_259339_, VaultTypes p_259353_) {
        if (p_259353_ != null) {
            p_259339_.set(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY.with(VAULT_TYPE, (Comparable)((Object)p_259353_)));
        }
        return p_259339_;
    }

    protected void onPlace(BlockState p_60566_, Level p_60567_, BlockPos p_60568_, BlockState p_60569_, boolean p_60570_) {
        BlockEntity be = p_60567_.getBlockEntity(p_60568_);
        if (be instanceof ModVaultBlockentity) {
            ModVaultBlockentity modbe = (ModVaultBlockentity)be;
            if (p_60566_.getValue(VAULT_TYPE) == VaultTypes.END) {
                modbe.setConfig(ModVaultConfig.END_DEFAULT);
            }
            if (p_60566_.getValue(VAULT_TYPE) == VaultTypes.WOODLAND) {
                modbe.setConfig(ModVaultConfig.DEFAULT);
            }
            if (p_60566_.getValue(VAULT_TYPE) == VaultTypes.DEEP_DARK) {
                modbe.setConfig(ModVaultConfig.DEEP_DARK_DEFAULT);
            }
            if (p_60566_.getValue(VAULT_TYPE) == VaultTypes.BASTION) {
                modbe.setConfig(ModVaultConfig.BASTION_DEFAULT);
            }
            if (p_60566_.getValue(VAULT_TYPE) == VaultTypes.TRICKY_CHAMBER) {
                modbe.setConfig(ModVaultConfig.TRICKY_DEFAULT);
            }
            if (p_60566_.getValue(VAULT_TYPE) == VaultTypes.ELDER) {
                modbe.setConfig(ModVaultConfig.ELDER_DEFAULT);
            }
            if (p_60566_.getValue(VAULT_TYPE) == VaultTypes.OMINOUS_TRICKY_CHAMBER) {
                modbe.setConfig(ModVaultConfig.OMINOUS_TRICKY_DEFAULT);
            }
        }
        super.onPlace(p_60566_, p_60567_, p_60568_, p_60569_, p_60570_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_328167_, BlockState p_334496_, BlockEntityType<T> p_335892_) {
        BlockEntityTicker blockEntityTicker;
        if (p_328167_ instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)p_328167_;
            blockEntityTicker = ModVaultBlock.createTickerHelper(p_335892_, TTBlockEntityRegistry.MOD_VAULT.get(), (p_333393_, p_329496_, p_334876_, p_335304_) -> ModVaultBlockentity.Server.tick(serverlevel, p_329496_, p_334876_, p_335304_.getConfig(), p_335304_.getServerData(), p_335304_.getSharedData()));
        } else {
            blockEntityTicker = ModVaultBlock.createTickerHelper(p_335892_, TTBlockEntityRegistry.MOD_VAULT.get(), (p_329262_, p_332751_, p_331862_, p_336114_) -> ModVaultBlockentity.Client.tick(p_329262_, p_332751_, p_331862_, p_336114_.getClientData(), p_336114_.getSharedData()));
        }
        return blockEntityTicker;
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_328081_) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)p_328081_.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState p_333257_, Rotation p_329014_) {
        return (BlockState)p_333257_.setValue(FACING, (Comparable)p_329014_.rotate((Direction)p_333257_.getValue(FACING)));
    }

    public BlockState mirror(BlockState p_330957_, Mirror p_329929_) {
        return p_330957_.rotate(p_329929_.getRotation((Direction)p_330957_.getValue(FACING)));
    }

    public RenderShape getRenderShape(BlockState p_329085_) {
        return RenderShape.MODEL;
    }
}

