/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.blocks;

import com.belgie.tricky_trials.common.blockentity.PlayerDetectorBlockentity;
import com.belgie.tricky_trials.core.TTBlockEntityRegistry;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class PlayerDetectorBlock
extends BaseEntityBlock {
    public static final MapCodec<PlayerDetectorBlock> CODEC = PlayerDetectorBlock.simpleCodec(PlayerDetectorBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public MapCodec<PlayerDetectorBlock> codec() {
        return CODEC;
    }

    public PlayerDetectorBlock(BlockBehaviour.Properties p_54257_) {
        super(p_54257_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity newBlockEntity(BlockPos p_154687_, BlockState p_154688_) {
        return new PlayerDetectorBlockentity(p_154687_, p_154688_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_154683_, BlockState p_154684_, BlockEntityType<T> p_154685_) {
        return PlayerDetectorBlock.createTickerHelper(p_154685_, TTBlockEntityRegistry.PLAYER_DETECTOR.get(), PlayerDetectorBlockentity::clientTick);
    }

    protected boolean hasAnalogOutputSignal(BlockState p_54275_) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState p_54277_, Level p_54278_, BlockPos p_54279_) {
        return (Boolean)p_54277_.getValue((Property)POWERED) != false ? 15 : 0;
    }

    public void animateTick(BlockState p_220827_, Level p_220828_, BlockPos p_220829_, RandomSource p_220830_) {
        if (((Boolean)p_220827_.getValue((Property)POWERED)).booleanValue() && p_220830_.nextInt(5) == 0) {
            PlayerDetectorBlock.addDetectPlayerParticles(p_220828_, p_220829_, p_220830_, 1, (ParticleOptions)ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER_OMINOUS);
        }
        super.animateTick(p_220827_, p_220828_, p_220829_, p_220830_);
    }

    public static void addDetectPlayerParticles(Level p_309415_, BlockPos p_309941_, RandomSource p_310263_, int p_310988_, ParticleOptions p_331085_) {
        for (int $$5 = 0; $$5 < 30 + Math.min(p_310988_, 10) * 5; ++$$5) {
            double $$6 = (double)(2.0f * p_310263_.nextFloat() - 1.0f) * 0.65;
            double $$7 = (double)(2.0f * p_310263_.nextFloat() - 1.0f) * 0.65;
            double $$8 = (double)p_309941_.getX() + 0.5 + $$6;
            double $$9 = (double)p_309941_.getY() + 0.1 + (double)p_310263_.nextFloat() * 0.8;
            double $$10 = (double)p_309941_.getZ() + 0.5 + $$7;
            p_309415_.addParticle(p_331085_, $$8, $$9, $$10, 0.0, 0.0, 0.0);
        }
    }

    protected RenderShape getRenderShape(BlockState p_54296_) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_54294_) {
        p_54294_.add(new Property[]{POWERED});
    }
}

