/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.blocks;

import com.belgie.tricky_trials.common.blockentity.RedstoneChestBlockentity;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;

public class RedstoneChestBlock
extends BaseEntityBlock {
    public static final MapCodec<RedstoneChestBlock> CODEC = RedstoneChestBlock.simpleCodec(RedstoneChestBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final BooleanProperty ENABLED = BlockStateProperties.ENABLED;

    public MapCodec<RedstoneChestBlock> codec() {
        return CODEC;
    }

    public RedstoneChestBlock(BlockBehaviour.Properties p_49046_) {
        super(p_49046_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    protected InteractionResult useWithoutItem(BlockState p_49069_, Level p_49070_, BlockPos p_49071_, Player p_49072_, BlockHitResult p_49074_) {
        if (p_49070_.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity $$5 = p_49070_.getBlockEntity(p_49071_);
        if (((Boolean)p_49069_.getValue((Property)ENABLED)).booleanValue()) {
            if ($$5 instanceof RedstoneChestBlockentity) {
                p_49072_.openMenu((MenuProvider)((RedstoneChestBlockentity)$$5));
                p_49072_.awardStat(Stats.OPEN_BARREL);
                if (p_49070_ instanceof ServerLevel) {
                    ServerLevel sl = (ServerLevel)p_49070_;
                    PiglinAi.angerNearbyPiglins((ServerLevel)sl, (Player)p_49072_, (boolean)true);
                }
            }
        } else {
            p_49070_.playSound((Player)null, p_49071_, SoundEvents.VAULT_INSERT_ITEM_FAIL, SoundSource.BLOCKS, 1.0f, 0.9f);
        }
        return InteractionResult.CONSUME;
    }

    protected void onRemove(BlockState p_49076_, Level p_49077_, BlockPos p_49078_, BlockState p_49079_, boolean p_49080_) {
        Containers.dropContentsOnDestroy((BlockState)p_49076_, (BlockState)p_49079_, (Level)p_49077_, (BlockPos)p_49078_);
        super.onRemove(p_49076_, p_49077_, p_49078_, p_49079_, p_49080_);
    }

    protected void tick(BlockState p_220758_, ServerLevel p_220759_, BlockPos p_220760_, RandomSource p_220761_) {
        BlockEntity $$4 = p_220759_.getBlockEntity(p_220760_);
        if ($$4 instanceof RedstoneChestBlockentity) {
            ((RedstoneChestBlockentity)$$4).recheckOpen();
        }
    }

    protected void onPlace(BlockState p_54110_, Level p_54111_, BlockPos p_54112_, BlockState p_54113_, boolean p_54114_) {
        if (!p_54113_.is(p_54110_.getBlock())) {
            this.checkPoweredState(p_54111_, p_54112_, p_54110_);
        }
    }

    protected void neighborChanged(BlockState p_55666_, Level p_55667_, BlockPos p_55668_, Block p_55669_, @Nullable Orientation p_364297_, boolean p_55671_) {
        this.checkPoweredState(p_55667_, p_55668_, p_55666_);
    }

    private void checkPoweredState(Level p_275499_, BlockPos p_275298_, BlockState p_275611_) {
        boolean $$3;
        boolean bl = $$3 = !p_275499_.hasNeighborSignal(p_275298_);
        if ($$3 != (Boolean)p_275611_.getValue((Property)ENABLED)) {
            p_275499_.setBlock(p_275298_, (BlockState)p_275611_.setValue((Property)ENABLED, (Comparable)Boolean.valueOf($$3)), 2);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_152102_, BlockState p_152103_) {
        return new RedstoneChestBlockentity(p_152102_, p_152103_);
    }

    protected RenderShape getRenderShape(BlockState p_49090_) {
        return RenderShape.MODEL;
    }

    protected boolean hasAnalogOutputSignal(BlockState p_49058_) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState p_49065_, Level p_49066_, BlockPos p_49067_) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)p_49066_.getBlockEntity(p_49067_));
    }

    protected BlockState rotate(BlockState p_49085_, Rotation p_49086_) {
        return (BlockState)p_49085_.setValue(FACING, (Comparable)p_49086_.rotate((Direction)p_49085_.getValue(FACING)));
    }

    protected BlockState mirror(BlockState p_49082_, Mirror p_49083_) {
        return p_49082_.rotate(p_49083_.getRotation((Direction)p_49082_.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_49088_) {
        p_49088_.add(new Property[]{FACING, OPEN, ENABLED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_49048_) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)p_49048_.getHorizontalDirection().getOpposite());
    }
}

