/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.blocks;

import com.belgie.tricky_trials.common.entity.StealthEntity;
import com.belgie.tricky_trials.core.TTBlockRegistry;
import com.belgie.tricky_trials.core.TTEntityRegistry;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class RedstoneInfestedBlock
extends Block {
    public static final MapCodec<RedstoneInfestedBlock> CODEC = RecordCodecBuilder.mapCodec(p_341832_ -> p_341832_.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("host").forGetter(RedstoneInfestedBlock::getHostBlock), (App)RedstoneInfestedBlock.propertiesCodec()).apply((Applicative)p_341832_, RedstoneInfestedBlock::new));
    private final Block hostBlock;
    private static final Map<Block, Block> BLOCK_BY_HOST_BLOCK = Maps.newIdentityHashMap();
    private static final Map<BlockState, BlockState> HOST_TO_INFESTED_STATES = Maps.newIdentityHashMap();
    private static final Map<BlockState, BlockState> INFESTED_TO_HOST_STATES = Maps.newIdentityHashMap();
    public static final BooleanProperty LIT = RedstoneTorchBlock.LIT;

    public MapCodec<? extends RedstoneInfestedBlock> codec() {
        return CODEC;
    }

    public RedstoneInfestedBlock(Block p_54178_, BlockBehaviour.Properties p_54179_) {
        super(p_54179_.destroyTime(p_54178_.defaultDestroyTime() / 2.0f).explosionResistance(0.75f));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
        this.hostBlock = p_54178_;
        BLOCK_BY_HOST_BLOCK.put(p_54178_, this);
    }

    protected void attack(BlockState p_55467_, Level p_55468_, BlockPos p_55469_, Player p_55470_) {
        RedstoneInfestedBlock.interact(p_55467_, p_55468_, p_55469_);
        super.attack(p_55467_, p_55468_, p_55469_, p_55470_);
    }

    public void stepOn(Level p_154299_, BlockPos p_154300_, BlockState p_154301_, Entity p_154302_) {
        if (!p_154302_.isSteppingCarefully()) {
            RedstoneInfestedBlock.interact(p_154301_, p_154299_, p_154300_);
        }
        super.stepOn(p_154299_, p_154300_, p_154301_, p_154302_);
    }

    public Block getHostBlock() {
        return this.hostBlock;
    }

    public static boolean isCompatibleHostBlock(BlockState p_54196_) {
        return BLOCK_BY_HOST_BLOCK.containsKey(p_54196_.getBlock());
    }

    private void spawnInfestation(BlockState p_221360_, ServerLevel p_54181_, BlockPos p_54182_) {
        StealthEntity $$2 = (StealthEntity)TTEntityRegistry.STEALTH.get().create((Level)p_54181_, EntitySpawnReason.REINFORCEMENT);
        if ($$2 != null) {
            $$2.moveTo((double)p_54182_.getX() + 0.5, p_54182_.getY(), (double)p_54182_.getZ() + 0.5, 0.0f, 0.0f);
            p_54181_.addFreshEntity((Entity)$$2);
            if (p_221360_.is(TTBlockRegistry.INFESTED_REDSTONE_ORE.get())) {
                $$2.setHasRedstone(true);
            } else if (p_221360_.is(TTBlockRegistry.INFESTED_DEEPSLATE_REDSTONE_ORE.get())) {
                $$2.setHasDeepslateRedstone(true);
            }
            $$2.setRedstoneCount(1);
            $$2.spawnAnim();
        }
    }

    protected void spawnAfterBreak(BlockState p_221360_, ServerLevel p_221361_, BlockPos p_221362_, ItemStack p_221363_, boolean p_221364_) {
        super.spawnAfterBreak(p_221360_, p_221361_, p_221362_, p_221363_, p_221364_);
        if (p_221361_.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && !EnchantmentHelper.hasTag((ItemStack)p_221363_, (TagKey)EnchantmentTags.PREVENTS_INFESTED_SPAWNS)) {
            this.spawnInfestation(p_221360_, p_221361_, p_221362_);
        }
    }

    public static BlockState infestedStateByHost(BlockState p_153431_) {
        return RedstoneInfestedBlock.getNewStateWithProperties(HOST_TO_INFESTED_STATES, p_153431_, () -> BLOCK_BY_HOST_BLOCK.get(p_153431_.getBlock()).defaultBlockState());
    }

    public BlockState hostStateByInfested(BlockState p_153433_) {
        return RedstoneInfestedBlock.getNewStateWithProperties(INFESTED_TO_HOST_STATES, p_153433_, () -> this.getHostBlock().defaultBlockState());
    }

    private static BlockState getNewStateWithProperties(Map<BlockState, BlockState> p_153424_, BlockState p_153425_, Supplier<BlockState> p_153426_) {
        return p_153424_.computeIfAbsent(p_153425_, p_153429_ -> {
            BlockState $$2 = (BlockState)p_153426_.get();
            for (Property $$3 : p_153429_.getProperties()) {
                $$2 = $$2.hasProperty($$3) ? (BlockState)$$2.setValue($$3, p_153429_.getValue($$3)) : $$2;
            }
            return $$2;
        });
    }

    protected InteractionResult useItemOn(ItemStack p_331692_, BlockState p_328847_, Level p_334994_, BlockPos p_336118_, Player p_329891_, InteractionHand p_331867_, BlockHitResult p_329149_) {
        if (p_334994_.isClientSide) {
            RedstoneInfestedBlock.spawnParticles(p_334994_, p_336118_);
        } else {
            RedstoneInfestedBlock.interact(p_328847_, p_334994_, p_336118_);
        }
        return p_331692_.getItem() instanceof BlockItem && new BlockPlaceContext(p_329891_, p_331867_, p_331692_, p_329149_).canPlace() ? InteractionResult.PASS : InteractionResult.SUCCESS;
    }

    private static void interact(BlockState p_55493_, Level p_55494_, BlockPos p_55495_) {
        RedstoneInfestedBlock.spawnParticles(p_55494_, p_55495_);
        if (!((Boolean)p_55493_.getValue((Property)LIT)).booleanValue()) {
            p_55494_.setBlock(p_55495_, (BlockState)p_55493_.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    protected boolean isRandomlyTicking(BlockState p_55486_) {
        return (Boolean)p_55486_.getValue((Property)LIT);
    }

    protected void randomTick(BlockState p_221918_, ServerLevel p_221919_, BlockPos p_221920_, RandomSource p_221921_) {
        if (((Boolean)p_221918_.getValue((Property)LIT)).booleanValue()) {
            p_221919_.setBlock(p_221920_, (BlockState)p_221918_.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public void animateTick(BlockState p_221913_, Level p_221914_, BlockPos p_221915_, RandomSource p_221916_) {
        if (((Boolean)p_221913_.getValue((Property)LIT)).booleanValue()) {
            RedstoneInfestedBlock.spawnParticles(p_221914_, p_221915_);
        }
    }

    private static void spawnParticles(Level p_55455_, BlockPos p_55456_) {
        double d0 = 0.5625;
        RandomSource randomsource = p_55455_.random;
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = p_55456_.relative(direction);
            if (p_55455_.getBlockState(blockpos).isSolidRender()) continue;
            Direction.Axis direction$axis = direction.getAxis();
            double d1 = direction$axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.getStepX() : (double)randomsource.nextFloat();
            double d2 = direction$axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.getStepY() : (double)randomsource.nextFloat();
            double d3 = direction$axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.getStepZ() : (double)randomsource.nextFloat();
            p_55455_.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, (double)p_55456_.getX() + d1, (double)p_55456_.getY() + d2, (double)p_55456_.getZ() + d3, 0.0, 0.0, 0.0);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_55484_) {
        p_55484_.add(new Property[]{LIT});
    }

    public int getExpDrop(BlockState state, LevelReader world, RandomSource randomSource, BlockPos pos, int fortune, int silktouch) {
        return silktouch == 0 ? 1 + randomSource.nextInt(5) : 0;
    }
}

