/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.blocks;

import com.belgie.tricky_trials.common.blockentity.TreasureDoorBlockentity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TTDoorBlock
extends BaseEntityBlock {
    public static final MapCodec<TTDoorBlock> CODEC = RecordCodecBuilder.mapCodec(p_310521_ -> p_310521_.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(TTDoorBlock::type), (App)TTDoorBlock.propertiesCodec()).apply((Applicative)p_310521_, TTDoorBlock::new));
    public static final EnumProperty<Direction> FACING;
    public static final BooleanProperty OPEN;
    public static final EnumProperty<DoorHingeSide> HINGE;
    public static final BooleanProperty POWERED;
    public static final EnumProperty<DoubleBlockHalf> HALF;
    protected static final float AABB_DOOR_THICKNESS = 3.0f;
    protected static final VoxelShape SOUTH_AABB;
    protected static final VoxelShape NORTH_AABB;
    protected static final VoxelShape WEST_AABB;
    protected static final VoxelShape EAST_AABB;
    private final BlockSetType type;
    public static final BooleanProperty NATURAL;

    public MapCodec<? extends TTDoorBlock> codec() {
        return CODEC;
    }

    public TTDoorBlock(BlockSetType p_272854_, BlockBehaviour.Properties p_273303_) {
        super(p_273303_.sound(p_272854_.soundType()));
        this.type = p_272854_;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue(HINGE, (Comparable)DoorHingeSide.LEFT)).setValue((Property)NATURAL, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public BlockSetType type() {
        return this.type;
    }

    protected VoxelShape getShape(BlockState p_52807_, BlockGetter p_52808_, BlockPos p_52809_, CollisionContext p_52810_) {
        Direction $$4 = (Direction)p_52807_.getValue(FACING);
        boolean $$5 = (Boolean)p_52807_.getValue((Property)OPEN) == false;
        boolean $$6 = p_52807_.getValue(HINGE) == DoorHingeSide.RIGHT;
        return switch ($$4) {
            case Direction.SOUTH -> $$5 ? SOUTH_AABB : ($$6 ? EAST_AABB : WEST_AABB);
            case Direction.WEST -> $$5 ? WEST_AABB : ($$6 ? SOUTH_AABB : NORTH_AABB);
            case Direction.NORTH -> $$5 ? NORTH_AABB : ($$6 ? WEST_AABB : EAST_AABB);
            default -> $$5 ? EAST_AABB : ($$6 ? NORTH_AABB : SOUTH_AABB);
        };
    }

    protected BlockState updateShape(BlockState p_52796_, LevelReader p_374501_, ScheduledTickAccess p_374380_, BlockPos p_52800_, Direction p_52797_, BlockPos p_52801_, BlockState p_52798_, RandomSource p_374395_) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)p_52796_.getValue(HALF);
        if (p_52797_.getAxis() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (p_52797_ == Direction.UP)) {
            return p_52798_.getBlock() instanceof TTDoorBlock && p_52798_.getValue(HALF) != doubleblockhalf ? (BlockState)p_52798_.setValue(HALF, (Comparable)doubleblockhalf) : Blocks.AIR.defaultBlockState();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && p_52797_ == Direction.DOWN && !p_52796_.canSurvive(p_374501_, p_52800_) ? Blocks.AIR.defaultBlockState() : super.updateShape(p_52796_, p_374501_, p_374380_, p_52800_, p_52797_, p_52801_, p_52798_, p_374395_);
    }

    public BlockState playerWillDestroy(Level p_52755_, BlockPos p_52756_, BlockState p_52757_, Player p_52758_) {
        if (!(p_52755_.isClientSide || !p_52758_.isCreative() && p_52758_.hasCorrectToolForDrops(p_52757_, p_52755_, p_52756_))) {
            TTDoorBlock.preventDropFromBottomPart(p_52755_, p_52756_, p_52757_, p_52758_);
        }
        return super.playerWillDestroy(p_52755_, p_52756_, p_52757_, p_52758_);
    }

    protected static void preventDropFromBottomPart(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.getValue(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = level.getBlockState(blockpos = pos.below())).is(state.getBlock()) && blockstate.getValue(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockstate1 = blockstate.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
            level.setBlock(blockpos, blockstate1, 35);
            level.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
        }
    }

    protected boolean isPathfindable(BlockState p_52764_, PathComputationType p_52767_) {
        return switch (p_52767_) {
            case PathComputationType.LAND, PathComputationType.AIR -> (Boolean)p_52764_.getValue((Property)OPEN);
            case PathComputationType.WATER -> false;
            default -> throw new MatchException(null, null);
        };
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_52739_) {
        BlockPos $$1 = p_52739_.getClickedPos();
        Level $$2 = p_52739_.getLevel();
        if ($$1.getY() < $$2.getMaxY() - 1 && $$2.getBlockState($$1.above()).canBeReplaced(p_52739_)) {
            boolean $$3 = $$2.hasNeighborSignal($$1) || $$2.hasNeighborSignal($$1.above());
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)p_52739_.getHorizontalDirection())).setValue(HINGE, (Comparable)this.getHinge(p_52739_))).setValue((Property)POWERED, (Comparable)Boolean.valueOf($$3))).setValue((Property)OPEN, (Comparable)Boolean.valueOf($$3))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void setPlacedBy(Level p_52749_, BlockPos p_52750_, BlockState p_52751_, LivingEntity p_52752_, ItemStack p_52753_) {
        p_52749_.setBlock(p_52750_.above(), (BlockState)p_52751_.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    private DoorHingeSide getHinge(BlockPlaceContext p_52805_) {
        boolean $$17;
        Level $$1 = p_52805_.getLevel();
        BlockPos $$2 = p_52805_.getClickedPos();
        Direction $$3 = p_52805_.getHorizontalDirection();
        BlockPos $$4 = $$2.above();
        Direction $$5 = $$3.getCounterClockWise();
        BlockPos $$6 = $$2.relative($$5);
        BlockState $$7 = $$1.getBlockState($$6);
        BlockPos $$8 = $$4.relative($$5);
        BlockState $$9 = $$1.getBlockState($$8);
        Direction $$10 = $$3.getClockWise();
        BlockPos $$11 = $$2.relative($$10);
        BlockState $$12 = $$1.getBlockState($$11);
        BlockPos $$13 = $$4.relative($$10);
        BlockState $$14 = $$1.getBlockState($$13);
        int $$15 = ($$7.isCollisionShapeFullBlock((BlockGetter)$$1, $$6) ? -1 : 0) + ($$9.isCollisionShapeFullBlock((BlockGetter)$$1, $$8) ? -1 : 0) + ($$12.isCollisionShapeFullBlock((BlockGetter)$$1, $$11) ? 1 : 0) + ($$14.isCollisionShapeFullBlock((BlockGetter)$$1, $$13) ? 1 : 0);
        boolean $$16 = $$7.getBlock() instanceof TTDoorBlock && $$7.getValue(HALF) == DoubleBlockHalf.LOWER;
        boolean bl = $$17 = $$12.getBlock() instanceof TTDoorBlock && $$12.getValue(HALF) == DoubleBlockHalf.LOWER;
        if ((!$$16 || $$17) && $$15 <= 0) {
            if ((!$$17 || $$16) && $$15 >= 0) {
                int $$18 = $$3.getStepX();
                int $$19 = $$3.getStepZ();
                Vec3 $$20 = p_52805_.getClickLocation();
                double $$21 = $$20.x - (double)$$2.getX();
                double $$22 = $$20.z - (double)$$2.getZ();
                return !($$18 < 0 && $$22 < 0.5 || $$18 > 0 && $$22 > 0.5 || $$19 < 0 && $$21 > 0.5 || $$19 > 0 && $$21 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    protected InteractionResult useWithoutItem(BlockState p_52769_, Level p_52770_, BlockPos p_52771_, Player p_52772_, BlockHitResult p_52774_) {
        if (!this.type.canOpenByHand()) {
            return InteractionResult.PASS;
        }
        p_52769_ = (BlockState)p_52769_.cycle((Property)OPEN);
        p_52770_.setBlock(p_52771_, p_52769_, 10);
        this.playSound((Entity)p_52772_, p_52770_, p_52771_, (Boolean)p_52769_.getValue((Property)OPEN));
        p_52770_.gameEvent((Entity)p_52772_, (Holder)(this.isOpen(p_52769_) ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), p_52771_);
        return InteractionResult.SUCCESS;
    }

    public boolean isOpen(BlockState p_52816_) {
        return (Boolean)p_52816_.getValue((Property)OPEN);
    }

    public void setOpen(@Nullable Entity p_153166_, Level p_153167_, BlockState p_153168_, BlockPos p_153169_, boolean p_153170_) {
        if (p_153168_.is((Block)this) && (Boolean)p_153168_.getValue((Property)OPEN) != p_153170_) {
            p_153167_.setBlock(p_153169_, (BlockState)p_153168_.setValue((Property)OPEN, (Comparable)Boolean.valueOf(p_153170_)), 10);
            this.playSound(p_153166_, p_153167_, p_153169_, p_153170_);
            p_153167_.gameEvent(p_153166_, (Holder)(p_153170_ ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), p_153169_);
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState blockstate = level.getBlockState(blockpos);
        return state.getValue(HALF) == DoubleBlockHalf.LOWER ? blockstate.isFaceSturdy((BlockGetter)level, blockpos, Direction.UP) : blockstate.is((Block)this);
    }

    private void playSound(@Nullable Entity p_251616_, Level p_249656_, BlockPos p_249439_, boolean p_251628_) {
        p_249656_.playSound(p_251616_, p_249439_, p_251628_ ? this.type.doorOpen() : this.type.doorClose(), SoundSource.BLOCKS, 1.0f, p_249656_.getRandom().nextFloat() * 0.1f + 0.9f);
    }

    protected BlockState rotate(BlockState p_52790_, Rotation p_52791_) {
        return (BlockState)p_52790_.setValue(FACING, (Comparable)p_52791_.rotate((Direction)p_52790_.getValue(FACING)));
    }

    protected BlockState mirror(BlockState p_52787_, Mirror p_52788_) {
        return p_52788_ == Mirror.NONE ? p_52787_ : (BlockState)p_52787_.rotate(p_52788_.getRotation((Direction)p_52787_.getValue(FACING))).cycle(HINGE);
    }

    protected long getSeed(BlockState p_52793_, BlockPos p_52794_) {
        return Mth.getSeed((int)p_52794_.getX(), (int)p_52794_.below(p_52793_.getValue(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).getY(), (int)p_52794_.getZ());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_52803_) {
        p_52803_.add(new Property[]{HALF, FACING, OPEN, HINGE, POWERED, NATURAL});
    }

    public BlockEntity newBlockEntity(BlockPos p_154687_, BlockState p_154688_) {
        return new TreasureDoorBlockentity(p_154687_, p_154688_);
    }

    static {
        NATURAL = BlockStateProperties.DISARMED;
        FACING = HorizontalDirectionalBlock.FACING;
        OPEN = BlockStateProperties.OPEN;
        HINGE = BlockStateProperties.DOOR_HINGE;
        POWERED = BlockStateProperties.POWERED;
        HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
        SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
        NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
        WEST_AABB = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        EAST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    }
}

