/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.blocks;

import com.belgie.tricky_trials.common.blockentity.TreasureDoorBlockentity;
import com.belgie.tricky_trials.common.blocks.TTDoorBlock;
import com.belgie.tricky_trials.core.TTBlockEntityRegistry;
import com.belgie.tricky_trials.core.TTItemRegistry;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class TreasureDoorBlock
extends TTDoorBlock {
    public DoorType door_type;

    public TreasureDoorBlock(DoorType type, BlockSetType p_272854_, BlockBehaviour.Properties p_273303_) {
        super(p_272854_, p_273303_.randomTicks());
        this.door_type = type;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_154683_, BlockState p_154684_, BlockEntityType<T> p_154685_) {
        return TreasureDoorBlock.createTickerHelper(p_154685_, TTBlockEntityRegistry.TREASURE_DOOR.get(), TreasureDoorBlockentity::clientTick);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState p_52769_, Level p_52770_, BlockPos p_52771_, Player p_52772_, BlockHitResult p_52774_) {
        return InteractionResult.PASS;
    }

    protected RenderShape getRenderShape(BlockState p_54296_) {
        return RenderShape.MODEL;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return (Boolean)state.getValue((Property)OPEN) != false ? 1.0f : 1000.0f;
    }

    protected InteractionResult useItemOn(ItemStack p_330929_, BlockState p_335716_, Level p_336112_, BlockPos p_328869_, Player p_332840_, InteractionHand p_336117_, BlockHitResult p_332723_) {
        if (p_330929_.is(this.door_type.getKeyItem()) && !((Boolean)p_335716_.getValue((Property)OPEN)).booleanValue() && ((Boolean)p_335716_.getValue((Property)NATURAL)).booleanValue()) {
            p_335716_ = (BlockState)p_335716_.cycle((Property)OPEN);
            p_336112_.setBlock(p_328869_, p_335716_, 10);
            this.playSound((Entity)p_332840_, p_336112_, p_328869_, (Boolean)p_335716_.getValue((Property)OPEN));
            p_336112_.gameEvent((Entity)p_332840_, (Holder)(this.isOpen(p_335716_) ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), p_328869_);
            p_330929_.consume(1, (LivingEntity)p_332840_);
            return InteractionResult.SUCCESS;
        }
        if (p_330929_.is(this.door_type.getKeyItem()) && !((Boolean)p_335716_.getValue((Property)NATURAL)).booleanValue()) {
            p_335716_ = (BlockState)p_335716_.cycle((Property)OPEN);
            p_336112_.setBlock(p_328869_, p_335716_, 10);
            this.playSound((Entity)p_332840_, p_336112_, p_328869_, (Boolean)p_335716_.getValue((Property)OPEN));
            p_336112_.gameEvent((Entity)p_332840_, (Holder)(this.isOpen(p_335716_) ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), p_328869_);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private void playSound(@Nullable Entity p_251616_, Level p_249656_, BlockPos p_249439_, boolean p_251628_) {
        p_249656_.playSound(p_251616_, p_249439_, p_251628_ ? this.type().doorOpen() : this.type().doorClose(), SoundSource.BLOCKS, 1.0f, p_249656_.getRandom().nextFloat() * 0.1f + 0.9f);
    }

    public static enum DoorType implements StringRepresentable
    {
        TRIAL(() -> Items.TRIAL_KEY, 0, "trial"),
        OMINOUS(() -> Items.OMINOUS_TRIAL_KEY, 1, "ominous"),
        TRICKY(() -> TTItemRegistry.TRICKY_KEY.get(), 2, "tricky"),
        OMINOUS_TRICKY(() -> TTItemRegistry.OMINOUS_TRICKY_KEY.get(), 3, "ominous_tricky"),
        PRISMARINE(() -> TTItemRegistry.ELDER_KEY.get(), 4, "prismarine"),
        END(() -> TTItemRegistry.CITY_KEY.get(), 5, "end"),
        DEEP_DARK(() -> TTItemRegistry.ECHO_KEY.get(), 6, "deep_dark"),
        BASTION(() -> TTItemRegistry.BASTION_KEY.get(), 7, "bastion"),
        WOODLAND(() -> TTItemRegistry.WOODLAND_KEY.get(), 8, "woodland");

        public static final StringRepresentable.EnumCodec<DoorType> CODEC;
        private static final IntFunction<DoorType> BY_ID;
        private final int id;
        private final String name;
        public final Supplier<Item> item;

        private DoorType(Supplier<Item> item, int p_196658_, String p_196659_) {
            this.id = p_196658_;
            this.name = p_196659_;
            this.item = item;
        }

        public String getSerializedName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public static DoorType byName(String p_28817_) {
            return (DoorType)CODEC.byName(p_28817_, (Enum)TRIAL);
        }

        public static DoorType byId(int p_28813_) {
            return BY_ID.apply(p_28813_);
        }

        public Item getKeyItem() {
            return this.item.get();
        }

        static {
            CODEC = StringRepresentable.fromEnum(DoorType::values);
            BY_ID = ByIdMap.continuous(DoorType::getId, (Object[])DoorType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

