/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.blocks;

import com.belgie.tricky_trials.common.entity.HeavyCoreBoss;
import com.belgie.tricky_trials.core.TTEntityRegistry;
import com.belgie.tricky_trials.core.TTItemRegistry;
import com.belgie.tricky_trials.core.TTParticleRegistry;
import com.belgie.tricky_trials.core.TTSoundRegistry;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class TrialAlterBlock
extends Block {
    public static final MapCodec<TrialAlterBlock> CODEC = TrialAlterBlock.simpleCodec(TrialAlterBlock::new);
    public static final int MIN_CHARGES = 0;
    public static final int MAX_CHARGES = 4;
    public static final IntegerProperty CHARGE = BlockStateProperties.RESPAWN_ANCHOR_CHARGES;
    private static final ImmutableList<Vec3i> RESPAWN_HORIZONTAL_OFFSETS = ImmutableList.of((Object)new Vec3i(0, 0, -1), (Object)new Vec3i(-1, 0, 0), (Object)new Vec3i(0, 0, 1), (Object)new Vec3i(1, 0, 0), (Object)new Vec3i(-1, 0, -1), (Object)new Vec3i(1, 0, -1), (Object)new Vec3i(-1, 0, 1), (Object)new Vec3i(1, 0, 1));
    private static final ImmutableList<Vec3i> RESPAWN_OFFSETS = new ImmutableList.Builder().addAll(RESPAWN_HORIZONTAL_OFFSETS).addAll(RESPAWN_HORIZONTAL_OFFSETS.stream().map(Vec3i::below).iterator()).addAll(RESPAWN_HORIZONTAL_OFFSETS.stream().map(Vec3i::above).iterator()).add((Object)new Vec3i(0, 1, 0)).build();

    public MapCodec<TrialAlterBlock> codec() {
        return CODEC;
    }

    public TrialAlterBlock(BlockBehaviour.Properties p_55838_) {
        super(p_55838_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CHARGE, (Comparable)Integer.valueOf(0)));
    }

    protected InteractionResult useItemOn(ItemStack p_316531_, BlockState p_316665_, Level p_316165_, BlockPos p_316402_, Player p_316556_, InteractionHand p_316586_, BlockHitResult p_316326_) {
        if (TrialAlterBlock.isRespawnFuel(p_316531_) && TrialAlterBlock.canBeCharged(p_316665_)) {
            TrialAlterBlock.charge((Entity)p_316556_, p_316165_, p_316402_, p_316665_);
            p_316531_.consume(1, (LivingEntity)p_316556_);
            return InteractionResult.SUCCESS;
        }
        return (InteractionResult)(p_316586_ == InteractionHand.MAIN_HAND && TrialAlterBlock.isRespawnFuel(p_316556_.getItemInHand(InteractionHand.OFF_HAND)) && TrialAlterBlock.canBeCharged(p_316665_) ? InteractionResult.PASS : InteractionResult.TRY_WITH_EMPTY_HAND);
    }

    protected InteractionResult useWithoutItem(BlockState p_316377_, Level p_316150_, BlockPos p_316161_, Player p_316889_, BlockHitResult p_316358_) {
        if ((Integer)p_316377_.getValue((Property)CHARGE) != 4) {
            return InteractionResult.PASS;
        }
        if (!p_316150_.isClientSide) {
            ServerPlayer serverplayer = (ServerPlayer)p_316889_;
            if ((Integer)p_316377_.getValue((Property)CHARGE) == 4) {
                TrialAlterBlock.Activate((Entity)p_316889_, p_316150_, p_316161_, p_316377_);
                return InteractionResult.SUCCESS_SERVER;
            }
        }
        return InteractionResult.CONSUME;
    }

    private static boolean isRespawnFuel(ItemStack stack) {
        return stack.is(TTItemRegistry.TRIAL_SHARD.get());
    }

    private static boolean canBeCharged(BlockState state) {
        return (Integer)state.getValue((Property)CHARGE) < 4;
    }

    public static void charge(@Nullable Entity entity, Level level, BlockPos pos, BlockState state) {
        BlockState blockstate = (BlockState)state.setValue((Property)CHARGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)CHARGE) + 1));
        level.setBlock(pos, blockstate, 3);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)blockstate));
        level.playSound((Player)null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.RESPAWN_ANCHOR_CHARGE, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static void Activate(@Nullable Entity entity, Level level, BlockPos pos, BlockState state) {
        BlockState blockstate = (BlockState)state.setValue((Property)CHARGE, (Comparable)Integer.valueOf(0));
        level.setBlock(pos, blockstate, 3);
        ServerLevel serverlevel = (ServerLevel)level;
        HeavyCoreBoss rabbit = (HeavyCoreBoss)TTEntityRegistry.HEAVY_CORE_BOSS.get().create(level, EntitySpawnReason.TRIGGERED);
        if (rabbit != null) {
            rabbit.moveTo(new Vec3((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5), 0.0f, 0.0f);
            rabbit.finalizeSpawn((ServerLevelAccessor)serverlevel, level.getCurrentDifficultyAt(pos), EntitySpawnReason.TRIGGERED, null);
            level.addFreshEntity((Entity)rabbit);
            level.gameEvent((Holder)GameEvent.ENTITY_PLACE, pos, GameEvent.Context.of((Entity)rabbit));
        }
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)blockstate));
        level.playSound((Player)null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, TTSoundRegistry.TRIAL_ALTER_POWER, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void animateTick(BlockState p_221969_, Level p_221970_, BlockPos p_221971_, RandomSource p_221972_) {
        if ((Integer)p_221969_.getValue((Property)CHARGE) != 0) {
            if (p_221972_.nextInt(100) == 0) {
                p_221970_.playLocalSound(p_221971_, SoundEvents.RESPAWN_ANCHOR_AMBIENT, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            double d0 = (double)p_221971_.getX() + 0.5 + (0.5 - p_221972_.nextDouble());
            double d1 = (double)p_221971_.getY() + 1.0;
            double d2 = (double)p_221971_.getZ() + 0.5 + (0.5 - p_221972_.nextDouble());
            double d3 = (double)p_221972_.nextFloat() * 0.04;
            p_221970_.addParticle((ParticleOptions)TTParticleRegistry.HEAVY_TARGET.get(), d0, d1, d2, 0.0, d3, 0.0);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CHARGE});
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public static int getScaledChargeLevel(BlockState state, int scale) {
        return Mth.floor((float)((float)((Integer)state.getValue((Property)CHARGE) - 0) / 4.0f * (float)scale));
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return TrialAlterBlock.getScaledChargeLevel(blockState, 15);
    }

    protected boolean isPathfindable(BlockState p_55865_, PathComputationType p_55868_) {
        return false;
    }

    public void performSpellCasting(Level level, BlockPos pos) {
        ServerLevel serverlevel = (ServerLevel)level;
        HeavyCoreBoss rabbit = (HeavyCoreBoss)TTEntityRegistry.HEAVY_CORE_BOSS.get().create(level, EntitySpawnReason.BREEDING);
        if (rabbit != null) {
            rabbit.moveTo(new Vec3((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5), 0.0f, 0.0f);
            rabbit.finalizeSpawn((ServerLevelAccessor)serverlevel, level.getCurrentDifficultyAt(pos), EntitySpawnReason.TRIGGERED, null);
            level.addFreshEntity((Entity)rabbit);
            level.gameEvent((Holder)GameEvent.ENTITY_PLACE, pos, GameEvent.Context.of((Entity)rabbit));
        }
    }
}

