/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.blocks;

import com.belgie.tricky_trials.common.blockentity.TrialPodiumBlockEntity;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TrialPodiumBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<TrialPodiumBlock> CODEC = TrialPodiumBlock.simpleCodec(TrialPodiumBlock::new);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public VoxelShape makeShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.625, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.625, (double)0.125, (double)0.875, (double)0.8125, (double)0.875), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public MapCodec<TrialPodiumBlock> codec() {
        return CODEC;
    }

    public TrialPodiumBlock(BlockBehaviour.Properties p_273064_) {
        super(p_273064_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockState updateShape(BlockState p_60541_, LevelReader p_368027_, ScheduledTickAccess p_366146_, BlockPos p_60545_, Direction p_60542_, BlockPos p_60546_, BlockState p_60543_, RandomSource p_363918_) {
        if (((Boolean)p_60541_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_366146_.scheduleTick(p_60545_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(p_368027_));
        }
        return super.updateShape(p_60541_, p_368027_, p_366146_, p_60545_, p_60542_, p_60546_, p_60543_, p_363918_);
    }

    protected RenderShape getRenderShape(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_272711_) {
        FluidState $$1 = p_272711_.getLevel().getFluidState(p_272711_.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf($$1.getType() == Fluids.WATER));
    }

    protected InteractionResult useItemOn(ItemStack p_316569_, BlockState p_316562_, Level p_316177_, BlockPos p_316898_, Player p_316632_, InteractionHand p_316424_, BlockHitResult p_316345_) {
        BlockEntity var9 = p_316177_.getBlockEntity(p_316898_);
        if (var9 instanceof TrialPodiumBlockEntity) {
            TrialPodiumBlockEntity decoratedpotblockentity = (TrialPodiumBlockEntity)var9;
            if (p_316177_.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            ItemStack itemstack1 = decoratedpotblockentity.getTheItem();
            if (p_316569_.isEmpty() || !itemstack1.isEmpty() && (!ItemStack.isSameItemSameComponents((ItemStack)itemstack1, (ItemStack)p_316569_) || itemstack1.getCount() >= itemstack1.getMaxStackSize())) {
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            if (itemstack1.isEmpty()) {
                p_316632_.awardStat(Stats.ITEM_USED.get((Object)p_316569_.getItem()));
                ItemStack itemstack = p_316569_.consumeAndReturn(1, (LivingEntity)p_316632_);
                decoratedpotblockentity.setTheItem(itemstack);
                p_316177_.playSound((Player)null, p_316898_, SoundEvents.DECORATED_POT_INSERT, SoundSource.BLOCKS, 1.0f, 1.2f);
                decoratedpotblockentity.markUpdated();
                p_316177_.gameEvent((Entity)p_316632_, (Holder)GameEvent.BLOCK_CHANGE, p_316898_);
                return InteractionResult.SUCCESS;
            }
        } else {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.CONSUME;
    }

    protected InteractionResult useWithoutItem(BlockState p_329061_, Level p_331143_, BlockPos p_332658_, Player p_330362_, BlockHitResult p_330700_) {
        BlockEntity var7 = p_331143_.getBlockEntity(p_332658_);
        if (var7 instanceof TrialPodiumBlockEntity) {
            TrialPodiumBlockEntity $$6 = (TrialPodiumBlockEntity)var7;
            p_331143_.playSound((Player)null, p_332658_, SoundEvents.VAULT_CLOSE_SHUTTER, SoundSource.BLOCKS, 1.0f, 1.0f);
            p_331143_.gameEvent((Entity)p_330362_, (Holder)GameEvent.BLOCK_CHANGE, p_332658_);
            if (!$$6.ConsumeClick) {
                ItemStack stack = $$6.getTheItem();
                p_330362_.addItem(stack);
                $$6.setTheItem(ItemStack.EMPTY);
                $$6.setChanged();
                $$6.markUpdated();
            } else {
                $$6.markUpdated();
            }
            $$6.ConsumeClick = false;
            return InteractionResult.SUCCESS_SERVER;
        }
        return InteractionResult.PASS;
    }

    protected boolean isPathfindable(BlockState p_276295_, PathComputationType p_276303_) {
        return false;
    }

    protected VoxelShape getShape(BlockState p_273112_, BlockGetter p_273055_, BlockPos p_273137_, CollisionContext p_273151_) {
        return this.makeShape();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_273169_) {
        p_273169_.add(new Property[]{WATERLOGGED});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_273396_, BlockState p_272674_) {
        return new TrialPodiumBlockEntity(p_273396_, p_272674_);
    }

    protected void onRemove(BlockState p_312694_, Level p_313251_, BlockPos p_312873_, BlockState p_312133_, boolean p_311809_) {
        Containers.dropContentsOnDestroy((BlockState)p_312694_, (BlockState)p_312133_, (Level)p_313251_, (BlockPos)p_312873_);
        super.onRemove(p_312694_, p_313251_, p_312873_, p_312133_, p_311809_);
    }

    protected FluidState getFluidState(BlockState p_272593_) {
        return (Boolean)p_272593_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_272593_);
    }

    protected SoundType getSoundType(BlockState p_277561_) {
        return SoundType.DECORATED_POT;
    }

    protected boolean hasAnalogOutputSignal(BlockState p_310567_) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState p_310830_, Level p_312569_, BlockPos p_309943_) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)p_312569_.getBlockEntity(p_309943_));
    }
}

