/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity.AI;

import com.belgie.tricky_trials.common.entity.AI.BlitzeLongJump;
import com.belgie.tricky_trials.common.entity.AI.BlitzeShoot;
import com.belgie.tricky_trials.common.entity.AI.BlitzeShootWhenStuck;
import com.belgie.tricky_trials.common.entity.AI.BlitzeSlide;
import com.belgie.tricky_trials.common.entity.BlitzeEntity;
import com.belgie.tricky_trials.core.TTEntityRegistry;
import com.belgie.tricky_trials.core.TTSoundRegistry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class BlitzeAI {
    public static final float SPEED_MULTIPLIER_WHEN_SLIDING = 0.6f;
    public static final float JUMP_CIRCLE_INNER_RADIUS = 4.0f;
    public static final float JUMP_CIRCLE_MIDDLE_RADIUS = 8.0f;
    public static final float JUMP_CIRCLE_OUTER_RADIUS = 20.0f;
    public static final List<SensorType<? extends Sensor<? super BlitzeEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, (Object)SensorType.NEAREST_PLAYERS, TTEntityRegistry.BLITZE_SENSOR.get());
    public static final List<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_ATTACKABLE, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.BREEZE_JUMP_COOLDOWN, (Object)MemoryModuleType.BREEZE_JUMP_INHALING, (Object)MemoryModuleType.BREEZE_SHOOT, (Object)MemoryModuleType.BREEZE_SHOOT_CHARGING, (Object)MemoryModuleType.BREEZE_SHOOT_RECOVERING, (Object)MemoryModuleType.BREEZE_SHOOT_COOLDOWN, (Object[])new MemoryModuleType[]{MemoryModuleType.BREEZE_JUMP_TARGET, MemoryModuleType.BREEZE_LEAVING_WATER, MemoryModuleType.HURT_BY, MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.PATH});

    public static Brain<?> makeBrain(Brain<BlitzeEntity> p_311919_) {
        BlitzeAI.initCoreActivity(p_311919_);
        BlitzeAI.initIdleActivity(p_311919_);
        BlitzeAI.initFightActivity(p_311919_);
        p_311919_.setCoreActivities(Set.of(Activity.CORE));
        p_311919_.setDefaultActivity(Activity.FIGHT);
        p_311919_.useDefaultActivity();
        return p_311919_;
    }

    private static void initCoreActivity(Brain<BlitzeEntity> p_312238_) {
        p_312238_.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90)));
    }

    private static void initIdleActivity(Brain<BlitzeEntity> p_335718_) {
        p_335718_.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)StartAttacking.create((p_369589_, p_312068_) -> p_312068_.getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE))), (Object)Pair.of((Object)1, (Object)StartAttacking.create((p_359265_, p_359266_) -> p_359266_.getHurtBy())), (Object)Pair.of((Object)2, (Object)((Object)new SlideToTargetSink(20, 40))), (Object)Pair.of((Object)3, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new DoNothing(20, 100), (Object)1), (Object)Pair.of((Object)RandomStroll.stroll((float)0.6f), (Object)2))))));
    }

    private static void initFightActivity(Brain<BlitzeEntity> p_310469_) {
        p_310469_.addActivityWithConditions(Activity.FIGHT, ImmutableList.of((Object)Pair.of((Object)0, (Object)StopAttackingIfTargetInvalid.create()), (Object)Pair.of((Object)1, (Object)((Object)new BlitzeShoot())), (Object)Pair.of((Object)2, (Object)((Object)new BlitzeLongJump())), (Object)Pair.of((Object)3, (Object)((Object)new BlitzeShootWhenStuck())), (Object)Pair.of((Object)4, (Object)((Object)new BlitzeSlide()))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT), (Object)Pair.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    public static void updateActivity(BlitzeEntity p_331608_) {
        p_331608_.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.IDLE));
    }

    public static class SlideToTargetSink
    extends MoveToTargetSink {
        @VisibleForTesting
        public SlideToTargetSink(int p_309679_, int p_309866_) {
            super(p_309679_, p_309866_);
        }

        protected void start(ServerLevel p_312379_, Mob p_312744_, long p_311813_) {
            super.start(p_312379_, p_312744_, p_311813_);
            p_312744_.playSound((SoundEvent)TTSoundRegistry.BLITZE_SLIDE.get());
            p_312744_.setPose(Pose.SLIDING);
        }

        protected void stop(ServerLevel p_311146_, Mob p_310932_, long p_312981_) {
            super.stop(p_311146_, p_310932_, p_312981_);
            p_310932_.setPose(Pose.STANDING);
            if (p_310932_.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET)) {
                p_310932_.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_SHOOT, (Object)Unit.INSTANCE, 60L);
            }
        }
    }
}

