/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity.AI;

import com.belgie.tricky_trials.common.entity.AI.BlitzeUtil;
import com.belgie.tricky_trials.common.entity.BlitzeEntity;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.LongJumpUtil;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BlitzeLongJump
extends Behavior<BlitzeEntity> {
    private static final int REQUIRED_AIR_BLOCKS_ABOVE = 4;
    private static final int JUMP_COOLDOWN_TICKS = 10;
    private static final int JUMP_COOLDOWN_WHEN_HURT_TICKS = 2;
    private static final int INHALING_DURATION_TICKS = Math.round(10.0f);
    private static final float MAX_JUMP_VELOCITY = 1.4f;
    private static final ObjectArrayList<Integer> ALLOWED_ANGLES = new ObjectArrayList((Collection)Lists.newArrayList((Object[])new Integer[]{40, 55, 60, 75, 80}));

    @VisibleForTesting
    public BlitzeLongJump() {
        super(Map.of(MemoryModuleType.ATTACK_TARGET, MemoryStatus.VALUE_PRESENT, MemoryModuleType.BREEZE_JUMP_COOLDOWN, MemoryStatus.VALUE_ABSENT, MemoryModuleType.BREEZE_JUMP_INHALING, MemoryStatus.REGISTERED, MemoryModuleType.BREEZE_JUMP_TARGET, MemoryStatus.REGISTERED, MemoryModuleType.BREEZE_SHOOT, MemoryStatus.VALUE_ABSENT, MemoryModuleType.WALK_TARGET, MemoryStatus.VALUE_ABSENT, MemoryModuleType.BREEZE_LEAVING_WATER, MemoryStatus.REGISTERED), 200);
    }

    public static boolean canRun(ServerLevel p_328434_, BlitzeEntity p_330036_) {
        if (!p_330036_.onGround() && !p_330036_.isInWater()) {
            return false;
        }
        if (Swim.shouldSwim((Mob)p_330036_)) {
            return false;
        }
        if (p_330036_.getBrain().checkMemory(MemoryModuleType.BREEZE_JUMP_TARGET, MemoryStatus.VALUE_PRESENT)) {
            return true;
        }
        LivingEntity $$2 = p_330036_.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
        if ($$2 == null) {
            return false;
        }
        if (BlitzeLongJump.outOfAggroRange(p_330036_, $$2)) {
            p_330036_.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
            return false;
        }
        if (BlitzeLongJump.tooCloseForJump(p_330036_, $$2)) {
            return false;
        }
        if (!BlitzeLongJump.canJumpFromCurrentPosition(p_328434_, p_330036_)) {
            return false;
        }
        BlockPos $$3 = BlitzeLongJump.snapToSurface((LivingEntity)p_330036_, BlitzeUtil.randomPointBehindTarget($$2, p_330036_.getRandom()));
        if ($$3 == null) {
            return false;
        }
        BlockState $$4 = p_328434_.getBlockState($$3.below());
        if (p_330036_.getType().isBlockDangerous($$4)) {
            return false;
        }
        if (!BlitzeUtil.hasLineOfSight(p_330036_, $$3.getCenter()) && !BlitzeUtil.hasLineOfSight(p_330036_, $$3.above(4).getCenter())) {
            return false;
        }
        p_330036_.getBrain().setMemory(MemoryModuleType.BREEZE_JUMP_TARGET, (Object)$$3);
        return true;
    }

    protected boolean checkExtraStartConditions(ServerLevel p_312411_, BlitzeEntity p_309539_) {
        return BlitzeLongJump.canRun(p_312411_, p_309539_);
    }

    protected boolean canStillUse(ServerLevel p_310673_, BlitzeEntity p_311330_, long p_310051_) {
        return p_311330_.getPose() != Pose.STANDING && !p_311330_.getBrain().hasMemoryValue(MemoryModuleType.BREEZE_JUMP_COOLDOWN);
    }

    protected void start(ServerLevel p_310741_, BlitzeEntity p_312948_, long p_311377_) {
        if (p_312948_.getBrain().checkMemory(MemoryModuleType.BREEZE_JUMP_INHALING, MemoryStatus.VALUE_ABSENT)) {
            p_312948_.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_JUMP_INHALING, (Object)Unit.INSTANCE, (long)INHALING_DURATION_TICKS);
        }
        p_312948_.setPose(Pose.INHALING);
        p_310741_.playSound((Player)null, (Entity)p_312948_, SoundEvents.BREEZE_CHARGE, SoundSource.HOSTILE, 1.0f, 1.0f);
        p_312948_.getBrain().getMemory(MemoryModuleType.BREEZE_JUMP_TARGET).ifPresent(p_311106_ -> p_312948_.lookAt(EntityAnchorArgument.Anchor.EYES, p_311106_.getCenter()));
    }

    protected void tick(ServerLevel p_312629_, BlitzeEntity p_310204_, long p_313176_) {
        boolean $$3 = p_310204_.isInWater();
        if (!$$3 && p_310204_.getBrain().checkMemory(MemoryModuleType.BREEZE_LEAVING_WATER, MemoryStatus.VALUE_PRESENT)) {
            p_310204_.getBrain().eraseMemory(MemoryModuleType.BREEZE_LEAVING_WATER);
        }
        if (BlitzeLongJump.isFinishedInhaling(p_310204_)) {
            Vec3 $$4 = p_310204_.getBrain().getMemory(MemoryModuleType.BREEZE_JUMP_TARGET).flatMap(p_327018_ -> BlitzeLongJump.calculateOptimalJumpVector(p_310204_, p_310204_.getRandom(), Vec3.atBottomCenterOf((Vec3i)p_327018_))).orElse(null);
            if ($$4 == null) {
                p_310204_.setPose(Pose.STANDING);
                return;
            }
            if ($$3) {
                p_310204_.getBrain().setMemory(MemoryModuleType.BREEZE_LEAVING_WATER, (Object)Unit.INSTANCE);
            }
            p_310204_.playSound(SoundEvents.BREEZE_JUMP, 1.0f, 1.0f);
            p_310204_.setPose(Pose.LONG_JUMPING);
            p_310204_.setYRot(p_310204_.yBodyRot);
            p_310204_.setDiscardFriction(true);
            p_310204_.setDeltaMovement($$4);
        } else if (BlitzeLongJump.isFinishedJumping(p_310204_)) {
            p_310204_.playSound(SoundEvents.BREEZE_LAND, 1.0f, 1.0f);
            p_310204_.setPose(Pose.STANDING);
            p_310204_.setDiscardFriction(false);
            boolean $$5 = p_310204_.getBrain().hasMemoryValue(MemoryModuleType.HURT_BY);
            p_310204_.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_JUMP_COOLDOWN, (Object)Unit.INSTANCE, $$5 ? 2L : 10L);
            p_310204_.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_SHOOT, (Object)Unit.INSTANCE, 100L);
        }
    }

    protected void stop(ServerLevel p_309511_, BlitzeEntity p_311681_, long p_312980_) {
        if (p_311681_.getPose() == Pose.LONG_JUMPING || p_311681_.getPose() == Pose.INHALING) {
            p_311681_.setPose(Pose.STANDING);
        }
        p_311681_.getBrain().eraseMemory(MemoryModuleType.BREEZE_JUMP_TARGET);
        p_311681_.getBrain().eraseMemory(MemoryModuleType.BREEZE_JUMP_INHALING);
        p_311681_.getBrain().eraseMemory(MemoryModuleType.BREEZE_LEAVING_WATER);
    }

    private static boolean isFinishedInhaling(BlitzeEntity p_330141_) {
        return p_330141_.getBrain().getMemory(MemoryModuleType.BREEZE_JUMP_INHALING).isEmpty() && p_330141_.getPose() == Pose.INHALING;
    }

    private static boolean isFinishedJumping(BlitzeEntity p_330755_) {
        boolean $$1 = p_330755_.getPose() == Pose.LONG_JUMPING;
        boolean $$2 = p_330755_.onGround();
        boolean $$3 = p_330755_.isInWater() && p_330755_.getBrain().checkMemory(MemoryModuleType.BREEZE_LEAVING_WATER, MemoryStatus.VALUE_ABSENT);
        return $$1 && ($$2 || $$3);
    }

    @Nullable
    private static BlockPos snapToSurface(LivingEntity p_312785_, Vec3 p_311613_) {
        ClipContext $$2 = new ClipContext(p_311613_, p_311613_.relative(Direction.DOWN, 10.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)p_312785_);
        BlockHitResult $$3 = p_312785_.level().clip($$2);
        if ($$3.getType() == HitResult.Type.BLOCK) {
            return BlockPos.containing((Position)$$3.getLocation()).above();
        }
        ClipContext $$4 = new ClipContext(p_311613_, p_311613_.relative(Direction.UP, 10.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)p_312785_);
        BlockHitResult $$5 = p_312785_.level().clip($$4);
        return $$5.getType() == HitResult.Type.BLOCK ? BlockPos.containing((Position)$$5.getLocation()).above() : null;
    }

    private static boolean outOfAggroRange(BlitzeEntity p_310244_, LivingEntity p_309508_) {
        return !p_309508_.closerThan((Entity)p_310244_, 24.0);
    }

    private static boolean tooCloseForJump(BlitzeEntity p_310091_, LivingEntity p_311303_) {
        return p_311303_.distanceTo((Entity)p_310091_) - 4.0f <= 0.0f;
    }

    private static boolean canJumpFromCurrentPosition(ServerLevel p_312023_, BlitzeEntity p_313218_) {
        BlockPos $$2 = p_313218_.blockPosition();
        for (int $$3 = 1; $$3 <= 4; ++$$3) {
            BlockPos $$4 = $$2.relative(Direction.UP, $$3);
            if (p_312023_.getBlockState($$4).isAir() || p_312023_.getFluidState($$4).is(FluidTags.WATER)) continue;
            return false;
        }
        return true;
    }

    private static Optional<Vec3> calculateOptimalJumpVector(BlitzeEntity p_310143_, RandomSource p_313023_, Vec3 p_309973_) {
        int $$4;
        Optional $$5;
        List $$3 = Util.shuffledCopy(ALLOWED_ANGLES, (RandomSource)p_313023_);
        Iterator var4 = $$3.iterator();
        do {
            if (var4.hasNext()) continue;
            return Optional.empty();
        } while (!($$5 = LongJumpUtil.calculateJumpVectorForAngle((Mob)p_310143_, (Vec3)p_309973_, (float)1.4f, (int)($$4 = ((Integer)var4.next()).intValue()), (boolean)false)).isPresent());
        return $$5;
    }
}

