/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity.AI;

import com.belgie.tricky_trials.common.entity.BlitzeEarthChargeEntity;
import com.belgie.tricky_trials.common.entity.BlitzeEntity;
import com.belgie.tricky_trials.core.TTSoundRegistry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BlitzeShoot
extends Behavior<BlitzeEntity> {
    private static final int ATTACK_RANGE_MIN_SQRT = 4;
    private static final int ATTACK_RANGE_MAX_SQRT = 256;
    private static final int UNCERTAINTY_BASE = 5;
    private static final int UNCERTAINTY_MULTIPLIER = 4;
    private static final float PROJECTILE_MOVEMENT_SCALE = 0.7f;
    private static final int SHOOT_INITIAL_DELAY_TICKS = Math.round(15.0f);
    private static final int SHOOT_RECOVER_DELAY_TICKS = Math.round(4.0f);
    private static final int SHOOT_COOLDOWN_TICKS = Math.round(70.0f);

    @VisibleForTesting
    public BlitzeShoot() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.BREEZE_SHOOT_COOLDOWN, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.BREEZE_SHOOT_CHARGING, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.BREEZE_SHOOT_RECOVERING, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.BREEZE_SHOOT, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.BREEZE_JUMP_TARGET, (Object)MemoryStatus.VALUE_ABSENT), SHOOT_INITIAL_DELAY_TICKS + 1 + SHOOT_RECOVER_DELAY_TICKS);
    }

    protected boolean checkExtraStartConditions(ServerLevel p_310608_, BlitzeEntity p_310203_) {
        return p_310203_.getPose() != Pose.STANDING ? false : p_310203_.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).map(p_311282_ -> BlitzeShoot.isTargetWithinRange(p_310203_, p_311282_)).map(p_311912_ -> {
            if (!p_311912_.booleanValue()) {
                p_310203_.getBrain().eraseMemory(MemoryModuleType.BREEZE_SHOOT);
            }
            return p_311912_;
        }).orElse(false);
    }

    protected boolean canStillUse(ServerLevel p_309829_, BlitzeEntity p_312308_, long p_310493_) {
        return p_312308_.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET) && p_312308_.getBrain().hasMemoryValue(MemoryModuleType.BREEZE_SHOOT);
    }

    protected void start(ServerLevel p_312287_, BlitzeEntity p_310847_, long p_311799_) {
        p_310847_.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).ifPresent(p_312466_ -> p_310847_.setPose(Pose.SHOOTING));
        p_310847_.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_SHOOT_CHARGING, (Object)Unit.INSTANCE, (long)SHOOT_INITIAL_DELAY_TICKS);
        p_310847_.playSound((SoundEvent)TTSoundRegistry.BLITZE_SHOOT_PRE.get(), 1.0f, 1.0f);
    }

    protected void stop(ServerLevel p_312573_, BlitzeEntity p_309852_, long p_310968_) {
        if (p_309852_.getPose() == Pose.SHOOTING) {
            p_309852_.setPose(Pose.STANDING);
        }
        p_309852_.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_SHOOT_COOLDOWN, (Object)Unit.INSTANCE, (long)SHOOT_COOLDOWN_TICKS);
        p_309852_.getBrain().eraseMemory(MemoryModuleType.BREEZE_SHOOT);
    }

    protected void tick(ServerLevel p_312469_, BlitzeEntity p_309721_, long p_312577_) {
        Brain<BlitzeEntity> $$3 = p_309721_.getBrain();
        LivingEntity $$4 = $$3.getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
        if ($$4 != null) {
            p_309721_.lookAt(EntityAnchorArgument.Anchor.EYES, $$4.position());
            if (!$$3.getMemory(MemoryModuleType.BREEZE_SHOOT_CHARGING).isPresent() && !$$3.getMemory(MemoryModuleType.BREEZE_SHOOT_RECOVERING).isPresent()) {
                $$3.setMemoryWithExpiry(MemoryModuleType.BREEZE_SHOOT_RECOVERING, (Object)Unit.INSTANCE, (long)SHOOT_RECOVER_DELAY_TICKS);
                if (BlitzeShoot.isFacingTarget(p_309721_, $$4)) {
                    double $$5 = $$4.getX() - p_309721_.getX();
                    double $$6 = $$4.getY(0.3) - p_309721_.getY(0.5);
                    double $$7 = $$4.getZ() - p_309721_.getZ();
                    BlitzeEarthChargeEntity $$8 = new BlitzeEarthChargeEntity(p_309721_, (Level)p_312469_);
                    p_309721_.playSound((SoundEvent)TTSoundRegistry.BLITZE_SHOOT.get(), 1.5f, 1.0f);
                    $$8.shoot($$5, $$6, $$7, 0.7f, 5 - p_312469_.getDifficulty().getId() * 4);
                    p_312469_.addFreshEntity((Entity)$$8);
                }
            }
        }
    }

    @VisibleForTesting
    public static boolean isFacingTarget(BlitzeEntity p_311537_, LivingEntity p_310664_) {
        Vec3 $$3;
        Vec3 $$2 = p_311537_.getViewVector(1.0f);
        return $$2.dot($$3 = p_310664_.position().subtract(p_311537_.position()).normalize()) > 0.5;
    }

    private static boolean isTargetWithinRange(BlitzeEntity p_311470_, LivingEntity p_309385_) {
        double $$2 = p_311470_.position().distanceToSqr(p_309385_.position());
        return $$2 > 4.0 && $$2 < 256.0;
    }
}

