/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity.AI;

import com.belgie.tricky_trials.common.entity.GrunterEntity;
import com.belgie.tricky_trials.core.TTEntityRegistry;
import com.belgie.tricky_trials.core.TTSoundRegistry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.BecomePassiveIfMemoryPresent;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.schedule.Activity;

public class GrunterAI {
    public static final int REPELLENT_DETECTION_RANGE_HORIZONTAL = 8;
    public static final int REPELLENT_DETECTION_RANGE_VERTICAL = 4;
    private static final UniformInt RETREAT_DURATION = TimeUtil.rangeOfSeconds((int)5, (int)20);
    private static final int ATTACK_DURATION = 200;
    private static final int DESIRED_DISTANCE_FROM_PIGLIN_WHEN_IDLING = 8;
    private static final int DESIRED_DISTANCE_FROM_PIGLIN_WHEN_RETREATING = 15;
    private static final int ATTACK_INTERVAL = 40;
    private static final int BABY_ATTACK_INTERVAL = 15;
    private static final int REPELLENT_PACIFY_TIME = 200;
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.of((int)5, (int)16);
    private static final float SPEED_MULTIPLIER_WHEN_AVOIDING_REPELLENT = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_RETREATING = 1.3f;
    private static final float SPEED_MULTIPLIER_WHEN_MAKING_LOVE = 0.6f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.4f;
    private static final float SPEED_MULTIPLIER_WHEN_FOLLOWING_ADULT = 0.6f;

    public static Brain<?> makeBrain(Brain<GrunterEntity> p_34576_) {
        GrunterAI.initCoreActivity(p_34576_);
        GrunterAI.initIdleActivity(p_34576_);
        GrunterAI.initFightActivity(p_34576_);
        GrunterAI.initRetreatActivity(p_34576_);
        p_34576_.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        p_34576_.setDefaultActivity(Activity.IDLE);
        p_34576_.useDefaultActivity();
        return p_34576_;
    }

    private static void initCoreActivity(Brain<GrunterEntity> p_34592_) {
        p_34592_.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static void initIdleActivity(Brain<GrunterEntity> p_34602_) {
        p_34602_.addActivity(Activity.IDLE, 10, ImmutableList.of((Object)BecomePassiveIfMemoryPresent.create((MemoryModuleType)MemoryModuleType.NEAREST_REPELLENT, (int)200), (Object)new AnimalMakeLove(TTEntityRegistry.GRUNT.get(), 0.6f, 6), (Object)SetWalkTargetAwayFrom.pos((MemoryModuleType)MemoryModuleType.NEAREST_REPELLENT, (float)1.0f, (int)8, (boolean)true), (Object)StartAttacking.create(GrunterAI::findNearestValidAttackTarget), (Object)BehaviorBuilder.triggerIf(GrunterEntity::isAdult, (OneShot)SetWalkTargetAwayFrom.entity(TTEntityRegistry.NEAREST_VISIBLE_WARDEN.get(), (float)0.4f, (int)8, (boolean)false)), (Object)SetEntityLookTargetSometimes.create((float)8.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object)BabyFollowAdult.create((UniformInt)ADULT_FOLLOW_RANGE, (float)0.6f), GrunterAI.createIdleMovementBehaviors()));
    }

    private static void initFightActivity(Brain<GrunterEntity> p_34609_) {
        p_34609_.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, ImmutableList.of((Object)BecomePassiveIfMemoryPresent.create((MemoryModuleType)MemoryModuleType.NEAREST_REPELLENT, (int)200), (Object)new AnimalMakeLove(TTEntityRegistry.GRUNT.get(), 0.6f, 2), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.0f), (Object)BehaviorBuilder.triggerIf(GrunterEntity::isAdult, (OneShot)MeleeAttack.create((int)40)), (Object)BehaviorBuilder.triggerIf(AgeableMob::isBaby, (OneShot)MeleeAttack.create((int)15)), (Object)StopAttackingIfTargetInvalid.create(), (Object)EraseMemoryIf.create(GrunterAI::isBreeding, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET)), MemoryModuleType.ATTACK_TARGET);
    }

    private static void initRetreatActivity(Brain<GrunterEntity> p_34616_) {
        p_34616_.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.AVOID_TARGET, (float)1.0f, (int)15, (boolean)false), GrunterAI.createIdleMovementBehaviors(), (Object)SetEntityLookTargetSometimes.create((float)8.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object)EraseMemoryIf.create(GrunterAI::wantsToStopFleeing, (MemoryModuleType)MemoryModuleType.AVOID_TARGET)), MemoryModuleType.AVOID_TARGET);
    }

    private static RunOne<GrunterEntity> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)0.4f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)0.4f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void updateActivity(GrunterEntity p_34578_) {
        Brain<GrunterEntity> $$1 = p_34578_.getBrain();
        Activity $$2 = $$1.getActiveNonCoreActivity().orElse(null);
        $$1.setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.AVOID, (Object)Activity.IDLE));
        Activity $$3 = $$1.getActiveNonCoreActivity().orElse(null);
        if ($$2 != $$3) {
            Optional<SoundEvent> var10000 = GrunterAI.getSoundForCurrentActivity(p_34578_);
            Objects.requireNonNull(p_34578_);
        }
        p_34578_.setAggressive($$1.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
    }

    public static void onHitTarget(GrunterEntity p_34580_, LivingEntity p_34581_) {
        if (!p_34580_.isBaby()) {
            if (p_34581_.getType() == EntityType.WARDEN) {
                GrunterAI.setAvoidTarget(p_34580_, p_34581_);
                GrunterAI.broadcastRetreat(p_34580_, p_34581_);
            } else {
                GrunterAI.broadcastAttackTarget(p_34580_, p_34581_);
            }
        }
    }

    private static void broadcastRetreat(GrunterEntity p_34606_, LivingEntity p_34607_) {
        GrunterAI.getVisibleAdultHoglins(p_34606_).forEach(p_34590_ -> GrunterAI.retreatFromNearestTarget(p_34590_, p_34607_));
    }

    private static void retreatFromNearestTarget(GrunterEntity p_34613_, LivingEntity p_34614_) {
        LivingEntity $$2 = p_34614_;
        Brain<GrunterEntity> $$3 = p_34613_.getBrain();
        $$2 = BehaviorUtils.getNearestTarget((LivingEntity)p_34613_, (Optional)$$3.getMemory(MemoryModuleType.AVOID_TARGET), (LivingEntity)$$2);
        $$2 = BehaviorUtils.getNearestTarget((LivingEntity)p_34613_, (Optional)$$3.getMemory(MemoryModuleType.ATTACK_TARGET), (LivingEntity)$$2);
        GrunterAI.setAvoidTarget(p_34613_, $$2);
    }

    private static void setAvoidTarget(GrunterEntity p_34620_, LivingEntity p_34621_) {
        p_34620_.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        p_34620_.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        p_34620_.getBrain().setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, (Object)p_34621_, (long)RETREAT_DURATION.sample(p_34620_.level().random));
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(ServerLevel p_362473_, GrunterEntity p_34611_) {
        return !GrunterAI.isPacified(p_34611_) && !GrunterAI.isBreeding(p_34611_) ? p_34611_.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER) : Optional.empty();
    }

    public static boolean isPosNearNearestRepellent(GrunterEntity p_34586_, BlockPos p_34587_) {
        Optional $$2 = p_34586_.getBrain().getMemory(MemoryModuleType.NEAREST_REPELLENT);
        return $$2.isPresent() && ((BlockPos)$$2.get()).closerThan((Vec3i)p_34587_, 8.0);
    }

    private static boolean wantsToStopFleeing(GrunterEntity p_34618_) {
        return p_34618_.isAdult();
    }

    public static void wasHurtBy(ServerLevel p_362834_, GrunterEntity p_34596_, LivingEntity p_34597_) {
        Brain<GrunterEntity> $$2 = p_34596_.getBrain();
        $$2.eraseMemory(MemoryModuleType.PACIFIED);
        $$2.eraseMemory(MemoryModuleType.BREED_TARGET);
        if (p_34596_.isBaby()) {
            GrunterAI.retreatFromNearestTarget(p_34596_, p_34597_);
        } else {
            GrunterAI.maybeRetaliate(p_362834_, p_34596_, p_34597_);
        }
    }

    private static void maybeRetaliate(ServerLevel p_362858_, GrunterEntity p_34625_, LivingEntity p_34626_) {
        if (!(p_34625_.getBrain().isActive(Activity.AVOID) && p_34626_.getType() == EntityType.WARDEN || p_34626_.getType() == TTEntityRegistry.GRUNT.get() || BehaviorUtils.isOtherTargetMuchFurtherAwayThanCurrentAttackTarget((LivingEntity)p_34625_, (LivingEntity)p_34626_, (double)4.0) || !Sensor.isEntityAttackable((ServerLevel)p_362858_, (LivingEntity)p_34625_, (LivingEntity)p_34626_))) {
            GrunterAI.setAttackTarget(p_34625_, p_34626_);
            GrunterAI.broadcastAttackTarget(p_34625_, p_34626_);
        }
    }

    private static void setAttackTarget(GrunterEntity p_34630_, LivingEntity p_34631_) {
        Brain<GrunterEntity> $$2 = p_34630_.getBrain();
        $$2.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        $$2.eraseMemory(MemoryModuleType.BREED_TARGET);
        $$2.setMemoryWithExpiry(MemoryModuleType.ATTACK_TARGET, (Object)p_34631_, 200L);
    }

    private static void broadcastAttackTarget(GrunterEntity p_34635_, LivingEntity p_34636_) {
        GrunterAI.getVisibleAdultHoglins(p_34635_).forEach(p_34574_ -> GrunterAI.setAttackTargetIfCloserThanCurrent(p_34574_, p_34636_));
    }

    private static void setAttackTargetIfCloserThanCurrent(GrunterEntity p_34640_, LivingEntity p_34641_) {
        if (!GrunterAI.isPacified(p_34640_)) {
            Optional $$2 = p_34640_.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
            LivingEntity $$3 = BehaviorUtils.getNearestTarget((LivingEntity)p_34640_, (Optional)$$2, (LivingEntity)p_34641_);
            GrunterAI.setAttackTarget(p_34640_, $$3);
        }
    }

    public static Optional<SoundEvent> getSoundForCurrentActivity(GrunterEntity p_34594_) {
        return p_34594_.getBrain().getActiveNonCoreActivity().map(p_34600_ -> GrunterAI.getSoundForActivity(p_34594_, p_34600_));
    }

    private static SoundEvent getSoundForActivity(GrunterEntity p_34583_, Activity p_34584_) {
        return (SoundEvent)TTSoundRegistry.GRUNTER_IDLE.get();
    }

    private static List<GrunterEntity> getVisibleAdultHoglins(GrunterEntity p_34628_) {
        return (List)p_34628_.getBrain().getMemory(TTEntityRegistry.NEAREST_VISIBLE_ADULT_GRUNTERS.get()).orElse(ImmutableList.of());
    }

    private static boolean isNearRepellent(GrunterEntity p_34633_) {
        return p_34633_.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_REPELLENT);
    }

    private static boolean isBreeding(GrunterEntity p_34638_) {
        return p_34638_.getBrain().hasMemoryValue(MemoryModuleType.BREED_TARGET);
    }

    public static boolean isPacified(GrunterEntity p_34604_) {
        return p_34604_.getBrain().hasMemoryValue(MemoryModuleType.PACIFIED);
    }
}

