/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity.AI;

import com.belgie.tricky_trials.common.entity.HeavyCoreBoss;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class TrialKnightShootGoal
extends Goal {
    private final HeavyCoreBoss mob;
    @Nullable
    private LivingEntity target;
    private int attackTime = -1;
    private final double speedModifier;
    private int seeTime;
    private final int attackIntervalMin;
    private final int attackIntervalMax;
    private final float attackRadius;
    private final float attackRadiusSqr;

    public TrialKnightShootGoal(HeavyCoreBoss p_25768_, double p_25769_, int p_25770_, float p_25771_) {
        this(p_25768_, p_25769_, p_25770_, p_25770_, p_25771_);
    }

    public TrialKnightShootGoal(HeavyCoreBoss p_25773_, double p_25774_, int p_25775_, int p_25776_, float p_25777_) {
        if (!(p_25773_ instanceof LivingEntity)) {
            throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
        }
        this.mob = p_25773_;
        this.speedModifier = p_25774_;
        this.attackIntervalMin = p_25775_;
        this.attackIntervalMax = p_25776_;
        this.attackRadius = p_25777_;
        this.attackRadiusSqr = p_25777_ * p_25777_;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity $$0 = this.mob.getTarget();
        if ($$0 != null && $$0.isAlive()) {
            this.target = $$0;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.canUse() || this.target.isAlive() && !this.mob.getNavigation().isDone();
    }

    public void stop() {
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
        HeavyCoreBoss heavyCoreBoss = this.mob;
        if (heavyCoreBoss instanceof HeavyCoreBoss) {
            HeavyCoreBoss boss = heavyCoreBoss;
            boss.shoot.stop();
        }
    }

    public void start() {
        this.mob.level().broadcastEntityEvent((Entity)this.mob, (byte)65);
        this.mob.shootDelay = 50;
        super.start();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        double $$0 = this.mob.distanceToSqr(this.target.getX(), this.target.getY(), this.target.getZ());
        boolean $$1 = this.mob.getSensing().hasLineOfSight((Entity)this.target);
        this.seeTime = $$1 ? ++this.seeTime : 0;
        if (!($$0 > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
            this.mob.getNavigation().stop();
        } else {
            this.mob.getNavigation().moveTo((Entity)this.target, this.speedModifier);
        }
        this.mob.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
        if (--this.attackTime == 0) {
            if (!$$1) {
                return;
            }
            float $$2 = (float)Math.sqrt($$0) / this.attackRadius;
            this.attackTime = Mth.floor((float)($$2 * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.attackTime < 0) {
            this.attackTime = Mth.floor((double)Mth.lerp((double)(Math.sqrt($$0) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
        }
    }
}

