/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity.AI;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;

public class UseOffhandItemGoal<T extends Mob>
extends Goal {
    private final T mob;
    private final ItemStack item;
    private final Predicate<? super T> canUseSelector;
    @Nullable
    private final SoundEvent finishUsingSound;

    public UseOffhandItemGoal(T p_25972_, ItemStack p_25973_, @Nullable SoundEvent p_25974_, Predicate<? super T> p_25975_) {
        this.mob = p_25972_;
        this.item = p_25973_;
        this.finishUsingSound = p_25974_;
        this.canUseSelector = p_25975_;
    }

    public boolean canUse() {
        return this.canUseSelector.test(this.mob);
    }

    public boolean canContinueToUse() {
        return this.mob.isUsingItem();
    }

    public void start() {
        this.mob.setItemSlot(EquipmentSlot.OFFHAND, this.item.copy());
        this.mob.startUsingItem(InteractionHand.OFF_HAND);
    }

    public void stop() {
        this.mob.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
        this.mob.heal(4.0f);
        if (this.finishUsingSound != null) {
            this.mob.playSound(this.finishUsingSound, 1.0f, this.mob.getRandom().nextFloat() * 0.2f + 0.9f);
        }
    }
}

