/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity;

import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.windcharge.AbstractWindCharge;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SimpleExplosionDamageCalculator;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class AbstractFireChargeEntity
extends AbstractHurtingProjectile
implements ItemSupplier {
    public static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new SimpleExplosionDamageCalculator(true, false, Optional.empty(), BuiltInRegistries.BLOCK.get(BlockTags.BLOCKS_WIND_CHARGE_EXPLOSIONS).map(Function.identity()));
    public static final double JUMP_SCALE = 0.25;

    public AbstractFireChargeEntity(EntityType<? extends AbstractFireChargeEntity> p_328415_, Level p_334141_) {
        super(p_328415_, p_334141_);
        this.accelerationPower = 0.0;
    }

    public AbstractFireChargeEntity(EntityType<? extends AbstractFireChargeEntity> p_328691_, Level p_334245_, Entity p_335850_, double p_331511_, double p_328582_, double p_333875_) {
        super(p_328691_, p_331511_, p_328582_, p_333875_, p_334245_);
        this.setOwner(p_335850_);
        this.accelerationPower = 0.0;
    }

    AbstractFireChargeEntity(EntityType<? extends AbstractFireChargeEntity> p_334984_, double p_330891_, double p_328515_, double p_329380_, Vec3 p_342847_, Level p_329917_) {
        super(p_334984_, p_330891_, p_328515_, p_329380_, p_342847_, p_329917_);
        this.accelerationPower = 0.0;
    }

    protected AABB makeBoundingBox(Vec3 p_375941_) {
        float $$1 = this.getType().getDimensions().width() / 2.0f;
        float $$2 = this.getType().getDimensions().height();
        float $$3 = 0.15f;
        return new AABB(p_375941_.x - (double)$$1, p_375941_.y - (double)0.15f, p_375941_.z - (double)$$1, p_375941_.x + (double)$$1, p_375941_.y - (double)0.15f + (double)$$2, p_375941_.z + (double)$$1);
    }

    public boolean canCollideWith(Entity p_328571_) {
        return p_328571_ instanceof AbstractWindCharge ? false : super.canCollideWith(p_328571_);
    }

    protected boolean canHitEntity(Entity p_333197_) {
        if (p_333197_ instanceof AbstractWindCharge) {
            return false;
        }
        return p_333197_.getType() == EntityType.END_CRYSTAL ? false : super.canHitEntity(p_333197_);
    }

    protected void onHitEntity(EntityHitResult p_37386_) {
        super.onHitEntity(p_37386_);
        Level var3 = this.level();
        if (var3 instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)var3;
            Entity entity1 = p_37386_.getEntity();
            Entity $$4 = this.getOwner();
            int $$5 = entity1.getRemainingFireTicks();
            entity1.igniteForSeconds(5.0f);
            DamageSource $$6 = this.damageSources().explosion((Entity)this, $$4);
            if (!entity1.hurtServer(serverlevel, $$6, 5.0f)) {
                entity1.setRemainingFireTicks($$5);
            } else {
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)entity1, (DamageSource)$$6);
            }
        }
    }

    public void push(double p_328125_, double p_336037_, double p_328448_) {
    }

    protected void onHitBlock(BlockHitResult p_37384_) {
        Entity entity;
        Level level;
        super.onHitBlock(p_37384_);
        if (!this.level().isClientSide && (level = (entity = this.getOwner()).level()) instanceof ServerLevel) {
            BlockPos blockpos;
            ServerLevel sl = (ServerLevel)level;
            if ((!(entity instanceof Mob) || EventHooks.canEntityGrief((ServerLevel)sl, (Entity)entity)) && BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)(blockpos = p_37384_.getBlockPos().relative(p_37384_.getDirection())), (Direction)p_37384_.getDirection())) {
                level.playSound(entity, blockpos, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
                BlockState $$6 = BaseFireBlock.getState((BlockGetter)level, (BlockPos)blockpos);
                level.setBlock(blockpos, $$6, 11);
                level.gameEvent(entity, (Holder)GameEvent.BLOCK_PLACE, blockpos);
            }
        }
    }

    protected void onHit(HitResult p_328815_) {
        super.onHit(p_328815_);
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    protected boolean shouldBurn() {
        return false;
    }

    public ItemStack getItem() {
        return ItemStack.EMPTY;
    }

    protected float getInertia() {
        return 1.0f;
    }

    protected float getLiquidInertia() {
        return 0.0f;
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        return null;
    }

    public void tick() {
        if (!this.level().isClientSide && this.getBlockY() > this.level().getMaxY() + 30) {
            this.discard();
        } else {
            super.tick();
        }
    }
}

