/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.windcharge.AbstractWindCharge;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractHeavyCoreBulletEntity
extends AbstractHurtingProjectile
implements ItemSupplier {
    public static final WindChargeDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new WindChargeDamageCalculator();

    public AbstractHeavyCoreBulletEntity(EntityType<? extends AbstractHeavyCoreBulletEntity> p_328415_, Level p_334141_) {
        super(p_328415_, p_334141_);
    }

    public AbstractHeavyCoreBulletEntity(EntityType<? extends AbstractHeavyCoreBulletEntity> p_328691_, Level p_334245_, Entity p_335850_, double p_331511_, double p_328582_, double p_333875_) {
        super(p_328691_, p_331511_, p_328582_, p_333875_, p_334245_);
        this.setOwner(p_335850_);
    }

    AbstractHeavyCoreBulletEntity(EntityType<? extends AbstractHeavyCoreBulletEntity> p_334984_, double p_330891_, double p_328515_, double p_329380_, Vec3 vec, Level p_329917_) {
        super(p_334984_, p_330891_, p_328515_, p_329380_, vec, p_329917_);
    }

    protected AABB makeBoundingBox(Vec3 p_377233_) {
        float $$0 = this.getType().getDimensions().width() / 2.0f;
        float $$1 = this.getType().getDimensions().height();
        float $$2 = 0.15f;
        return new AABB(this.position().x - (double)$$0, this.position().y - (double)0.15f, this.position().z - (double)$$0, this.position().x + (double)$$0, this.position().y - (double)0.15f + (double)$$1, this.position().z + (double)$$0);
    }

    public boolean canCollideWith(Entity p_328571_) {
        return p_328571_ instanceof AbstractWindCharge ? false : super.canCollideWith(p_328571_);
    }

    protected boolean canHitEntity(Entity p_333197_) {
        if (p_333197_ instanceof AbstractWindCharge) {
            return false;
        }
        return p_333197_.getType() == EntityType.END_CRYSTAL ? false : super.canHitEntity(p_333197_);
    }

    protected void onHitEntity(EntityHitResult p_328561_) {
        super.onHitEntity(p_328561_);
        if (!this.level().isClientSide) {
            Entity $$1 = p_328561_.getEntity();
            $$1.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 10.0f);
            if ($$1 instanceof Player) {
                Player player = (Player)$$1;
                if (this.level().getRandom().nextFloat() < 0.8f) {
                    player.getCooldowns().addCooldown(Items.SHIELD.getDefaultInstance(), 120);
                }
            }
        }
    }

    public void push(double p_328125_, double p_336037_, double p_328448_) {
    }

    protected abstract void explode();

    protected void onHitBlock(BlockHitResult p_330277_) {
        super.onHitBlock(p_330277_);
        if (!this.level().isClientSide) {
            this.explode();
            this.discard();
        }
    }

    protected void onHit(HitResult p_328815_) {
        super.onHit(p_328815_);
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    protected boolean shouldBurn() {
        return false;
    }

    public ItemStack getItem() {
        return new ItemStack((ItemLike)Items.HEAVY_CORE);
    }

    protected float getInertia() {
        return 1.0f;
    }

    protected float getLiquidInertia() {
        return this.getInertia();
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        return null;
    }

    public void tick() {
        if (!this.level().isClientSide && this.getBlockY() > this.level().getMaxY() + 30) {
            this.explode();
            this.discard();
        } else {
            super.tick();
        }
    }

    public static class WindChargeDamageCalculator
    extends ExplosionDamageCalculator {
        public boolean shouldDamageEntity(Explosion p_329716_, Entity p_327996_) {
            return false;
        }

        public Optional<Float> getBlockExplosionResistance(Explosion p_335115_, BlockGetter p_329011_, BlockPos p_330601_, BlockState p_331417_, FluidState p_330040_) {
            return p_331417_.is(BlockTags.BLOCKS_WIND_CHARGE_EXPLOSIONS) ? Optional.of(Float.valueOf(3600000.0f)) : Optional.empty();
        }
    }
}

