/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity;

import com.belgie.tricky_trials.common.entity.AI.BlitzeAI;
import com.belgie.tricky_trials.core.TTSoundRegistry;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class BlitzeEntity
extends Monster {
    private static final int SLIDE_PARTICLES_AMOUNT = 20;
    private static final int IDLE_PARTICLES_AMOUNT = 1;
    private static final int JUMP_DUST_PARTICLES_AMOUNT = 20;
    private static final int JUMP_TRAIL_PARTICLES_AMOUNT = 3;
    private static final int JUMP_TRAIL_DURATION_TICKS = 5;
    private static final int JUMP_CIRCLE_DISTANCE_Y = 10;
    private static final float FALL_DISTANCE_SOUND_TRIGGER_THRESHOLD = 3.0f;
    private static final int WHIRL_SOUND_FREQUENCY_MIN = 1;
    private static final int WHIRL_SOUND_FREQUENCY_MAX = 80;
    public AnimationState idle = new AnimationState();
    public AnimationState slide = new AnimationState();
    public AnimationState slideBack = new AnimationState();
    public AnimationState longJump = new AnimationState();
    public AnimationState shoot = new AnimationState();
    public AnimationState inhale = new AnimationState();
    private int jumpTrailStartedTick = 0;
    private int soundTick = 0;
    private static final ProjectileDeflection PROJECTILE_DEFLECTION = (p_331050_, p_333637_, p_328921_) -> {
        p_333637_.level().playLocalSound(p_333637_, (SoundEvent)TTSoundRegistry.BLITZE_DEFLECT.get(), p_333637_.getSoundSource(), 1.0f, 1.0f);
        ProjectileDeflection.REVERSE.deflect(p_331050_, p_333637_, p_328921_);
    };

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.63f).add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    public BlitzeEntity(EntityType<? extends Monster> p_310338_, Level p_309512_) {
        super(p_310338_, p_309512_);
        this.setPathfindingMalus(PathType.DANGER_TRAPDOOR, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.xpReward = 10;
    }

    protected Brain<?> makeBrain(Dynamic<?> p_311857_) {
        return BlitzeAI.makeBrain((Brain<BlitzeEntity>)this.brainProvider().makeBrain(p_311857_));
    }

    public Brain<BlitzeEntity> getBrain() {
        return super.getBrain();
    }

    protected Brain.Provider<BlitzeEntity> brainProvider() {
        return Brain.provider(BlitzeAI.MEMORY_TYPES, BlitzeAI.SENSOR_TYPES);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_309800_) {
        if (this.level().isClientSide() && DATA_POSE.equals(p_309800_)) {
            this.resetAnimations();
            Pose $$1 = this.getPose();
            switch ($$1) {
                case SHOOTING: {
                    this.shoot.startIfStopped(this.tickCount);
                    break;
                }
                case INHALING: {
                    this.longJump.startIfStopped(this.tickCount);
                    break;
                }
                case SLIDING: {
                    this.slide.startIfStopped(this.tickCount);
                }
            }
        }
        super.onSyncedDataUpdated(p_309800_);
    }

    private void resetAnimations() {
        this.shoot.stop();
        this.idle.stop();
        this.inhale.stop();
        this.longJump.stop();
        this.slide.stop();
        this.slideBack.stop();
    }

    public void tick() {
        Pose $$0 = this.getPose();
        switch ($$0) {
            case SHOOTING: 
            case INHALING: 
            case STANDING: {
                this.resetJumpTrail().emitGroundParticles(1 + this.getRandom().nextInt(1));
                break;
            }
            case SLIDING: {
                this.emitGroundParticles(20);
                break;
            }
            case LONG_JUMPING: {
                this.emitJumpTrailParticles();
            }
        }
        if ($$0 != Pose.SLIDING && this.slide.isStarted()) {
            this.slideBack.start(this.tickCount);
            this.slide.stop();
        }
        int n = this.soundTick = this.soundTick == 0 ? this.random.nextIntBetweenInclusive(1, 80) : this.soundTick - 1;
        if (this.soundTick == 0) {
            this.playWhirlSound();
        }
        if (this.level().isClientSide) {
            this.slide.animateWhen(!this.shoot.isStarted() && !this.longJump.isStarted() && !this.slideBack.isStarted(), this.tickCount);
        }
        super.tick();
    }

    public BlitzeEntity resetJumpTrail() {
        this.jumpTrailStartedTick = 0;
        return this;
    }

    public void emitJumpTrailParticles() {
        if (++this.jumpTrailStartedTick <= 5) {
            BlockState $$0 = !this.getInBlockState().isAir() ? this.getInBlockState() : this.getBlockStateOn();
            Vec3 $$1 = this.getDeltaMovement();
            Vec3 $$2 = this.position().add($$1).add(0.0, (double)0.1f, 0.0);
            for (int $$3 = 0; $$3 < 3; ++$$3) {
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, $$0), $$2.x, $$2.y, $$2.z, 0.0, 0.0, 0.0);
            }
        }
    }

    public void emitGroundParticles(int p_310885_) {
        if (!this.isPassenger()) {
            BlockState $$3;
            Vec3 $$1 = this.getBoundingBox().getCenter();
            Vec3 $$2 = new Vec3($$1.x, this.position().y, $$1.z);
            BlockState blockState = $$3 = !this.getInBlockState().isAir() ? this.getInBlockState() : this.getBlockStateOn();
            if ($$3.getRenderShape() != RenderShape.INVISIBLE) {
                for (int $$4 = 0; $$4 < p_310885_; ++$$4) {
                    this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, $$3), $$2.x, $$2.y, $$2.z, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void playAmbientSound() {
        if (this.getTarget() == null || !this.onGround()) {
            this.level().playLocalSound((Entity)this, this.getAmbientSound(), this.getSoundSource(), 1.0f, 1.0f);
        }
    }

    public void playWhirlSound() {
        float $$0 = 0.7f + 0.4f * this.random.nextFloat();
        float $$1 = 0.8f + 0.2f * this.random.nextFloat();
        this.level().playLocalSound((Entity)this, this.getAmbientSound(), this.getSoundSource(), $$1, $$0);
    }

    public ProjectileDeflection deflection(Projectile p_335920_) {
        return p_335920_.getType() != EntityType.BREEZE_WIND_CHARGE && p_335920_.getType() != EntityType.WIND_CHARGE ? PROJECTILE_DEFLECTION : ProjectileDeflection.NONE;
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TTSoundRegistry.BLITZE_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_311322_) {
        return (SoundEvent)TTSoundRegistry.BLITZE_HURT.get();
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TTSoundRegistry.BLITZE_AMBIENT.get();
    }

    public Optional<LivingEntity> getHurtBy() {
        return this.getBrain().getMemory(MemoryModuleType.HURT_BY).map(DamageSource::getEntity).filter(p_333499_ -> p_333499_ instanceof LivingEntity).map(p_332795_ -> (LivingEntity)p_332795_);
    }

    public boolean withinInnerCircleRange(Vec3 p_311473_) {
        Vec3 $$1 = this.blockPosition().getCenter();
        return p_311473_.closerThan($$1, 4.0, 10.0);
    }

    protected void customServerAiStep(ServerLevel p_363493_) {
        ProfilerFiller $$1 = Profiler.get();
        $$1.push("blitzeBrain");
        this.getBrain().tick(p_363493_, (LivingEntity)this);
        $$1.pop();
        super.customServerAiStep(p_363493_);
        BlitzeAI.updateActivity(this);
    }

    public boolean canAttackType(EntityType<?> p_310232_) {
        return p_310232_ == EntityType.PLAYER || p_310232_ == EntityType.IRON_GOLEM;
    }

    public int getMaxHeadYRot() {
        return 30;
    }

    public int getHeadRotSpeed() {
        return 25;
    }

    public double getSnoutYPosition() {
        return this.getEyeY() - 0.4;
    }

    public boolean isInvulnerableTo(ServerLevel p_361436_, DamageSource p_345519_) {
        return p_345519_.getEntity() instanceof BlitzeEntity || super.isInvulnerableTo(p_361436_, p_345519_);
    }

    public double getFluidJumpThreshold() {
        return this.getEyeHeight();
    }

    public boolean causeFallDamage(float p_310250_, float p_310041_, DamageSource p_311921_) {
        if (p_310250_ > 3.0f) {
            this.playSound(SoundEvents.STONE_FALL, 1.0f, 1.0f);
        }
        return super.causeFallDamage(p_310250_, p_310041_, p_311921_);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.getTargetFromBrain();
    }
}

