/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity;

import com.belgie.tricky_trials.core.TTSoundRegistry;
import com.belgie.tricky_trials.core.TTTagsRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.EventHooks;

public class BoulderingZombieEntity
extends Zombie {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(BoulderingZombieEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final ResourceLocation SPEED_MODIFIER_BABY_ID = ResourceLocation.withDefaultNamespace((String)"baby");
    private static final AttributeModifier SPEED_MODIFIER_BABY = new AttributeModifier(SPEED_MODIFIER_BABY_ID, 0.05, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final EntityDataAccessor<Boolean> DATA_BABY_ID = SynchedEntityData.defineId(BoulderingZombieEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public BoulderingZombieEntity(EntityType<? extends BoulderingZombieEntity> p_32889_, Level p_32890_) {
        super(p_32889_, p_32890_);
    }

    public static boolean checkHuskSpawnRules(EntityType<BoulderingZombieEntity> p_218997_, ServerLevelAccessor p_218998_, EntitySpawnReason p_218999_, BlockPos p_219000_, RandomSource p_219001_) {
        return BoulderingZombieEntity.checkMonsterSpawnRules(p_218997_, (ServerLevelAccessor)p_218998_, (EntitySpawnReason)p_218999_, (BlockPos)p_219000_, (RandomSource)p_219001_) && (EntitySpawnReason.isSpawner((EntitySpawnReason)p_218999_) || p_218998_.canSeeSky(p_219000_));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, 0.3300000041723251).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.ARMOR, 2.0).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_34307_) {
        if (DATA_BABY_ID.equals(p_34307_)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(p_34307_);
    }

    public boolean isBaby() {
        return (Boolean)this.getEntityData().get(DATA_BABY_ID);
    }

    public void setBaby(boolean p_34309_) {
        this.getEntityData().set(DATA_BABY_ID, (Object)p_34309_);
        if (this.level() != null && !this.level().isClientSide) {
            AttributeInstance attributeinstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
            attributeinstance.removeModifier(SPEED_MODIFIER_BABY_ID);
            if (p_34309_) {
                attributeinstance.addTransientModifier(SPEED_MODIFIER_BABY);
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_334759_) {
        super.defineSynchedData(p_334759_);
        p_334759_.define(DATA_FLAGS_ID, (Object)0);
        p_334759_.define(DATA_BABY_ID, (Object)false);
    }

    public boolean canAttackType(EntityType<?> p_21399_) {
        return !p_21399_.is(TTTagsRegistry.TRICKY_TRIALS_MOBS);
    }

    protected int calculateFallDamage(float p_149389_, float p_149390_) {
        return super.calculateFallDamage(p_149389_, p_149390_) - 10;
    }

    public boolean onClimbable() {
        return this.isClimbing();
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.setClimbing(this.horizontalCollision);
        }
        if (this.isClimbing() && this.random.nextInt(1000) < 80) {
            this.playSound((SoundEvent)TTSoundRegistry.BOULDERING_ZOMBIE_CLIMB.get(), 1.0f, 1.0f);
        }
    }

    public boolean isClimbing() {
        return ((Byte)this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean p_33820_) {
        byte b0 = (Byte)this.entityData.get(DATA_FLAGS_ID);
        b0 = p_33820_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.entityData.set(DATA_FLAGS_ID, (Object)b0);
    }

    protected PathNavigation createNavigation(Level p_33802_) {
        return new WallClimberNavigation((Mob)this, p_33802_);
    }

    protected boolean isSunSensitive() {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TTSoundRegistry.BOULDERING_ZOMBIE_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_32903_) {
        return (SoundEvent)TTSoundRegistry.BOULDERING_ZOMBIE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TTSoundRegistry.BOULDERING_ZOMBIE_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)TTSoundRegistry.BOULDERING_ZOMBIE_STEP.get();
    }

    protected boolean convertsInWater() {
        return true;
    }

    protected void doUnderWaterConversion() {
        if (EventHooks.canLivingConvert((LivingEntity)this, (EntityType)EntityType.DROWNED, timer -> {
            this.conversionTime = timer;
        })) {
            this.convertToZombieType(EntityType.DROWNED);
            if (!this.isSilent()) {
                this.level().levelEvent((Player)null, 1041, this.blockPosition(), 0);
            }
        }
    }

    protected ItemStack getSkull() {
        return ItemStack.EMPTY;
    }
}

