/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity;

import com.belgie.tricky_trials.common.entity.BubzeWaterChargeEntity;
import com.belgie.tricky_trials.core.TTSoundRegistry;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class BubzeEntity
extends Monster {
    private static final EntityDataAccessor<Boolean> DATA_ID_MOVING = SynchedEntityData.defineId(BubzeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_ID_ATTACK_TARGET = SynchedEntityData.defineId(BubzeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    @Nullable
    private LivingEntity clientSideCachedAttackTarget;
    private int clientSideAttackTime;
    private boolean clientSideTouchedGround;
    @Nullable
    protected RandomStrollGoal randomStrollGoal;
    public AnimationState swim = new AnimationState();
    public AnimationState riptide = new AnimationState();
    public AnimationState shoot = new AnimationState();
    public int AttackDelay = 0;

    public BubzeEntity(EntityType<? extends BubzeEntity> p_32810_, Level p_32811_) {
        super(p_32810_, p_32811_);
        this.xpReward = 10;
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new GuardianMoveControl(this);
    }

    protected void registerGoals() {
        MoveTowardsRestrictionGoal $$0 = new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0);
        this.randomStrollGoal = new RandomStrollGoal((PathfinderMob)this, 1.0, 80);
        this.goalSelector.addGoal(4, (Goal)new GuardianAttackGoal(this));
        this.goalSelector.addGoal(5, (Goal)$$0);
        this.goalSelector.addGoal(7, (Goal)this.randomStrollGoal);
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, BubzeEntity.class, 12.0f, 0.01f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.randomStrollGoal.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        $$0.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, (TargetingConditions.Selector)new GuardianAttackSelector(this)));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MAX_HEALTH, 30.0);
    }

    protected PathNavigation createNavigation(Level p_32846_) {
        return new WaterBoundPathNavigation((Mob)this, p_32846_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_332801_) {
        super.defineSynchedData(p_332801_);
        p_332801_.define(DATA_ID_MOVING, (Object)false);
        p_332801_.define(DATA_ID_ATTACK_TARGET, (Object)0);
    }

    public boolean isMoving() {
        return (Boolean)this.entityData.get(DATA_ID_MOVING);
    }

    void setMoving(boolean p_32862_) {
        this.entityData.set(DATA_ID_MOVING, (Object)p_32862_);
    }

    public int getAttackDuration() {
        return 10;
    }

    void setActiveAttackTarget(int p_32818_) {
        this.entityData.set(DATA_ID_ATTACK_TARGET, (Object)p_32818_);
    }

    public boolean hasActiveAttackTarget() {
        return (Integer)this.entityData.get(DATA_ID_ATTACK_TARGET) != 0;
    }

    @Nullable
    public LivingEntity getActiveAttackTarget() {
        if (!this.hasActiveAttackTarget()) {
            return null;
        }
        if (this.level().isClientSide) {
            if (this.clientSideCachedAttackTarget != null) {
                return this.clientSideCachedAttackTarget;
            }
            Entity $$0 = this.level().getEntity(((Integer)this.entityData.get(DATA_ID_ATTACK_TARGET)).intValue());
            if ($$0 instanceof LivingEntity) {
                this.clientSideCachedAttackTarget = (LivingEntity)$$0;
                return this.clientSideCachedAttackTarget;
            }
            return null;
        }
        return this.getTarget();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_32834_) {
        super.onSyncedDataUpdated(p_32834_);
        if (DATA_ID_ATTACK_TARGET.equals(p_32834_)) {
            this.clientSideAttackTime = 0;
            this.clientSideCachedAttackTarget = null;
        }
    }

    public int getAmbientSoundInterval() {
        return 160;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TTSoundRegistry.BUBBLZE_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_32852_) {
        return this.isInWater() ? (SoundEvent)TTSoundRegistry.BUBBLZE_HURT.get() : (SoundEvent)TTSoundRegistry.BUBBLZE_LAND_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return this.isInWater() ? (SoundEvent)TTSoundRegistry.BUBBLZE_DEATH.get() : (SoundEvent)TTSoundRegistry.BUBBLZE_LAND_DEATH.get();
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    public float getWalkTargetValue(BlockPos p_32831_, LevelReader p_32832_) {
        return p_32832_.getFluidState(p_32831_).is(FluidTags.WATER) ? 10.0f + p_32832_.getPathfindingCostFromLightLevels(p_32831_) : super.getWalkTargetValue(p_32831_, p_32832_);
    }

    public void handleEntityEvent(byte p_21375_) {
        if (p_21375_ == 4) {
            this.shoot.start(this.tickCount);
        } else if (p_21375_ == 5) {
            this.shoot.stop();
        }
        super.handleEntityEvent(p_21375_);
    }

    public void tick() {
        if (this.level().isClientSide) {
            this.swim.animateWhen(!this.shoot.isStarted(), this.tickCount);
        }
        if (this.AttackDelay <= 55) {
            ++this.AttackDelay;
        }
        super.tick();
    }

    public void aiStep() {
        if (this.isAlive()) {
            if (this.level().isClientSide) {
                for (int $$0 = 0; $$0 < 2; ++$$0) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
                }
                if (!this.isInWater()) {
                    Vec3 $$1 = this.getDeltaMovement();
                    boolean bl = this.clientSideTouchedGround = $$1.y < 0.0 && this.level().loadedAndEntityCanStandOn(this.blockPosition().below(), (Entity)this);
                }
                if (this.isMoving() && this.isInWater()) {
                    Vec3 $$1 = this.getViewVector(0.0f);
                    for (int $$2 = 0; $$2 < 2; ++$$2) {
                        this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getRandomX(0.5) - $$1.x * 1.5, this.getRandomY() - $$1.y * 1.5, this.getRandomZ(0.5) - $$1.z * 1.5, 0.0, 0.0, 0.0);
                    }
                }
                if (this.hasActiveAttackTarget()) {
                    LivingEntity $$3;
                    if (this.clientSideAttackTime < this.getAttackDuration()) {
                        ++this.clientSideAttackTime;
                    }
                    if (($$3 = this.getActiveAttackTarget()) != null) {
                        this.getLookControl().setLookAt((Entity)$$3, 90.0f, 90.0f);
                        this.getLookControl().tick();
                    }
                }
            }
            if (this.isInWaterOrBubble()) {
                this.setAirSupply(300);
            } else if (this.onGround()) {
                this.setDeltaMovement(this.getDeltaMovement().add((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.4f), 0.5, (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.4f)));
                this.setYRot(this.random.nextFloat() * 360.0f);
                this.setOnGround(false);
                this.hasImpulse = true;
            }
            if (this.hasActiveAttackTarget()) {
                this.setYRot(this.yHeadRot);
            }
        }
        super.aiStep();
    }

    public double getSnoutYPosition() {
        return this.getEyeY() - 0.4;
    }

    public float getClientSideAttackTime() {
        return this.clientSideAttackTime;
    }

    public boolean checkSpawnObstruction(LevelReader p_32829_) {
        return p_32829_.isUnobstructed((Entity)this);
    }

    public static boolean checkGuardianSpawnRules(EntityType<? extends BubzeEntity> p_218991_, LevelAccessor p_218992_, EntitySpawnReason p_218993_, BlockPos p_218994_, RandomSource p_218995_) {
        return p_218992_.getDifficulty() != Difficulty.PEACEFUL && (EntitySpawnReason.isSpawner((EntitySpawnReason)p_218993_) || p_218992_.getFluidState(p_218994_).is(FluidTags.WATER)) && p_218992_.getFluidState(p_218994_.below()).is(FluidTags.WATER);
    }

    public boolean hurtServer(ServerLevel sl, DamageSource p_32820_, float p_32821_) {
        if (this.level().isClientSide) {
            return false;
        }
        if (this.randomStrollGoal != null) {
            this.randomStrollGoal.trigger();
        }
        return super.hurtServer(sl, p_32820_, p_32821_);
    }

    public int getMaxHeadXRot() {
        return 180;
    }

    public void travel(Vec3 p_32858_) {
        if (this.isControlledByLocalInstance() && this.isInWater()) {
            this.moveRelative(0.1f, p_32858_);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (!this.isMoving() && this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(p_32858_);
        }
    }

    private static class GuardianMoveControl
    extends MoveControl {
        private final BubzeEntity guardian;

        public GuardianMoveControl(BubzeEntity p_32886_) {
            super((Mob)p_32886_);
            this.guardian = p_32886_;
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO && !this.guardian.getNavigation().isDone()) {
                Vec3 $$0 = new Vec3(this.wantedX - this.guardian.getX(), this.wantedY - this.guardian.getY(), this.wantedZ - this.guardian.getZ());
                double $$1 = $$0.length();
                double $$2 = $$0.x / $$1;
                double $$3 = $$0.y / $$1;
                double $$4 = $$0.z / $$1;
                float $$5 = (float)(Mth.atan2((double)$$0.z, (double)$$0.x) * 57.2957763671875) - 90.0f;
                this.guardian.setYRot(this.rotlerp(this.guardian.getYRot(), $$5, 90.0f));
                this.guardian.yBodyRot = this.guardian.getYRot();
                float $$6 = (float)(this.speedModifier * this.guardian.getAttributeValue(Attributes.MOVEMENT_SPEED));
                float $$7 = Mth.lerp((float)0.125f, (float)this.guardian.getSpeed(), (float)$$6);
                this.guardian.setSpeed($$7);
                double $$8 = Math.sin((double)(this.guardian.tickCount + this.guardian.getId()) * 0.5) * 0.05;
                double $$9 = Math.cos(this.guardian.getYRot() * ((float)Math.PI / 180));
                double $$10 = Math.sin(this.guardian.getYRot() * ((float)Math.PI / 180));
                double $$11 = Math.sin((double)(this.guardian.tickCount + this.guardian.getId()) * 0.75) * 0.05;
                this.guardian.setDeltaMovement(this.guardian.getDeltaMovement().add($$8 * $$9, $$11 * ($$10 + $$9) * 0.25 + (double)$$7 * $$3 * 0.1, $$8 * $$10));
                LookControl $$12 = this.guardian.getLookControl();
                double $$13 = this.guardian.getX() + $$2 * 2.0;
                double $$14 = this.guardian.getEyeY() + $$3 / $$1;
                double $$15 = this.guardian.getZ() + $$4 * 2.0;
                double $$16 = $$12.getWantedX();
                double $$17 = $$12.getWantedY();
                double $$18 = $$12.getWantedZ();
                if (!$$12.isLookingAtTarget()) {
                    $$16 = $$13;
                    $$17 = $$14;
                    $$18 = $$15;
                }
                this.guardian.getLookControl().setLookAt(Mth.lerp((double)0.125, (double)$$16, (double)$$13), Mth.lerp((double)0.125, (double)$$17, (double)$$14), Mth.lerp((double)0.125, (double)$$18, (double)$$15), 10.0f, 40.0f);
                this.guardian.setMoving(true);
            } else {
                this.guardian.setSpeed(0.0f);
                this.guardian.setMoving(false);
            }
        }
    }

    static class GuardianAttackGoal
    extends Goal {
        private final BubzeEntity guardian;
        private int attackTime;
        private final boolean elder;

        public GuardianAttackGoal(BubzeEntity p_32871_) {
            this.guardian = p_32871_;
            this.elder = p_32871_ instanceof BubzeEntity;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity $$0 = this.guardian.getTarget();
            return $$0 != null && $$0.isAlive() && this.guardian.AttackDelay >= 50;
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && (this.elder || this.guardian.getTarget() != null && this.guardian.distanceToSqr((Entity)this.guardian.getTarget()) > 9.0);
        }

        public void start() {
            this.attackTime = -10;
            this.guardian.getNavigation().stop();
            LivingEntity $$0 = this.guardian.getTarget();
            if ($$0 != null) {
                this.guardian.getLookControl().setLookAt((Entity)$$0, 90.0f, 90.0f);
            }
            this.guardian.hasImpulse = true;
        }

        public void stop() {
            this.guardian.setActiveAttackTarget(0);
            this.guardian.setTarget(null);
            this.guardian.AttackDelay = 0;
            this.guardian.randomStrollGoal.trigger();
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity $$0 = this.guardian.getTarget();
            if ($$0 != null) {
                this.guardian.getNavigation().stop();
                this.guardian.getLookControl().setLookAt((Entity)$$0, 90.0f, 90.0f);
                if (!this.guardian.hasLineOfSight((Entity)$$0)) {
                    this.guardian.setTarget(null);
                } else {
                    ++this.attackTime;
                    if (this.attackTime == 0) {
                        this.guardian.setActiveAttackTarget($$0.getId());
                        this.guardian.level().broadcastEntityEvent((Entity)this.guardian, (byte)4);
                        this.guardian.playSound((SoundEvent)TTSoundRegistry.BUBBLZE_SHOOT_PRE.get(), 1.0f, 1.0f / (this.guardian.getRandom().nextFloat() * 0.4f + 0.8f));
                    } else if (this.attackTime >= this.guardian.getAttackDuration()) {
                        BubzeWaterChargeEntity $$2 = new BubzeWaterChargeEntity(this.guardian, this.guardian.level());
                        double $$3 = $$0.getX() - this.guardian.getX();
                        double $$4 = $$0.getY(0.3333333333333333) - $$2.getY();
                        double $$5 = $$0.getZ() - this.guardian.getZ();
                        double $$6 = Math.sqrt($$3 * $$3 + $$5 * $$5);
                        $$2.shoot($$3, $$4 + $$6 * (double)0.2f, $$5, 1.6f, 14 - this.guardian.level().getDifficulty().getId() * 4);
                        this.guardian.playSound((SoundEvent)TTSoundRegistry.BUBBLZE_SHOOT.get(), 1.0f, 1.0f / (this.guardian.getRandom().nextFloat() * 0.4f + 0.8f));
                        this.guardian.level().addFreshEntity((Entity)$$2);
                        this.guardian.setTarget(null);
                        this.guardian.level().broadcastEntityEvent((Entity)this.guardian, (byte)5);
                    }
                    super.tick();
                }
            }
        }
    }

    private static class GuardianAttackSelector
    implements TargetingConditions.Selector {
        private final BubzeEntity guardian;

        public GuardianAttackSelector(BubzeEntity p_32879_) {
            this.guardian = p_32879_;
        }

        public boolean test(@Nullable LivingEntity p_32881_, ServerLevel p_368284_) {
            return (p_32881_ instanceof Player || p_32881_ instanceof Squid || p_32881_ instanceof Axolotl) && p_32881_.distanceToSqr((Entity)this.guardian) > 9.0;
        }
    }
}

