/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity;

import com.belgie.tricky_trials.core.TTGameRules;
import com.belgie.tricky_trials.core.TTItemRegistry;
import com.belgie.tricky_trials.core.TTLoottables;
import com.belgie.tricky_trials.core.TTSoundRegistry;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CopperGolemEntity
extends AbstractGolem
implements VariantHolder<Type> {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.defineId(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Integer> OXIDIZED_DATA = SynchedEntityData.defineId(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Boolean> WAXED_DATA = SynchedEntityData.defineId(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> POWERED_DATA = SynchedEntityData.defineId(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static Supplier<ImmutableBiMap<Object, Object>> NEXT_BY_BLOCK = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)Blocks.COPPER_BLOCK, (Object)Blocks.EXPOSED_COPPER).put((Object)Blocks.EXPOSED_COPPER, (Object)Blocks.WEATHERED_COPPER).put((Object)Blocks.WEATHERED_COPPER, (Object)Blocks.OXIDIZED_COPPER).put((Object)Blocks.CUT_COPPER, (Object)Blocks.EXPOSED_CUT_COPPER).put((Object)Blocks.EXPOSED_CUT_COPPER, (Object)Blocks.WEATHERED_CUT_COPPER).put((Object)Blocks.WEATHERED_CUT_COPPER, (Object)Blocks.OXIDIZED_CUT_COPPER).put((Object)Blocks.CHISELED_COPPER, (Object)Blocks.EXPOSED_CHISELED_COPPER).put((Object)Blocks.EXPOSED_CHISELED_COPPER, (Object)Blocks.WEATHERED_CHISELED_COPPER).put((Object)Blocks.WEATHERED_CHISELED_COPPER, (Object)Blocks.OXIDIZED_CHISELED_COPPER).put((Object)Blocks.CUT_COPPER_SLAB, (Object)Blocks.EXPOSED_CUT_COPPER_SLAB).put((Object)Blocks.EXPOSED_CUT_COPPER_SLAB, (Object)Blocks.WEATHERED_CUT_COPPER_SLAB).put((Object)Blocks.WEATHERED_CUT_COPPER_SLAB, (Object)Blocks.OXIDIZED_CUT_COPPER_SLAB).put((Object)Blocks.CUT_COPPER_STAIRS, (Object)Blocks.EXPOSED_CUT_COPPER_STAIRS).put((Object)Blocks.EXPOSED_CUT_COPPER_STAIRS, (Object)Blocks.WEATHERED_CUT_COPPER_STAIRS).put((Object)Blocks.WEATHERED_CUT_COPPER_STAIRS, (Object)Blocks.OXIDIZED_CUT_COPPER_STAIRS).put((Object)Blocks.COPPER_DOOR, (Object)Blocks.EXPOSED_COPPER_DOOR).put((Object)Blocks.EXPOSED_COPPER_DOOR, (Object)Blocks.WEATHERED_COPPER_DOOR).put((Object)Blocks.WEATHERED_COPPER_DOOR, (Object)Blocks.OXIDIZED_COPPER_DOOR).put((Object)Blocks.COPPER_TRAPDOOR, (Object)Blocks.EXPOSED_COPPER_TRAPDOOR).put((Object)Blocks.EXPOSED_COPPER_TRAPDOOR, (Object)Blocks.WEATHERED_COPPER_TRAPDOOR).put((Object)Blocks.WEATHERED_COPPER_TRAPDOOR, (Object)Blocks.OXIDIZED_COPPER_TRAPDOOR).put((Object)Blocks.COPPER_GRATE, (Object)Blocks.EXPOSED_COPPER_GRATE).put((Object)Blocks.EXPOSED_COPPER_GRATE, (Object)Blocks.WEATHERED_COPPER_GRATE).put((Object)Blocks.WEATHERED_COPPER_GRATE, (Object)Blocks.OXIDIZED_COPPER_GRATE).put((Object)Blocks.COPPER_BULB, (Object)Blocks.EXPOSED_COPPER_BULB).put((Object)Blocks.EXPOSED_COPPER_BULB, (Object)Blocks.WEATHERED_COPPER_BULB).put((Object)Blocks.WEATHERED_COPPER_BULB, (Object)Blocks.OXIDIZED_COPPER_BULB).build());
    public AnimationState Freeze = new AnimationState();
    public AnimationState Idle = new AnimationState();
    public AnimationState Strike = new AnimationState();
    public AnimationState Waking = new AnimationState();
    public int ClickDelay = 0;

    public CopperGolemEntity(EntityType<? extends AbstractGolem> p_27508_, Level p_27509_) {
        super(p_27508_, p_27509_);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    static Optional<Block> getNext(Block p_154905_) {
        return Optional.ofNullable((Block)((BiMap)NEXT_BY_BLOCK.get()).get((Object)p_154905_));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, 0.310015).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public void SetClickDelay(int stage) {
        this.ClickDelay = stage;
    }

    public int getClickDelay() {
        return this.ClickDelay;
    }

    public void setOxidizationStage(int stage) {
        this.entityData.set(OXIDIZED_DATA, (Object)stage);
    }

    public int getOxidizationStage() {
        return (Integer)this.entityData.get(OXIDIZED_DATA);
    }

    public Type getVariant() {
        return Type.byId((Integer)this.entityData.get(DATA_TYPE_ID));
    }

    public void setVariant(Type p_28465_) {
        this.entityData.set(DATA_TYPE_ID, (Object)p_28465_.getId());
    }

    public void setWaxed(boolean iswaxed) {
        this.entityData.set(WAXED_DATA, (Object)iswaxed);
    }

    public boolean isWaxed() {
        return (Boolean)this.entityData.get(WAXED_DATA);
    }

    public void setPowered(boolean iswaxed) {
        this.entityData.set(POWERED_DATA, (Object)iswaxed);
    }

    public boolean isPowered() {
        return (Boolean)this.entityData.get(POWERED_DATA);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_334599_) {
        super.defineSynchedData(p_334599_);
        p_334599_.define(DATA_TYPE_ID, (Object)0);
        p_334599_.define(OXIDIZED_DATA, (Object)0);
        p_334599_.define(WAXED_DATA, (Object)false);
        p_334599_.define(POWERED_DATA, (Object)false);
    }

    public boolean isInvulnerableTo(ServerLevel sl, DamageSource p_219427_) {
        return p_219427_.is(DamageTypeTags.IS_FIRE) || p_219427_.is(DamageTypeTags.IS_LIGHTNING) || this.getOxidizationStage() == 3 && !p_219427_.is(DamageTypeTags.BYPASSES_INVULNERABILITY) || super.isInvulnerableTo(sl, p_219427_);
    }

    public void tick() {
        Level level;
        super.tick();
        this.setPowered(this.level().isThundering());
        if (this.level().isClientSide) {
            this.Idle.animateWhen(!this.walkAnimation.isMoving() && this.getOxidizationStage() != 3, this.tickCount);
            this.Freeze.animateWhen(this.getOxidizationStage() == 3, this.tickCount);
        }
        if (this.ClickDelay != 0) {
            --this.ClickDelay;
        }
        if (!this.level().isClientSide && (level = this.level()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if (this.getVariant() != Type.OXIDIZED && !this.isWaxed() && this.level().random.nextInt(sl.getGameRules().getInt(TTGameRules.RULE_COPPER_GOLEM_0XIDIZE)) == 0 && (double)this.random.nextFloat() < 0.01) {
                this.IncreaseOxidizedStage();
            }
            if (this.getOxidizationStage() == 3) {
                this.setVariant(Type.OXIDIZED);
                this.SetStatue();
            }
            if (this.getOxidizationStage() == 0) {
                this.setVariant(Type.NONE);
            }
            if (this.getOxidizationStage() == 1) {
                this.setVariant(Type.EXPOSED);
            }
            if (this.getOxidizationStage() == 2) {
                this.setVariant(Type.WEATHERED);
            }
        }
        if (this.level().getRandom().nextInt(this.getVariant().getOxidizedChance()) == 0 && this.IsSutableGolem()) {
            this.TickAreaForCopperBlocks();
        }
    }

    public void TickAreaForCopperBlocks() {
        Iterable BOOKSHELF_OFFSETS = BlockPos.withinManhattan((BlockPos)this.getOnPos(), (int)8, (int)8, (int)8);
        for (BlockPos pos : BOOKSHELF_OFFSETS) {
            BlockState block = this.level().getBlockState(pos);
            if (!(block.getBlock() instanceof WeatheringCopper) || !CopperGolemEntity.getNext(block.getBlock()).isPresent()) continue;
            this.level().setBlock(pos, CopperGolemEntity.getNext(block.getBlock()).get().defaultBlockState(), 2);
        }
    }

    public boolean canSpawnSprintParticle() {
        return this.getOxidizationStage() != 3 && this.getDeltaMovement().horizontalDistanceSqr() > 2.500000277905201E-7 && this.random.nextInt(5) == 0;
    }

    public void addAdditionalSaveData(CompoundTag p_28867_) {
        super.addAdditionalSaveData(p_28867_);
        p_28867_.putInt("Oxidized", this.getOxidizationStage());
        p_28867_.putBoolean("Waxed", this.isWaxed());
        p_28867_.putString("Type", this.getVariant().getSerializedName());
        p_28867_.putBoolean("Powered", this.isPowered());
    }

    public void readAdditionalSaveData(CompoundTag p_28857_) {
        super.readAdditionalSaveData(p_28857_);
        this.setOxidizationStage(p_28857_.getByte("Oxidized"));
        this.setWaxed(p_28857_.getBoolean("Waxed"));
        this.setVariant(Type.byName(p_28857_.getString("Type")));
        this.setPowered(p_28857_.getBoolean("Powered"));
    }

    public void thunderHit(ServerLevel p_19927_, LightningBolt p_19928_) {
        this.RemoveOxidizedStage();
        super.thunderHit(p_19927_, p_19928_);
    }

    public void IncreaseOxidizedStage() {
        if (this.getOxidizationStage() < 3) {
            this.setOxidizationStage(this.getOxidizationStage() + 1);
        }
    }

    public void SetStatue() {
        this.getNavigation().setSpeedModifier(0.0);
        this.getNavigation().stop();
        this.getMoveControl().setWantedPosition(this.getX(), this.getY(), this.getZ(), 0.0);
        this.getMoveControl().tick();
    }

    public void RemoveOxidizedStage() {
        this.setOxidizationStage(this.getOxidizationStage() - 1);
    }

    public InteractionResult mobInteract(Player p_28298_, InteractionHand p_28299_) {
        ItemStack itemstack = p_28298_.getItemInHand(p_28299_);
        if (itemstack.is(Items.HONEYCOMB) && !this.isBaby() && !this.isWaxed()) {
            float f1 = 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
            this.playSound(SoundEvents.HONEYCOMB_WAX_ON, 1.0f, f1);
            p_28298_.level().levelEvent(p_28298_, 3003, this.blockPosition(), 0);
            this.setWaxed(true);
            if (!p_28298_.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (itemstack.is(TTItemRegistry.COPPER_WIRE.get()) && !this.isBaby() && this.IsSutableGolem() && !this.level().isThundering() && this.getClickDelay() == 0) {
            float f1 = 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
            this.playSound(SoundEvents.ITEM_PICKUP, 1.0f, f1);
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.SetClickDelay(100);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                level2.setWeatherParameters(0, 0, true, true);
            }
            LightningBolt bolt = new LightningBolt(EntityType.LIGHTNING_BOLT, this.level());
            bolt.moveTo(this.position());
            this.level().addFreshEntity((Entity)bolt);
            this.level().gameEvent((Holder)GameEvent.ENTITY_PLACE, this.blockPosition(), GameEvent.Context.of((Entity)this));
            if (!p_28298_.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (itemstack.is(ItemTags.AXES) && !this.isBaby() && this.getOxidizationStage() > 0 && !this.isWaxed()) {
            p_28298_.level().playSound(p_28298_, this.blockPosition(), SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
            p_28298_.level().levelEvent(p_28298_, 3005, this.blockPosition(), 0);
            if (this.getVariant() == Type.OXIDIZED) {
                this.level().broadcastEntityEvent((Entity)this, (byte)67);
            }
            this.RemoveOxidizedStage();
            if (!p_28298_.getAbilities().instabuild) {
                itemstack.hurtAndBreak(1, (LivingEntity)p_28298_, EquipmentSlot.MAINHAND);
            }
            return InteractionResult.SUCCESS;
        }
        if (itemstack.is(ItemTags.AXES) && !this.isBaby() && this.isWaxed()) {
            p_28298_.level().playSound(p_28298_, this.blockPosition(), SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
            p_28298_.level().levelEvent(p_28298_, 3004, this.blockPosition(), 0);
            this.setWaxed(false);
            if (!p_28298_.getAbilities().instabuild) {
                itemstack.hurtAndBreak(1, (LivingEntity)p_28298_, EquipmentSlot.MAINHAND);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(p_28298_, p_28299_);
    }

    public void handleEntityEvent(byte p_21375_) {
        if (p_21375_ == 60) {
            this.Strike.start(this.tickCount);
        }
        if (p_21375_ == 67) {
            this.Waking.start(this.tickCount);
        }
        super.handleEntityEvent(p_21375_);
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)TTSoundRegistry.COPPER_GOLEM_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource p_27517_) {
        return (SoundEvent)TTSoundRegistry.COPPER_GOLEM_HURT.get();
    }

    public void travel(Vec3 p_250068_) {
        if (this.getVariant() == Type.OXIDIZED && this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.0, 1.0, 0.0));
            p_250068_ = p_250068_.multiply(0.0, 1.0, 0.0);
        }
        super.travel(p_250068_);
    }

    protected void playStepSound(BlockPos p_34526_, BlockState p_34527_) {
        this.playSound((SoundEvent)TTSoundRegistry.COPPER_GOLEM_STEP.get(), 0.15f, 1.0f);
    }

    public void aiStep() {
        if (!this.level().isClientSide && this.level().isThundering() && this.IsSutableGolem() && this.level().getRandom().nextInt(this.getVariant().getLightningChance()) == 0) {
            LightningBolt bolt = new LightningBolt(EntityType.LIGHTNING_BOLT, this.level());
            List Entities = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(8.0));
            for (LivingEntity livingEntity : Entities) {
                if (livingEntity instanceof TamableAnimal || livingEntity instanceof CopperGolemEntity || livingEntity instanceof Player || !this.level().canSeeSky(livingEntity.blockPosition())) continue;
                bolt.moveTo(livingEntity.position());
                this.level().broadcastEntityEvent((Entity)this, (byte)60);
                this.level().addFreshEntity((Entity)bolt);
                this.level().gameEvent((Holder)GameEvent.ENTITY_PLACE, livingEntity.blockPosition(), GameEvent.Context.of((Entity)this));
            }
        }
        super.aiStep();
    }

    public boolean IsSutableGolem() {
        return this.getVariant() != Type.OXIDIZED;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean removeWhenFarAway(double p_27519_) {
        return false;
    }

    protected void dropFromLootTable(ServerLevel sl, DamageSource p_21389_, boolean p_21390_) {
        if (this.getVariant() == Type.NONE) {
            ItemStack $$5 = CopperGolemEntity.getRandomDisplayItemFromLootTable(sl, this.blockPosition(), TTLoottables.COPPER_GOLEM_NORMAL);
            this.spawnAtLocation(sl, $$5);
        } else if (this.getVariant() == Type.EXPOSED) {
            ItemStack $$5 = CopperGolemEntity.getRandomDisplayItemFromLootTable(sl, this.blockPosition(), TTLoottables.COPPER_GOLEM_EXPOSED);
            this.spawnAtLocation(sl, $$5);
        } else if (this.getVariant() == Type.WEATHERED) {
            ItemStack $$5 = CopperGolemEntity.getRandomDisplayItemFromLootTable(sl, this.blockPosition(), TTLoottables.COPPER_GOLEM_WEATHERED);
            this.spawnAtLocation(sl, $$5);
        } else if (this.getVariant() == Type.OXIDIZED) {
            ItemStack $$5 = CopperGolemEntity.getRandomDisplayItemFromLootTable(sl, this.blockPosition(), TTLoottables.COPPER_GOLEM_OXIDIZED);
            this.spawnAtLocation(sl, $$5);
        }
    }

    private static ItemStack getRandomDisplayItemFromLootTable(ServerLevel p_329309_, BlockPos p_331772_, ResourceKey<LootTable> p_327947_) {
        LootParams $$4;
        LootTable $$3 = p_329309_.getServer().reloadableRegistries().getLootTable(p_327947_);
        ObjectArrayList $$5 = $$3.getRandomItems($$4 = new LootParams.Builder(p_329309_).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)p_331772_)).create(LootContextParamSets.VAULT), p_329309_.getRandom());
        return $$5.isEmpty() ? ItemStack.EMPTY : (ItemStack)Util.getRandom((List)$$5, (RandomSource)p_329309_.getRandom());
    }

    protected BodyRotationControl createBodyControl() {
        return new CamelBodyRotationControl(this);
    }

    public static enum Type implements StringRepresentable
    {
        NONE(0, "none", 200, 4000),
        EXPOSED(1, "exposed", 150, 3000),
        WEATHERED(2, "weathered", 100, 2000),
        OXIDIZED(3, "oxidized", 50, 1000);

        public static final StringRepresentable.EnumCodec<Type> CODEC;
        private static final IntFunction<Type> BY_ID;
        private final int id;
        private final String name;
        public final int lightning_chance;
        public final int oxidized_chance;

        private Type(int p_196658_, String p_196659_, int chance, int ox) {
            this.id = p_196658_;
            this.name = p_196659_;
            this.lightning_chance = chance;
            this.oxidized_chance = ox;
        }

        public String getSerializedName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public int getLightningChance() {
            return this.lightning_chance;
        }

        public int getOxidizedChance() {
            return this.oxidized_chance;
        }

        public static Type byName(String p_28817_) {
            return (Type)CODEC.byName(p_28817_, (Enum)NONE);
        }

        public static Type byId(int p_28813_) {
            return BY_ID.apply(p_28813_);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
            BY_ID = ByIdMap.continuous(Type::getId, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }

    class CamelBodyRotationControl
    extends BodyRotationControl {
        public CamelBodyRotationControl(CopperGolemEntity p_248635_) {
            super((Mob)p_248635_);
        }

        public void clientTick() {
            if (CopperGolemEntity.this.getVariant() != Type.OXIDIZED) {
                super.clientTick();
            }
        }
    }
}

