/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity;

import com.belgie.tricky_trials.common.entity.AI.GrunterAI;
import com.belgie.tricky_trials.core.TTBlockRegistry;
import com.belgie.tricky_trials.core.TTEntityRegistry;
import com.belgie.tricky_trials.core.TTSoundRegistry;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.hoglin.HoglinBase;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class GrunterEntity
extends Animal
implements Enemy,
HoglinBase {
    private static final float PROBABILITY_OF_SPAWNING_AS_BABY = 0.2f;
    private static final int MAX_HEALTH = 40;
    private static final float MOVEMENT_SPEED_WHEN_FIGHTING = 0.3f;
    private static final int ATTACK_KNOCKBACK = 1;
    private static final float KNOCKBACK_RESISTANCE = 0.6f;
    private static final int ATTACK_DAMAGE = 6;
    private static final float BABY_ATTACK_DAMAGE = 0.5f;
    private static final int CONVERSION_TIME = 300;
    private int attackAnimationRemainingTicks;
    private int timeInOverworld;
    private boolean cannotBeHunted;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super GrunterEntity>>> SENSOR_TYPES;
    protected static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES;
    public AnimationState idle = new AnimationState();
    public AnimationState walk = new AnimationState();

    public GrunterEntity(EntityType<? extends GrunterEntity> p_34488_, Level p_34489_) {
        super(p_34488_, p_34489_);
        this.xpReward = 5;
    }

    public boolean dampensVibrations() {
        return true;
    }

    public boolean canBeLeashed() {
        return true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.KNOCKBACK_RESISTANCE, (double)0.6f).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.FOLLOW_RANGE, 8.0);
    }

    public boolean doHurtTarget(ServerLevel p_365421_, Entity p_34491_) {
        if (!(p_34491_ instanceof LivingEntity)) {
            return false;
        }
        this.attackAnimationRemainingTicks = 10;
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        this.makeSound((SoundEvent)TTSoundRegistry.GRUNTER_ATTACK.get());
        GrunterAI.onHitTarget(this, (LivingEntity)p_34491_);
        return HoglinBase.hurtAndThrowTarget((ServerLevel)p_365421_, (LivingEntity)this, (LivingEntity)((LivingEntity)p_34491_));
    }

    protected void blockedByShield(LivingEntity p_34550_) {
        if (this.isAdult()) {
            HoglinBase.throwTarget((LivingEntity)this, (LivingEntity)p_34550_);
        }
    }

    public boolean hurtServer(ServerLevel p_361743_, DamageSource p_361865_, float p_365677_) {
        boolean flag = super.hurtServer(p_361743_, p_361865_, p_365677_);
        if (this.level().isClientSide) {
            return false;
        }
        if (flag && p_361865_.getEntity() instanceof LivingEntity) {
            GrunterAI.wasHurtBy(p_361743_, this, (LivingEntity)p_361865_.getEntity());
        }
        return flag;
    }

    protected Brain.Provider<GrunterEntity> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> p_34514_) {
        return GrunterAI.makeBrain((Brain<GrunterEntity>)this.brainProvider().makeBrain(p_34514_));
    }

    public static boolean checkGrunterSpawnRules(EntityType<? extends GrunterEntity> p_219020_, LevelAccessor p_219021_, EntitySpawnReason p_219022_, BlockPos p_219023_, RandomSource p_219024_) {
        return p_219021_.getDifficulty() != Difficulty.PEACEFUL && GrunterEntity.checkMobSpawnRules(p_219020_, (LevelAccessor)p_219021_, (EntitySpawnReason)p_219022_, (BlockPos)p_219023_, (RandomSource)p_219024_);
    }

    public Brain<GrunterEntity> getBrain() {
        return super.getBrain();
    }

    protected void customServerAiStep(ServerLevel p_363493_) {
        ProfilerFiller $$1 = Profiler.get();
        $$1.push("grunterBrain");
        this.getBrain().tick(p_363493_, (LivingEntity)this);
        $$1.pop();
        super.customServerAiStep(p_363493_);
        GrunterAI.updateActivity(this);
    }

    public void aiStep() {
        if (this.attackAnimationRemainingTicks > 0) {
            --this.attackAnimationRemainingTicks;
        }
        super.aiStep();
    }

    protected void ageBoundaryReached() {
        if (this.isBaby()) {
            this.xpReward = 3;
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(0.5);
        } else {
            this.xpReward = 5;
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(6.0);
        }
    }

    public static boolean checkHoglinSpawnRules(EntityType<GrunterEntity> p_219182_, LevelAccessor p_219183_, EntitySpawnReason p_219184_, BlockPos p_219185_, RandomSource p_219186_) {
        return p_219183_.getBlockState(p_219185_.below()).is(Blocks.SCULK) || p_219183_.getBlockState(p_219185_.below()).is(TTBlockRegistry.TRIAL_BLOCK.get()) || p_219183_.getBlockState(p_219185_.below()).is(TTBlockRegistry.TRIAL_MOSAIC.get());
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_34508_, DifficultyInstance p_34509_, EntitySpawnReason p_34510_, @Nullable SpawnGroupData p_34511_) {
        if (p_34508_.getRandom().nextFloat() < 0.2f) {
            this.setBaby(true);
        }
        return super.finalizeSpawn(p_34508_, p_34509_, p_34510_, p_34511_);
    }

    public boolean removeWhenFarAway(double p_34559_) {
        return !this.isPersistenceRequired();
    }

    public float getWalkTargetValue(BlockPos p_34516_, LevelReader p_34517_) {
        if (GrunterAI.isPosNearNearestRepellent(this, p_34516_)) {
            return -1.0f;
        }
        return p_34517_.getBlockState(p_34516_.below()).is(Blocks.SCULK) ? 10.0f : 0.0f;
    }

    public InteractionResult mobInteract(Player p_34523_, InteractionHand p_34524_) {
        InteractionResult interactionresult = super.mobInteract(p_34523_, p_34524_);
        if (interactionresult.consumesAction()) {
            this.setPersistenceRequired();
        }
        return interactionresult;
    }

    public void handleEntityEvent(byte p_34496_) {
        if (p_34496_ == 4) {
            this.attackAnimationRemainingTicks = 10;
            this.makeSound((SoundEvent)TTSoundRegistry.GRUNTER_ATTACK.get());
        } else {
            super.handleEntityEvent(p_34496_);
        }
    }

    public float getVoicePitch() {
        return -2.0f;
    }

    public int getAttackAnimationRemainingTicks() {
        return this.attackAnimationRemainingTicks;
    }

    public boolean shouldDropExperience() {
        return true;
    }

    protected int getBaseExperienceReward() {
        return this.xpReward;
    }

    public boolean isFood(ItemStack p_34562_) {
        return p_34562_.is(Items.SCULK_SENSOR);
    }

    public boolean isAdult() {
        return !this.isBaby();
    }

    public void tick() {
        if (this.level().isClientSide) {
            this.idle.animateWhen(!this.walkAnimation.isMoving(), this.tickCount);
        }
        super.tick();
    }

    public void addAdditionalSaveData(CompoundTag p_34529_) {
        super.addAdditionalSaveData(p_34529_);
        if (this.cannotBeHunted) {
            p_34529_.putBoolean("CannotBeHunted", true);
        }
    }

    public void readAdditionalSaveData(CompoundTag p_34519_) {
        super.readAdditionalSaveData(p_34519_);
        this.setCannotBeHunted(p_34519_.getBoolean("CannotBeHunted"));
    }

    private void setCannotBeHunted(boolean p_34567_) {
        this.cannotBeHunted = p_34567_;
    }

    public boolean canBeHunted() {
        return this.isAdult() && !this.cannotBeHunted;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_149900_, AgeableMob p_149901_) {
        return null;
    }

    public boolean canFallInLove() {
        return !GrunterAI.isPacified(this) && super.canFallInLove();
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent getAmbientSound() {
        return this.level().isClientSide ? null : (SoundEvent)GrunterAI.getSoundForCurrentActivity(this).orElse(null);
    }

    protected SoundEvent getHurtSound(DamageSource p_34548_) {
        return (SoundEvent)TTSoundRegistry.GRUNTER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TTSoundRegistry.GRUNTER_DEATH.get();
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.HOSTILE_SWIM;
    }

    protected SoundEvent getSwimSplashSound() {
        return SoundEvents.HOSTILE_SPLASH;
    }

    protected void playStepSound(BlockPos p_34526_, BlockState p_34527_) {
        this.playSound((SoundEvent)TTSoundRegistry.GRUNTER_STEP.get(), 0.15f, 1.0f);
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.getTargetFromBrain();
    }

    static {
        MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.BREED_TARGET, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLIN, (Object[])new MemoryModuleType[]{MemoryModuleType.AVOID_TARGET});
        SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.NEAREST_ADULT, TTEntityRegistry.GRUNTER_SPECIFIC_SENSOR.get());
    }
}

