/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.tricky_trials.common.entity;

import com.belgie.tricky_trials.common.entity.CopperSpikeEntity;
import com.belgie.tricky_trials.common.entity.HeavyCoreBullet;
import com.belgie.tricky_trials.common.entity.MagicBossEntity;
import com.belgie.tricky_trials.core.TTSoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HeavyCoreBoss
extends MagicBossEntity {
    private static final ProjectileDeflection PROJECTILE_DEFLECTION = (p_341445_, p_341446_, p_341447_) -> {
        p_341446_.level().playSound((Player)null, p_341446_, (SoundEvent)TTSoundRegistry.TRIAL_KNIGHT_DEFLECT.get(), p_341446_.getSoundSource(), 1.0f, 1.0f);
        ProjectileDeflection.REVERSE.deflect(p_341445_, p_341446_, p_341447_);
    };
    private final ServerBossEvent bossEvent;
    public AnimationState idle = new AnimationState();
    public AnimationState slide = new AnimationState();
    public AnimationState shoot = new AnimationState();
    public AnimationState attack = new AnimationState();
    public AnimationState summon = new AnimationState();
    public int shootDelay;
    public int SpawningTicks;

    public HeavyCoreBoss(EntityType<? extends HeavyCoreBoss> p_32627_, Level p_32628_) {
        super(p_32627_, p_32628_);
        this.xpReward = 100;
        this.bossEvent = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.NOTCHED_6).setCreateWorldFog(true);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new EvokerCastingSpellGoal());
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)1.1f, true));
        this.goalSelector.addGoal(4, (Goal)new EvokerSummonSpellGoal());
        this.goalSelector.addGoal(6, (Goal)new HeavyBossAttackCheaters(this, (Mob)this));
        this.goalSelector.addGoal(5, (Goal)new EvokerAttackSpellGoal());
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{HeavyCoreBoss.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.35).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 1.5).add(Attributes.FOLLOW_RANGE, 12.0).add(Attributes.MAX_HEALTH, 300.0);
    }

    public void startSeenByPlayer(ServerPlayer p_31483_) {
        super.startSeenByPlayer(p_31483_);
        this.bossEvent.addPlayer(p_31483_);
    }

    public void stopSeenByPlayer(ServerPlayer p_31488_) {
        super.stopSeenByPlayer(p_31488_);
        this.bossEvent.removePlayer(p_31488_);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_333469_) {
        super.defineSynchedData(p_333469_);
    }

    @Override
    protected void customServerAiStep(ServerLevel sl) {
        this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
        super.customServerAiStep(sl);
    }

    @Override
    protected SoundEvent getCastingSoundEvent() {
        return (SoundEvent)TTSoundRegistry.TRIAL_KNIGHT_SHOOT_PRE.get();
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_21450_) {
        this.setShootTicks(p_21450_.getInt("ShootTicks"));
        this.setSpawningTicks(p_21450_.getInt("SpawningTicks"));
        super.readAdditionalSaveData(p_21450_);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_21484_) {
        p_21484_.putInt("ShootTicks", this.shootDelay);
        p_21484_.putInt("SpawningTicks", this.SpawningTicks);
        super.addAdditionalSaveData(p_21484_);
    }

    private void setShootTicks(int p_34567_) {
        this.shootDelay = p_34567_;
    }

    private void setSpawningTicks(int p_34567_) {
        this.SpawningTicks = p_34567_;
    }

    public boolean canAttackType(EntityType<?> p_28851_) {
        LivingEntity livingEntity = this.getTarget();
        if (livingEntity instanceof Player) {
            Player p = (Player)livingEntity;
            return !p.isCreative() && !p.isSpectator();
        }
        return true;
    }

    protected int decreaseAirSupply(int p_28882_) {
        return p_28882_;
    }

    protected void doPush(Entity p_28839_) {
        if (p_28839_ instanceof Enemy && !(p_28839_ instanceof Creeper) && this.getRandom().nextInt(20) == 0) {
            this.setTarget((LivingEntity)p_28839_);
        }
        super.doPush(p_28839_);
    }

    @Override
    public void tick() {
        if (this.level().isClientSide()) {
            this.idle.animateWhen(!this.walkAnimation.isMoving() && !this.summon.isStarted() && !this.isDeadOrDying(), this.tickCount);
            this.slide.animateWhen(this.walkAnimation.isMoving() && !this.shoot.isStarted() && !this.isDeadOrDying(), this.tickCount);
        }
        super.tick();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_219422_) {
        if (DATA_POSE.equals(p_219422_)) {
            switch (this.getPose()) {
                case EMERGING: {
                    this.summon.start(this.tickCount);
                    break;
                }
                case STANDING: {
                    this.summon.stop();
                }
            }
        }
        super.onSyncedDataUpdated(p_219422_);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, EntitySpawnReason p_21436_, @Nullable SpawnGroupData p_21437_) {
        if (p_21436_ == EntitySpawnReason.TRIGGERED) {
            this.setPose(Pose.EMERGING);
            this.SpawningTicks = 140;
        }
        return super.finalizeSpawn(p_21434_, p_21435_, p_21436_, p_21437_);
    }

    public void handleEntityEvent(byte p_21375_) {
        if (p_21375_ == 65) {
            this.shoot.start(this.tickCount);
            this.idle.stop();
            this.slide.stop();
        } else if (p_21375_ == 66) {
            this.shoot.stop();
            this.playSound((SoundEvent)TTSoundRegistry.TRIAL_KNIGHT_SHOOT.get(), 1.0f, 1.0f);
        } else if (p_21375_ == 4) {
            this.attack.start(this.tickCount);
            this.idle.stop();
            this.slide.stop();
        }
        super.handleEntityEvent(p_21375_);
    }

    public void travel(Vec3 p_250068_) {
        if (this.hasPose(Pose.EMERGING)) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.0, 1.0, 0.0));
            p_250068_ = p_250068_.multiply(0.0, 1.0, 0.0);
        }
        super.travel(p_250068_);
    }

    public void aiStep() {
        super.aiStep();
        if (this.shootDelay > 0) {
            --this.shootDelay;
        }
        if (this.SpawningTicks > 0) {
            --this.SpawningTicks;
        }
        if (this.shootDelay == 0) {
            this.level().broadcastEntityEvent((Entity)this, (byte)66);
        }
        if (this.SpawningTicks < 10 && this.SpawningTicks > 0) {
            this.setPose(Pose.STANDING);
        }
    }

    public void ResetAnimations() {
        this.summon.stop();
        this.shoot.stop();
        this.slide.stop();
        this.attack.stop();
        this.idle.stop();
    }

    public boolean canSpawnSprintParticle() {
        return this.getDeltaMovement().horizontalDistanceSqr() > 2.500000277905201E-7 && this.random.nextInt(5) == 0;
    }

    private float getAttackDamage() {
        return (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
    }

    public boolean doHurtTarget(ServerLevel sl, Entity p_28837_) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        float $$1 = this.getAttackDamage();
        float $$2 = (int)$$1 > 0 ? $$1 / 2.0f + (float)this.random.nextInt((int)$$1) : $$1;
        boolean $$3 = p_28837_.hurtServer(sl, this.damageSources().mobAttack((LivingEntity)this), $$2);
        if ($$3) {
            if (p_28837_ instanceof LivingEntity) {
                LivingEntity $$4 = (LivingEntity)p_28837_;
                double var10000 = $$4.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
            } else {
                double var10000 = 0.0;
            }
            this.strongKnockback(p_28837_);
        }
        this.playSound((SoundEvent)TTSoundRegistry.TRIAL_KNIGHT_ATTACK.get(), 1.0f, 1.0f);
        return $$3;
    }

    private void strongKnockback(Entity p_33340_) {
        double d0 = p_33340_.getX() - this.getX();
        double d1 = p_33340_.getZ() - this.getZ();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        p_33340_.push(d0 / d2 * 3.0, 0.2, d1 / d2 * 3.0);
    }

    public boolean hurtServer(ServerLevel sl, DamageSource p_28848_, float p_28849_) {
        if (this.hasPose(Pose.EMERGING)) {
            return false;
        }
        Crackiness.Level $$2 = this.getCrackiness();
        boolean $$3 = super.hurtServer(sl, p_28848_, p_28849_);
        if ($$3 && this.getCrackiness() != $$2) {
            this.playSound((SoundEvent)TTSoundRegistry.TRIAL_KNIGHT_HURT.get(), 1.0f, 1.0f);
        }
        return $$3;
    }

    public Crackiness.Level getCrackiness() {
        return Crackiness.GOLEM.byFraction(this.getHealth() / this.getMaxHealth());
    }

    protected SoundEvent getHurtSound(DamageSource p_28872_) {
        return (SoundEvent)TTSoundRegistry.TRIAL_KNIGHT_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TTSoundRegistry.TRIAL_KNIGHT_DEATH.get();
    }

    public void die(DamageSource p_28846_) {
        this.ResetAnimations();
        super.die(p_28846_);
    }

    public boolean removeWhenFarAway(double p_219457_) {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public ProjectileDeflection deflection(Projectile p_335920_) {
        return p_335920_.getType() != EntityType.BREEZE_WIND_CHARGE && p_335920_.getType() != EntityType.WIND_CHARGE ? PROJECTILE_DEFLECTION : ProjectileDeflection.NONE;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TTSoundRegistry.TRIAL_KNIGHT_AMBIENT.get();
    }

    public double getSnoutYPosition() {
        return this.getEyeY() - 0.4;
    }

    public boolean isInvulnerableTo(ServerLevel sl, DamageSource p_309859_) {
        return p_309859_.getEntity() instanceof HeavyCoreBoss || super.isInvulnerableTo(sl, p_309859_);
    }

    public double getFluidJumpThreshold() {
        return this.getEyeHeight();
    }

    public boolean causeFallDamage(float p_310250_, float p_310041_, DamageSource p_311921_) {
        if (p_310250_ > 3.0f) {
            this.playSound(SoundEvents.HEAVY_CORE_FALL, 1.0f, 1.0f);
        }
        return super.causeFallDamage(p_310250_, p_310041_, p_311921_);
    }

    class EvokerCastingSpellGoal
    extends MagicBossEntity.SpellcasterCastingSpellGoal {
        EvokerCastingSpellGoal() {
            super(HeavyCoreBoss.this);
        }

        @Override
        public void tick() {
            if (HeavyCoreBoss.this.getTarget() != null) {
                HeavyCoreBoss.this.getLookControl().setLookAt((Entity)HeavyCoreBoss.this.getTarget(), (float)HeavyCoreBoss.this.getMaxHeadYRot(), (float)HeavyCoreBoss.this.getMaxHeadXRot());
            }
        }
    }

    class EvokerSummonSpellGoal
    extends MagicBossEntity.SpellcasterUseSpellGoal {
        private final TargetingConditions vexCountTargeting;

        EvokerSummonSpellGoal() {
            super(HeavyCoreBoss.this);
            this.vexCountTargeting = TargetingConditions.forNonCombat().range(16.0).ignoreLineOfSight().ignoreInvisibilityTesting();
        }

        @Override
        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            int i = HeavyCoreBoss.this.level().getEntitiesOfClass(Vex.class, HeavyCoreBoss.this.getBoundingBox().inflate(16.0)).size();
            return HeavyCoreBoss.this.random.nextInt(8) + 1 > i;
        }

        @Override
        public boolean canContinueToUse() {
            return HeavyCoreBoss.this.getPose() != Pose.EMERGING;
        }

        @Override
        protected int getCastingTime() {
            return 100;
        }

        @Override
        protected int getCastingInterval() {
            return 340;
        }

        @Override
        protected void performSpellCasting() {
            ServerLevel serverlevel = (ServerLevel)HeavyCoreBoss.this.level();
            for (int i = 0; i < 3; ++i) {
                serverlevel.broadcastEntityEvent((Entity)HeavyCoreBoss.this, (byte)4);
                serverlevel.addFreshEntity((Entity)new HeavyCoreBullet(HeavyCoreBoss.this.level(), (LivingEntity)HeavyCoreBoss.this, (Entity)HeavyCoreBoss.this.getTarget(), HeavyCoreBoss.this.getDirection().getAxis()));
                serverlevel.gameEvent((Holder)GameEvent.ENTITY_PLACE, HeavyCoreBoss.this.blockPosition(), GameEvent.Context.of((Entity)HeavyCoreBoss.this));
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)TTSoundRegistry.TRIAL_KNIGHT_SHOOT_PRE.get();
        }

        @Override
        protected MagicBossEntity.IllagerSpell getSpell() {
            return MagicBossEntity.IllagerSpell.SUMMON_VEX;
        }
    }

    public class HeavyBossAttackCheaters
    extends Goal {
        private final Mob mob;

        public HeavyBossAttackCheaters(HeavyCoreBoss this$0, Mob p_25230_) {
            this.mob = p_25230_;
            p_25230_.getNavigation().setCanFloat(true);
        }

        public boolean canUse() {
            return this.mob.getTarget() != null && !this.mob.isWithinMeleeAttackRange(this.mob.getTarget()) && this.mob.closerThan((Entity)this.mob.getTarget(), 15.0, 20.0);
        }

        public void tick() {
            Level level;
            LivingEntity var10000 = this.mob.getTarget();
            if (var10000 != null && this.mob.closerThan((Entity)var10000, 15.0, 20.0) && (level = this.mob.level()) instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                if (this.mob.level().getRandom().nextInt(20) == 0) {
                    Vec3 $$3 = this.mob.position().add(this.mob.getAttachments().get(EntityAttachment.WARDEN_CHEST, 0, this.mob.getYRot()));
                    Vec3 $$4 = var10000.getEyePosition().subtract($$3);
                    Vec3 $$5 = $$4.normalize();
                    int $$6 = Mth.floor((double)$$4.length()) + 7;
                    for (int $$7 = 1; $$7 < $$6; ++$$7) {
                        Vec3 $$8 = $$3.add($$5.scale((double)$$7));
                        sl.sendParticles((ParticleOptions)ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER, $$8.x, $$8.y, $$8.z, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    this.mob.playSound(SoundEvents.BREEZE_INHALE, 3.0f, 1.0f);
                    if (var10000.hurtServer(sl, sl.damageSources().sonicBoom((Entity)this.mob), 1.0f)) {
                        double $$9 = 0.5 * (1.0 - var10000.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
                        double $$10 = 2.5 * (1.0 - var10000.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
                        var10000.push($$5.x() * $$10, $$5.y() * $$9, $$5.z() * $$10);
                    }
                }
            }
        }
    }

    class EvokerAttackSpellGoal
    extends MagicBossEntity.SpellcasterUseSpellGoal {
        EvokerAttackSpellGoal() {
            super(HeavyCoreBoss.this);
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 100;
        }

        @Override
        public boolean canContinueToUse() {
            return HeavyCoreBoss.this.getTarget() != null && HeavyCoreBoss.this.getPose() != Pose.EMERGING;
        }

        @Override
        protected void performSpellCasting() {
            LivingEntity livingentity = HeavyCoreBoss.this.getTarget();
            double d0 = Math.min(livingentity.getY(), HeavyCoreBoss.this.getY());
            double d1 = Math.max(livingentity.getY(), HeavyCoreBoss.this.getY()) + 1.0;
            float f = (float)Mth.atan2((double)(livingentity.getZ() - HeavyCoreBoss.this.getZ()), (double)(livingentity.getX() - HeavyCoreBoss.this.getX()));
            if (HeavyCoreBoss.this.distanceToSqr((Entity)livingentity) < 9.0) {
                float f2;
                int k;
                for (k = 0; k < 5; ++k) {
                    f2 = f + (float)k * (float)Math.PI * 0.4f;
                    this.createSpellEntity(HeavyCoreBoss.this.getX() + (double)Mth.cos((float)f2) * 1.5, HeavyCoreBoss.this.getZ() + (double)Mth.sin((float)f2) * 1.5, d0, d1, f2, 0);
                }
                for (k = 0; k < 8; ++k) {
                    f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.createSpellEntity(HeavyCoreBoss.this.getX() + (double)Mth.cos((float)f2) * 2.5, HeavyCoreBoss.this.getZ() + (double)Mth.sin((float)f2) * 2.5, d0, d1, f2, 3);
                }
            } else {
                for (int k = 0; k < 16; ++k) {
                    double d2 = 1.25 * (double)(k + 1);
                    int j = 1 * k;
                    this.createSpellEntity(HeavyCoreBoss.this.getX() + (double)Mth.cos((float)f) * d2, HeavyCoreBoss.this.getZ() + (double)Mth.sin((float)f) * d2, d0, d1, f, j);
                }
            }
        }

        private void createSpellEntity(double p_32673_, double p_32674_, double p_32675_, double p_32676_, float p_32677_, int p_32678_) {
            BlockPos blockpos = BlockPos.containing((double)p_32673_, (double)p_32676_, (double)p_32674_);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1 = blockpos.below();
                BlockState blockstate = HeavyCoreBoss.this.level().getBlockState(blockpos1);
                if (!blockstate.isFaceSturdy((BlockGetter)HeavyCoreBoss.this.level(), blockpos1, Direction.UP)) continue;
                if (!HeavyCoreBoss.this.level().isEmptyBlock(blockpos) && !(voxelshape = (blockstate1 = HeavyCoreBoss.this.level().getBlockState(blockpos)).getCollisionShape((BlockGetter)HeavyCoreBoss.this.level(), blockpos)).isEmpty()) {
                    d0 = voxelshape.max(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.below()).getY() >= Mth.floor((double)p_32675_) - 1);
            if (flag) {
                HeavyCoreBoss.this.level().addFreshEntity((Entity)new CopperSpikeEntity(HeavyCoreBoss.this.level(), p_32673_, (double)blockpos.getY() + d0, p_32674_, p_32677_, p_32678_, (LivingEntity)HeavyCoreBoss.this));
                HeavyCoreBoss.this.level().gameEvent((Holder)GameEvent.ENTITY_PLACE, new Vec3(p_32673_, (double)blockpos.getY() + d0, p_32674_), GameEvent.Context.of((Entity)HeavyCoreBoss.this));
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)TTSoundRegistry.TRIAL_KNIGHT_SPAWN_CORE.get();
        }

        @Override
        protected MagicBossEntity.IllagerSpell getSpell() {
            return MagicBossEntity.IllagerSpell.FANGS;
        }
    }
}

